/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.schedule;

import java.util.List;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.phases.graph.ReentrantBlockIterator;
import org.graalvm.word.LocationIdentity;

public final class MemoryScheduleVerification
extends ReentrantBlockIterator.BlockIteratorClosure<EconomicSet<FloatingReadNode>> {
    private final BlockMap<List<Node>> blockToNodesMap;

    public static boolean check(Block startBlock, BlockMap<List<Node>> blockToNodesMap) {
        ReentrantBlockIterator.apply(new MemoryScheduleVerification(blockToNodesMap), startBlock);
        return true;
    }

    private MemoryScheduleVerification(BlockMap<List<Node>> blockToNodesMap) {
        this.blockToNodesMap = blockToNodesMap;
    }

    @Override
    protected EconomicSet<FloatingReadNode> getInitialState() {
        return EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    }

    @Override
    protected EconomicSet<FloatingReadNode> processBlock(Block block, EconomicSet<FloatingReadNode> currentState) {
        AbstractBeginNode beginNode = block.getBeginNode();
        if (beginNode instanceof AbstractMergeNode) {
            AbstractMergeNode abstractMergeNode = (AbstractMergeNode)beginNode;
            for (PhiNode phi : abstractMergeNode.phis()) {
                if (!(phi instanceof MemoryPhiNode)) continue;
                MemoryPhiNode memoryPhiNode = (MemoryPhiNode)phi;
                MemoryScheduleVerification.addFloatingReadUsages(currentState, memoryPhiNode);
            }
        }
        for (Node n : this.blockToNodesMap.get(block)) {
            FloatingReadNode floatingReadNode;
            if (n instanceof MemoryCheckpoint) {
                if (n instanceof MemoryCheckpoint.Single) {
                    MemoryCheckpoint.Single single = (MemoryCheckpoint.Single)((Object)n);
                    this.processLocation(n, single.getKilledLocationIdentity(), currentState);
                } else if (n instanceof MemoryCheckpoint.Multi) {
                    MemoryCheckpoint.Multi multi = (MemoryCheckpoint.Multi)((Object)n);
                    for (LocationIdentity location : multi.getKilledLocationIdentities()) {
                        this.processLocation(n, location, currentState);
                    }
                }
                MemoryScheduleVerification.addFloatingReadUsages(currentState, n);
                continue;
            }
            if (n instanceof MemoryNode) {
                MemoryScheduleVerification.addFloatingReadUsages(currentState, n);
                continue;
            }
            if (!(n instanceof FloatingReadNode) || (floatingReadNode = (FloatingReadNode)n).getLastLocationAccess() == null || !floatingReadNode.getLocationIdentity().isMutable()) continue;
            if (currentState.contains((Object)floatingReadNode)) {
                currentState.remove((Object)floatingReadNode);
                continue;
            }
            throw new RuntimeException("Floating read node " + n + " was not found in the state, i.e., it was killed by a memory check point before its place in the schedule. Block=" + block + ", block begin: " + block.getBeginNode() + " block loop: " + block.getLoop() + ", " + this.blockToNodesMap.get(block).get(0));
        }
        return currentState;
    }

    private static void addFloatingReadUsages(EconomicSet<FloatingReadNode> currentState, Node n) {
        for (FloatingReadNode read : n.usages().filter(FloatingReadNode.class)) {
            if (read.getLastLocationAccess() != n || !read.getLocationIdentity().isMutable()) continue;
            currentState.add((Object)read);
        }
    }

    private void processLocation(Node n, LocationIdentity location, EconomicSet<FloatingReadNode> currentState) {
        assert (n != null);
        if (location.isImmutable()) {
            return;
        }
        for (FloatingReadNode r : this.cloneState(currentState)) {
            if (!r.getLocationIdentity().overlaps(location)) continue;
            r.getDebug().log(3, "%s removing %s from state", (Object)n, (Object)r);
            currentState.remove((Object)r);
        }
    }

    @Override
    protected EconomicSet<FloatingReadNode> merge(Block merge, List<EconomicSet<FloatingReadNode>> states) {
        EconomicSet<FloatingReadNode> result = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            result.retainAll(states.get(i));
        }
        return result;
    }

    @Override
    protected EconomicSet<FloatingReadNode> cloneState(EconomicSet<FloatingReadNode> oldState) {
        EconomicSet result = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        if (oldState != null) {
            result.addAll(oldState);
        }
        return result;
    }

    @Override
    protected List<EconomicSet<FloatingReadNode>> processLoop(Loop<Block> loop, EconomicSet<FloatingReadNode> initialState) {
        HIRLoop l = (HIRLoop)loop;
        for (MemoryPhiNode memoryPhi : ((LoopBeginNode)((Block)l.getHeader()).getBeginNode()).memoryPhis()) {
            for (FloatingReadNode r : this.cloneState(initialState)) {
                if (!r.getLocationIdentity().overlaps(memoryPhi.getLocationIdentity())) continue;
                initialState.remove((Object)r);
            }
        }
        return ReentrantBlockIterator.processLoop(this, loop, initialState).exitStates;
    }
}

