/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import java.util.ArrayDeque;
import java.util.Deque;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;

public abstract class ScopedPostOrderNodeIterator {
    private final Deque<FixedNode> nodeQueue;
    private final NodeBitMap queuedNodes;
    private final Deque<FixedNode> scopes;
    protected FixedNode currentScopeStart;

    public ScopedPostOrderNodeIterator(StructuredGraph graph) {
        this.queuedNodes = graph.createNodeBitMap();
        this.nodeQueue = new ArrayDeque<FixedNode>();
        this.scopes = this.getScopes(graph);
    }

    public void apply() {
        while (!this.scopes.isEmpty()) {
            this.queuedNodes.clearAll();
            this.currentScopeStart = this.scopes.pop();
            this.initializeScope();
            this.processScope();
        }
    }

    public void processScope() {
        FixedNode current;
        this.queue(this.currentScopeStart);
        while ((current = this.nextQueuedNode()) != null) {
            assert (current.isAlive());
            if (current instanceof Invoke) {
                this.invoke((Invoke)((Object)current));
                this.queueSuccessors(current);
                continue;
            }
            if (current instanceof LoopBeginNode) {
                this.queueLoopBeginSuccessors((LoopBeginNode)current);
                continue;
            }
            if (current instanceof LoopExitNode) {
                this.queueLoopExitSuccessors((LoopExitNode)current);
                continue;
            }
            if (current instanceof LoopEndNode) continue;
            if (current instanceof AbstractMergeNode) {
                this.queueSuccessors(current);
                continue;
            }
            if (current instanceof FixedWithNextNode) {
                this.queueSuccessors(current);
                continue;
            }
            if (current instanceof EndNode) {
                this.queueMerge((EndNode)current);
                continue;
            }
            if (current instanceof ControlSinkNode) continue;
            if (current instanceof ControlSplitNode) {
                this.queueSuccessors(current);
                continue;
            }
            assert (false) : current;
        }
    }

    protected void queueLoopBeginSuccessors(LoopBeginNode node) {
        if (this.currentScopeStart == node) {
            this.queue(node.next());
        } else if (this.currentScopeStart instanceof LoopBeginNode) {
            for (LoopExitNode loopExit : node.loopExits()) {
                if (((LoopBeginNode)this.currentScopeStart).loopExits().contains(loopExit)) continue;
                this.queue(loopExit);
            }
        } else {
            this.queue(node.loopExits());
        }
    }

    protected void queueLoopExitSuccessors(LoopExitNode node) {
        if (!(this.currentScopeStart instanceof LoopBeginNode) || !((LoopBeginNode)this.currentScopeStart).loopExits().contains(node)) {
            this.queueSuccessors(node);
        }
    }

    protected Deque<FixedNode> getScopes(StructuredGraph graph) {
        ArrayDeque<FixedNode> result = new ArrayDeque<FixedNode>();
        result.push(graph.start());
        for (LoopBeginNode loopBegin : graph.getNodes(LoopBeginNode.TYPE)) {
            result.push(loopBegin);
        }
        return result;
    }

    private void queueSuccessors(FixedNode x) {
        this.queue(x.successors());
    }

    private void queue(NodeIterable<? extends Node> iter) {
        for (Node node : iter) {
            this.queue(node);
        }
    }

    private void queue(Node node) {
        if (node != null && !this.queuedNodes.isMarked(node)) {
            this.queuedNodes.mark(node);
            this.nodeQueue.addFirst((FixedNode)node);
        }
    }

    private FixedNode nextQueuedNode() {
        if (this.nodeQueue.isEmpty()) {
            return null;
        }
        FixedNode result = this.nodeQueue.removeFirst();
        assert (this.queuedNodes.isMarked(result));
        return result;
    }

    private void queueMerge(AbstractEndNode end) {
        AbstractMergeNode merge = end.merge();
        if (!this.queuedNodes.isMarked(merge) && this.visitedAllEnds(merge)) {
            this.queue(merge);
        }
    }

    private boolean visitedAllEnds(AbstractMergeNode merge) {
        for (int i = 0; i < merge.forwardEndCount(); ++i) {
            if (this.queuedNodes.isMarked(merge.forwardEndAt(i))) continue;
            return false;
        }
        return true;
    }

    protected abstract void initializeScope();

    protected abstract void invoke(Invoke var1);
}

