/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.policy;

import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.inlining.walker.MethodInvocation;

public interface InliningPolicy {
    public boolean continueInlining(StructuredGraph var1);

    public Decision isWorthInlining(Replacements var1, MethodInvocation var2, InlineInfo var3, int var4, boolean var5);

    public static class Decision {
        public static final Decision YES = new Decision(true, "(unknown reason)");
        public static final Decision NO = new Decision(false, "(unknown reason)");
        private final boolean shouldInline;
        private final String reason;

        private Decision(boolean shouldInline, String reason) {
            this.shouldInline = shouldInline;
            this.reason = reason;
        }

        public boolean shouldInline() {
            return this.shouldInline;
        }

        public String getReason() {
            return this.reason;
        }

        public Decision withReason(boolean isTracing, String newReason, Object ... args) {
            if (isTracing) {
                return new Decision(this.shouldInline, String.format(newReason, args));
            }
            return this;
        }
    }
}

