/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.policy;

import java.util.Map;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.inlining.info.elem.Inlineable;
import org.graalvm.compiler.phases.common.inlining.policy.InliningPolicy;

public abstract class AbstractInliningPolicy
implements InliningPolicy {
    public static final float RelevanceCapForInlining = 1.0f;
    public static final float CapInheritedRelevance = 1.0f;
    protected final Map<Invoke, Double> hints;

    public AbstractInliningPolicy(Map<Invoke, Double> hints) {
        this.hints = hints;
    }

    protected double computeMaximumSize(double relevance, int configuredMaximum) {
        double inlineRatio = Math.min(1.0, relevance);
        return (double)configuredMaximum * inlineRatio;
    }

    protected double getInliningBonus(InlineInfo info) {
        if (this.hints != null && this.hints.containsKey(info.invoke())) {
            return this.hints.get(info.invoke());
        }
        return 1.0;
    }

    protected boolean isIntrinsic(Replacements replacements, InlineInfo info) {
        if (InliningPhase.Options.AlwaysInlineIntrinsics.getValue(info.graph().getOptions()).booleanValue()) {
            return AbstractInliningPolicy.onlyIntrinsics(replacements, info);
        }
        return AbstractInliningPolicy.onlyForcedIntrinsics(replacements, info);
    }

    private static boolean onlyIntrinsics(Replacements replacements, InlineInfo info) {
        for (int i = 0; i < info.numberOfMethods(); ++i) {
            if (replacements.hasSubstitution(info.methodAt(i), info.invoke().bci())) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyForcedIntrinsics(Replacements replacements, InlineInfo info) {
        if (!AbstractInliningPolicy.onlyIntrinsics(replacements, info)) {
            return false;
        }
        return info.shouldInline();
    }

    protected int previousLowLevelGraphSize(InlineInfo info) {
        int size = 0;
        for (int i = 0; i < info.numberOfMethods(); ++i) {
            ResolvedJavaMethod m = info.methodAt(i);
            ProfilingInfo profile = info.graph().getProfilingInfo(m);
            int compiledGraphSize = profile.getCompilerIRSize(StructuredGraph.class);
            if (compiledGraphSize <= 0) continue;
            size += compiledGraphSize;
        }
        return size;
    }

    protected double determineInvokeProbability(InlineInfo info) {
        double invokeProbability = 0.0;
        for (int i = 0; i < info.numberOfMethods(); ++i) {
            Inlineable callee = info.inlineableElementAt(i);
            Iterable<Invoke> invokes = callee.getInvokes();
            if (!invokes.iterator().hasNext()) continue;
            for (Invoke invoke : invokes) {
                invokeProbability += callee.getProbability(invoke);
            }
        }
        return invokeProbability;
    }
}

