/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.graph.ScheduledNodeIterator;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class GuardLoweringPhase
extends BasePhase<MidTierContext> {
    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        if (graph.getGuardsStage().allowsFloatingGuards()) {
            SchedulePhase schedulePhase = new SchedulePhase(SchedulePhase.SchedulingStrategy.EARLIEST_WITH_GUARD_ORDER);
            schedulePhase.apply(graph);
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            for (Block block : schedule.getCFG().getBlocks()) {
                GuardLoweringPhase.processBlock(block, schedule);
            }
            graph.setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
        }
        assert (GuardLoweringPhase.assertNoGuardsLeft(graph));
    }

    private static boolean assertNoGuardsLeft(StructuredGraph graph) {
        assert (graph.getNodes().filter(GuardNode.class).isEmpty());
        return true;
    }

    private static void processBlock(Block block, StructuredGraph.ScheduleResult schedule) {
        DebugContext debug = block.getBeginNode().getDebug();
        new LowerGuards(block, debug.isDumpEnabledForMethod() || debug.isLogEnabledForMethod()).processNodes(block, schedule);
    }

    private static class LowerGuards
    extends ScheduledNodeIterator {
        private final Block block;
        private boolean useGuardIdAsDebugId;

        LowerGuards(Block block, boolean useGuardIdAsDebugId) {
            this.block = block;
            this.useGuardIdAsDebugId = useGuardIdAsDebugId;
        }

        @Override
        protected void processNode(Node node) {
            if (node instanceof GuardNode) {
                GuardNode guard = (GuardNode)node;
                FixedWithNextNode lowered = guard.lowerGuard();
                if (lowered != null) {
                    this.replaceCurrent(lowered);
                } else {
                    this.lowerToIf(guard);
                }
            }
        }

        private void lowerToIf(GuardNode guard) {
            try (DebugCloseable position = guard.withNodeSourcePosition();){
                AbstractBeginNode falseSuccessor;
                AbstractBeginNode trueSuccessor;
                StructuredGraph graph = guard.graph();
                AbstractBeginNode fastPath = graph.add(new BeginNode());
                fastPath.setNodeSourcePosition(guard.getNoDeoptSuccessorPosition());
                int debugId = this.useGuardIdAsDebugId ? guard.getId() : 0;
                DeoptimizeNode deopt = graph.add(new DeoptimizeNode(guard.getAction(), guard.getReason(), debugId, guard.getSpeculation(), null));
                AbstractBeginNode deoptBranch = BeginNode.begin(deopt);
                this.insertLoopExits(deopt);
                if (guard.isNegated()) {
                    trueSuccessor = deoptBranch;
                    falseSuccessor = fastPath;
                } else {
                    trueSuccessor = fastPath;
                    falseSuccessor = deoptBranch;
                }
                IfNode ifNode = graph.add(new IfNode(guard.getCondition(), trueSuccessor, falseSuccessor, trueSuccessor == fastPath ? 1.0 : 0.0));
                guard.replaceAndDelete(fastPath);
                this.insert(ifNode, fastPath);
            }
        }

        private void insertLoopExits(DeoptimizeNode deopt) {
            StructuredGraph graph = deopt.graph();
            for (Loop<Block> loop = this.block.getLoop(); loop != null; loop = loop.getParent()) {
                LoopExitNode exit = graph.add(new LoopExitNode((LoopBeginNode)loop.getHeader().getBeginNode()));
                graph.addBeforeFixed(deopt, exit);
            }
        }
    }
}

