/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.Iterator;
import java.util.LinkedList;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.DynamicDeoptimizeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class DeoptimizationGroupingPhase
extends BasePhase<MidTierContext> {
    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        ControlFlowGraph cfg = null;
        for (FrameState fs : graph.getNodes(FrameState.TYPE)) {
            DynamicDeoptimizeNode dynamicDeopt;
            Iterator iterator = fs.usages().filter(AbstractDeoptimizeNode.class).iterator();
            if (!iterator.hasNext()) continue;
            AbstractDeoptimizeNode first = (AbstractDeoptimizeNode)iterator.next();
            if (!iterator.hasNext()) continue;
            if (cfg == null) {
                cfg = ControlFlowGraph.compute(graph, true, true, false, false);
            }
            AbstractMergeNode merge = graph.add(new MergeNode());
            EndNode firstEnd = graph.add(new EndNode());
            ValueNode actionAndReason = first.getActionAndReason(context.getMetaAccess());
            ValueNode speculation = first.getSpeculation(context.getMetaAccess());
            PhiNode reasonActionPhi = graph.addWithoutUnique(new ValuePhiNode(StampFactory.forKind(actionAndReason.getStackKind()), merge));
            PhiNode speculationPhi = graph.addWithoutUnique(new ValuePhiNode(StampFactory.forKind(speculation.getStackKind()), merge));
            merge.addForwardEnd(firstEnd);
            reasonActionPhi.addInput(actionAndReason);
            speculationPhi.addInput(speculation);
            first.replaceAtPredecessor(firstEnd);
            DeoptimizationGroupingPhase.exitLoops(first, firstEnd, cfg);
            DebugCloseable position = first.withNodeSourcePosition();
            Object object = null;
            try {
                dynamicDeopt = new DynamicDeoptimizeNode(reasonActionPhi, speculationPhi);
                merge.setNext(graph.add(dynamicDeopt));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (position != null) {
                    if (object != null) {
                        try {
                            position.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        position.close();
                    }
                }
            }
            LinkedList<AbstractDeoptimizeNode> obsoletes = new LinkedList<AbstractDeoptimizeNode>();
            obsoletes.add(first);
            do {
                AbstractDeoptimizeNode deopt = (AbstractDeoptimizeNode)iterator.next();
                EndNode newEnd = graph.add(new EndNode());
                merge.addForwardEnd(newEnd);
                reasonActionPhi.addInput(deopt.getActionAndReason(context.getMetaAccess()));
                speculationPhi.addInput(deopt.getSpeculation(context.getMetaAccess()));
                deopt.replaceAtPredecessor(newEnd);
                DeoptimizationGroupingPhase.exitLoops(deopt, newEnd, cfg);
                obsoletes.add(deopt);
            } while (iterator.hasNext());
            dynamicDeopt.setStateBefore(fs);
            for (AbstractDeoptimizeNode obsolete : obsoletes) {
                obsolete.safeDelete();
            }
        }
    }

    private static void exitLoops(AbstractDeoptimizeNode deopt, EndNode end, ControlFlowGraph cfg) {
        Block block = cfg.blockFor(deopt);
        for (Loop<Block> loop = block.getLoop(); loop != null; loop = loop.getParent()) {
            end.graph().addBeforeFixed(end, end.graph().add(new LoopExitNode((LoopBeginNode)loop.getHeader().getBeginNode())));
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 2.5f;
    }
}

