/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.EnumSet;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeWorkList;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;

public class CanonicalizerPhase
extends BasePhase<CoreProviders> {
    private static final int MAX_ITERATION_PER_NODE = 10;
    private static final CounterKey COUNTER_CANONICALIZED_NODES = DebugContext.counter("CanonicalizedNodes");
    private static final CounterKey COUNTER_PROCESSED_NODES = DebugContext.counter("ProcessedNodes");
    private static final CounterKey COUNTER_CANONICALIZATION_CONSIDERED_NODES = DebugContext.counter("CanonicalizationConsideredNodes");
    private static final CounterKey COUNTER_INFER_STAMP_CALLED = DebugContext.counter("InferStampCalled");
    private static final CounterKey COUNTER_STAMP_CHANGED = DebugContext.counter("StampChanged");
    private static final CounterKey COUNTER_SIMPLIFICATION_CONSIDERED_NODES = DebugContext.counter("SimplificationConsideredNodes");
    private static final CounterKey COUNTER_GLOBAL_VALUE_NUMBERING_HITS = DebugContext.counter("GlobalValueNumberingHits");
    private final EnumSet<CanonicalizerFeature> features;
    private final CustomCanonicalization customCanonicalization;
    private final CustomSimplification customSimplification;

    protected CanonicalizerPhase(EnumSet<CanonicalizerFeature> features) {
        this(null, null, features);
    }

    protected CanonicalizerPhase() {
        this(null, null, EnumSet.allOf(CanonicalizerFeature.class));
    }

    protected CanonicalizerPhase(CustomCanonicalization customCanonicalization, CustomSimplification customSimplification) {
        this(customCanonicalization, customSimplification, EnumSet.allOf(CanonicalizerFeature.class));
    }

    protected CanonicalizerPhase(CustomCanonicalization customCanonicalization, CustomSimplification customSimplification, EnumSet<CanonicalizerFeature> features) {
        this.customCanonicalization = customCanonicalization;
        this.customSimplification = customSimplification;
        this.features = features;
    }

    public CanonicalizerPhase copyWithCustomCanonicalization(CustomCanonicalization newCanonicalization) {
        return new CanonicalizerPhase(newCanonicalization, this.customSimplification, this.features);
    }

    public CanonicalizerPhase copyWithCustomSimplification(CustomSimplification newSimplification) {
        return new CanonicalizerPhase(this.customCanonicalization, newSimplification, this.features);
    }

    public CanonicalizerPhase copyWithoutGVN() {
        EnumSet<CanonicalizerFeature> newFeatures = EnumSet.copyOf(this.features);
        newFeatures.remove((Object)CanonicalizerFeature.GVN);
        return new CanonicalizerPhase(this.customCanonicalization, this.customSimplification, newFeatures);
    }

    public CanonicalizerPhase copyWithoutSimplification() {
        EnumSet<CanonicalizerFeature> newFeatures = EnumSet.copyOf(this.features);
        newFeatures.remove((Object)CanonicalizerFeature.CFG_SIMPLIFICATION);
        return new CanonicalizerPhase(this.customCanonicalization, this.customSimplification, newFeatures);
    }

    public static CanonicalizerPhase create() {
        return new CanonicalizerPhase(null, null, EnumSet.allOf(CanonicalizerFeature.class));
    }

    public static CanonicalizerPhase createWithoutReadCanonicalization() {
        return new CanonicalizerPhase(EnumSet.complementOf(EnumSet.of(CanonicalizerFeature.READ_CANONICALIZATION)));
    }

    public static CanonicalizerPhase createWithoutGVN() {
        return new CanonicalizerPhase(EnumSet.complementOf(EnumSet.of(CanonicalizerFeature.GVN)));
    }

    public static CanonicalizerPhase createWithoutCFGSimplification() {
        return new CanonicalizerPhase(EnumSet.complementOf(EnumSet.of(CanonicalizerFeature.CFG_SIMPLIFICATION)));
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        new Instance(context).run(graph);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Graph.Mark newNodesMark) {
        this.applyIncremental(graph, context, newNodesMark, true);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Graph.Mark newNodesMark, boolean dumpGraph) {
        new Instance(context, newNodesMark).apply(graph, dumpGraph);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Iterable<? extends Node> workingSet) {
        this.applyIncremental(graph, context, workingSet, true);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Iterable<? extends Node> workingSet, boolean dumpGraph) {
        new Instance(context, (Iterable)workingSet).apply(graph, dumpGraph);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Iterable<? extends Node> workingSet, Graph.Mark newNodesMark) {
        this.applyIncremental(graph, context, workingSet, newNodesMark, true);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Iterable<? extends Node> workingSet, Graph.Mark newNodesMark, boolean dumpGraph) {
        new Instance(context, workingSet, newNodesMark).apply(graph, dumpGraph);
    }

    public NodeView getNodeView() {
        return NodeView.DEFAULT;
    }

    public boolean getCanonicalizeReads() {
        return this.features.contains((Object)CanonicalizerFeature.READ_CANONICALIZATION);
    }

    static /* synthetic */ CounterKey access$800() {
        return COUNTER_CANONICALIZATION_CONSIDERED_NODES;
    }

    static /* synthetic */ CustomCanonicalization access$900(CanonicalizerPhase x0) {
        return x0.customCanonicalization;
    }

    static /* synthetic */ CounterKey access$1000() {
        return COUNTER_SIMPLIFICATION_CONSIDERED_NODES;
    }

    static /* synthetic */ CustomSimplification access$1100(CanonicalizerPhase x0) {
        return x0.customSimplification;
    }

    private final class Instance
    extends Phase {
        private final Graph.Mark newNodesMark;
        private final CoreProviders context;
        private final Iterable<? extends Node> initWorkingSet;
        private NodeWorkList workList;
        private Tool tool;
        private DebugContext debug;

        private Instance(CoreProviders context) {
            this(context, (Iterable<? extends Node>)null, (Graph.Mark)null);
        }

        private Instance(CoreProviders context, Iterable<? extends Node> workingSet) {
            this(context, workingSet, null);
        }

        private Instance(CoreProviders context, Graph.Mark newNodesMark) {
            this(context, null, newNodesMark);
        }

        private Instance(CoreProviders context, Iterable<? extends Node> workingSet, Graph.Mark newNodesMark) {
            this.newNodesMark = newNodesMark;
            this.context = context;
            this.initWorkingSet = workingSet;
        }

        @Override
        public boolean checkContract() {
            return false;
        }

        @Override
        protected void run(StructuredGraph graph) {
            boolean wholeGraph;
            this.debug = graph.getDebug();
            boolean bl = wholeGraph = this.newNodesMark == null || this.newNodesMark.isStart();
            if (this.initWorkingSet == null) {
                this.workList = graph.createIterativeNodeWorkList(wholeGraph, 10);
            } else {
                this.workList = graph.createIterativeNodeWorkList(false, 10);
                this.workList.addAll(this.initWorkingSet);
            }
            if (!wholeGraph) {
                this.workList.addAll(graph.getNewNodes(this.newNodesMark));
            }
            this.tool = new Tool(graph.getAssumptions(), graph.getOptions());
            this.processWorkSet(graph);
        }

        private int processWorkSet(StructuredGraph graph) {
            int sum = 0;
            Graph.NodeEventListener listener = new Graph.NodeEventListener(){

                @Override
                public void nodeAdded(Node node) {
                    Instance.this.workList.add(node);
                }

                @Override
                public void inputChanged(Node node) {
                    AbstractBeginNode abstractBeginNode;
                    Instance.this.workList.add(node);
                    if (node instanceof Node.IndirectCanonicalization) {
                        for (Node usage : node.usages()) {
                            Instance.this.workList.add(usage);
                        }
                    }
                    if (node instanceof AbstractBeginNode && (abstractBeginNode = (AbstractBeginNode)node).predecessor() != null) {
                        Instance.this.workList.add(abstractBeginNode.predecessor());
                    }
                }

                @Override
                public void usagesDroppedToZero(Node node) {
                    Instance.this.workList.add(node);
                }
            };
            try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
                for (Node n : this.workList) {
                    boolean changed = this.processNode(n);
                    if (changed && this.debug.isDumpEnabled(4)) {
                        this.debug.dump(4, (Object)graph, "CanonicalizerPhase %s", n);
                    }
                    ++sum;
                }
            }
            return sum;
        }

        private boolean processNode(Node node) {
            if (!node.isAlive()) {
                return false;
            }
            COUNTER_PROCESSED_NODES.increment(this.debug);
            if (GraphUtil.tryKillUnused(node)) {
                return true;
            }
            NodeClass<? extends Node> nodeClass = node.getNodeClass();
            StructuredGraph graph = (StructuredGraph)node.graph();
            if (this.tryCanonicalize(node, nodeClass)) {
                return true;
            }
            if (CanonicalizerPhase.this.features.contains((Object)CanonicalizerFeature.GVN) && this.tryGlobalValueNumbering(node, nodeClass)) {
                return true;
            }
            if (node instanceof ValueNode) {
                ValueNode valueNode = (ValueNode)node;
                boolean improvedStamp = this.tryInferStamp(valueNode);
                Constant constant = valueNode.stamp(NodeView.DEFAULT).asConstant();
                if (constant != null && !(node instanceof ConstantNode)) {
                    ConstantNode stampConstant = ConstantNode.forConstant(valueNode.stamp(NodeView.DEFAULT), constant, this.context.getMetaAccess(), graph);
                    this.debug.log("Canonicalizer: constant stamp replaces %1s with %1s", (Object)valueNode, (Object)stampConstant);
                    valueNode.replaceAtUsages(InputType.Value, stampConstant);
                    GraphUtil.tryKillUnused(valueNode);
                    return true;
                }
                if (improvedStamp) {
                    if (this.tryCanonicalize(valueNode, nodeClass)) {
                        return true;
                    }
                    valueNode.usages().forEach(this.workList::add);
                }
            }
            return false;
        }

        public boolean tryGlobalValueNumbering(Node node, NodeClass<?> nodeClass) {
            Node newNode;
            if (nodeClass.valueNumberable() && (newNode = node.graph().findDuplicate(node)) != null) {
                assert (!(node instanceof FixedNode) && !(newNode instanceof FixedNode));
                node.replaceAtUsagesAndDelete(newNode);
                COUNTER_GLOBAL_VALUE_NUMBERING_HITS.increment(this.debug);
                this.debug.log("GVN applied and new node is %1s", newNode);
                return true;
            }
            return false;
        }

        private AutoCloseable getCanonicalizeableContractAssertion(Node node) {
            boolean needsAssertion = false;
            if (!$assertionsDisabled) {
                needsAssertion = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (needsAssertion) {
                Graph.Mark mark = node.graph().getMark();
                return () -> {
                    assert (mark.equals(node.graph().getMark())) : "new node created while canonicalizing " + node.getClass().getSimpleName() + " " + node + ": " + node.graph().getNewNodes(mark).snapshot();
                };
            }
            return null;
        }

        /*
         * Exception decompiling
         */
        public boolean tryCanonicalize(Node node, NodeClass<?> nodeClass) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean performReplacement(Node node, Node newCanonical) {
            if (newCanonical == node) {
                this.debug.log(3, "Canonicalizer: work on %1s", (Object)node);
                return false;
            }
            Node canonical = newCanonical;
            this.debug.log("Canonicalizer: replacing %1s with %1s", (Object)node, (Object)canonical);
            COUNTER_CANONICALIZED_NODES.increment(this.debug);
            StructuredGraph graph = (StructuredGraph)node.graph();
            if (canonical != null && !canonical.isAlive()) {
                assert (!canonical.isDeleted());
                canonical = graph.addOrUniqueWithInputs(canonical);
            }
            if (node instanceof FloatingNode) {
                assert (canonical == null || !(canonical instanceof FixedNode) || canonical.predecessor() != null || canonical instanceof StartNode || canonical instanceof AbstractMergeNode) : node + " -> " + canonical + " : replacement should be floating or fixed and connected";
                node.replaceAtUsages(canonical);
                GraphUtil.killWithUnusedFloatingInputs(node, true);
            } else {
                assert (node instanceof FixedNode && node.predecessor() != null) : node + " -> " + canonical + " : node should be fixed & connected (" + node.predecessor() + ")";
                FixedNode fixed = (FixedNode)node;
                if (canonical instanceof ControlSinkNode) {
                    fixed.replaceAtPredecessor(canonical);
                    GraphUtil.killCFG(fixed);
                    return true;
                }
                assert (fixed instanceof FixedWithNextNode);
                FixedWithNextNode fixedWithNext = (FixedWithNextNode)fixed;
                assert (fixedWithNext.next() != null);
                this.tool.addToWorkList(fixedWithNext.next());
                if (canonical == null) {
                    node.replaceAtUsages(null);
                    GraphUtil.removeFixedWithUnusedInputs(fixedWithNext);
                } else if (canonical instanceof FloatingNode) {
                    graph.replaceFixedWithFloating(fixedWithNext, (FloatingNode)canonical);
                } else {
                    assert (canonical instanceof FixedNode);
                    if (canonical.predecessor() == null) {
                        assert (!canonical.cfgSuccessors().iterator().hasNext()) : "replacement " + canonical + " shouldn't have successors";
                        graph.replaceFixedWithFixed(fixedWithNext, (FixedWithNextNode)canonical);
                    } else {
                        assert (canonical.cfgSuccessors().iterator().hasNext()) : "replacement " + canonical + " should have successors";
                        node.replaceAtUsages(canonical);
                        GraphUtil.removeFixedWithUnusedInputs(fixedWithNext);
                    }
                }
            }
            return true;
        }

        private boolean tryInferStamp(ValueNode node) {
            if (node.isAlive()) {
                COUNTER_INFER_STAMP_CALLED.increment(this.debug);
                if (node.inferStamp()) {
                    COUNTER_STAMP_CHANGED.increment(this.debug);
                    for (Node usage : node.usages()) {
                        this.workList.add(usage);
                    }
                    return true;
                }
            }
            return false;
        }

        private final class Tool
        implements SimplifierTool,
        NodeView {
            private final Assumptions assumptions;
            private final OptionValues options;
            private NodeView nodeView;

            Tool(Assumptions assumptions, OptionValues options) {
                this.assumptions = assumptions;
                this.options = options;
                this.nodeView = CanonicalizerPhase.this.getNodeView();
            }

            @Override
            public void deleteBranch(Node branch) {
                FixedNode fixedBranch = (FixedNode)branch;
                fixedBranch.predecessor().replaceFirstSuccessor(fixedBranch, null);
                GraphUtil.killCFG(fixedBranch);
            }

            @Override
            public MetaAccessProvider getMetaAccess() {
                return Instance.this.context.getMetaAccess();
            }

            @Override
            public ConstantReflectionProvider getConstantReflection() {
                return Instance.this.context.getConstantReflection();
            }

            @Override
            public ConstantFieldProvider getConstantFieldProvider() {
                return Instance.this.context.getConstantFieldProvider();
            }

            @Override
            public void addToWorkList(Node node) {
                Instance.this.workList.add(node);
            }

            @Override
            public void addToWorkList(Iterable<? extends Node> nodes) {
                Instance.this.workList.addAll(nodes);
            }

            @Override
            public void removeIfUnused(Node node) {
                GraphUtil.tryKillUnused(node);
            }

            @Override
            public boolean canonicalizeReads() {
                return CanonicalizerPhase.this.features.contains((Object)CanonicalizerFeature.READ_CANONICALIZATION);
            }

            @Override
            public boolean allUsagesAvailable() {
                return true;
            }

            @Override
            public Assumptions getAssumptions() {
                return this.assumptions;
            }

            @Override
            public Integer smallestCompareWidth() {
                return Instance.this.context.getLowerer().smallestCompareWidth();
            }

            @Override
            public OptionValues getOptions() {
                return this.options;
            }

            @Override
            public Stamp stamp(ValueNode node) {
                return this.nodeView.stamp(node);
            }
        }
    }

    public static interface CustomSimplification {
        public void simplify(Node var1, SimplifierTool var2);
    }

    public static interface CustomCanonicalization {
        public Node canonicalize(Node var1);
    }

    public static enum CanonicalizerFeature {
        READ_CANONICALIZATION,
        CFG_SIMPLIFICATION,
        GVN;

    }
}

