/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases;

import java.util.regex.Pattern;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.MemUseTrackerKey;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.ClassTypeSequence;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.contract.NodeCostUtil;
import org.graalvm.compiler.phases.contract.PhaseSizeContract;

public abstract class BasePhase<C>
implements PhaseSizeContract {
    private final TimerKey timer;
    private final CounterKey executionCount;
    private final CounterKey inputNodesCount;
    private final MemUseTrackerKey memUseTracker;
    private static final ClassValue<BasePhaseStatistics> statisticsClassValue = new ClassValue<BasePhaseStatistics>(){

        @Override
        protected BasePhaseStatistics computeValue(Class<?> c) {
            return new BasePhaseStatistics(c);
        }
    };

    private static BasePhaseStatistics getBasePhaseStatistics(Class<?> c) {
        return statisticsClassValue.get(c);
    }

    protected BasePhase() {
        BasePhaseStatistics statistics = BasePhase.getBasePhaseStatistics(this.getClass());
        this.timer = statistics.timer;
        this.executionCount = statistics.executionCount;
        this.memUseTracker = statistics.memUseTracker;
        this.inputNodesCount = statistics.inputNodesCount;
    }

    public final void apply(StructuredGraph graph, C context) {
        this.apply(graph, context, true);
    }

    private BasePhase<?> getEnclosingPhase(DebugContext debug) {
        for (Object c : debug.context()) {
            if (c == this || !(c instanceof BasePhase) || c instanceof PhaseSuite) continue;
            return (BasePhase)c;
        }
        return null;
    }

    private boolean dumpBefore(StructuredGraph graph, C context, boolean isTopLevel) {
        DebugContext debug = graph.getDebug();
        if (isTopLevel && (debug.isDumpEnabled(3) || this.shouldDumpBeforeAtBasicLevel() && debug.isDumpEnabled(1))) {
            if (this.shouldDumpBeforeAtBasicLevel()) {
                debug.dump(1, (Object)graph, "Before phase %s", this.getName());
            } else {
                debug.dump(3, (Object)graph, "Before phase %s", this.getName());
            }
        } else if (!isTopLevel && debug.isDumpEnabled(4)) {
            debug.dump(4, (Object)graph, "Before subphase %s", this.getName());
        } else if (debug.isDumpEnabled(0) && this.shouldDump(graph, context)) {
            debug.dump(0, graph, "Before %s %s", isTopLevel ? "phase" : "subphase", this.getName());
            return true;
        }
        return false;
    }

    protected boolean shouldDumpBeforeAtBasicLevel() {
        return false;
    }

    protected boolean shouldDumpAfterAtBasicLevel() {
        return false;
    }

    protected final void apply(StructuredGraph graph, C context, boolean dumpGraph) {
        graph.checkCancellation();
        DebugContext debug = graph.getDebug();
        try (DebugCloseable a = this.timer.start(debug);
             DebugContext.Scope s = debug.scope(this.getClass(), this);
             DebugCloseable c = this.memUseTracker.start(debug);){
            boolean verifySizeContract;
            int sizeBefore = 0;
            Graph.Mark before = null;
            OptionValues options = graph.getOptions();
            boolean bl = verifySizeContract = PhaseOptions.VerifyGraalPhasesSize.getValue(options) != false && this.checkContract();
            if (verifySizeContract) {
                sizeBefore = NodeCostUtil.computeGraphSize(graph);
                before = graph.getMark();
            }
            boolean isTopLevel = this.getEnclosingPhase(graph.getDebug()) == null;
            boolean dumpedBefore = false;
            if (dumpGraph && debug.areScopesEnabled()) {
                dumpedBefore = this.dumpBefore(graph, context, isTopLevel);
            }
            this.inputNodesCount.add(debug, graph.getNodeCount());
            this.run(graph, context);
            this.executionCount.increment(debug);
            if (verifySizeContract && !before.isCurrent()) {
                int sizeAfter = NodeCostUtil.computeGraphSize(graph);
                NodeCostUtil.phaseFulfillsSizeContract(graph, sizeBefore, sizeAfter, this);
            }
            if (dumpGraph && debug.areScopesEnabled()) {
                this.dumpAfter(graph, isTopLevel, dumpedBefore);
            }
            if (debug.isVerifyEnabled()) {
                debug.verify((Object)graph, "%s", this.getName());
            }
            assert (graph.verify());
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
    }

    private void dumpAfter(StructuredGraph graph, boolean isTopLevel, boolean dumpedBefore) {
        boolean dumped = false;
        DebugContext debug = graph.getDebug();
        if (isTopLevel) {
            if (this.shouldDumpAfterAtBasicLevel()) {
                if (debug.isDumpEnabled(1)) {
                    debug.dump(1, (Object)graph, "After phase %s", this.getName());
                    dumped = true;
                }
            } else if (debug.isDumpEnabled(2)) {
                debug.dump(2, (Object)graph, "After phase %s", this.getName());
                dumped = true;
            }
        } else if (debug.isDumpEnabled(3)) {
            debug.dump(3, (Object)graph, "After subphase %s", this.getName());
            dumped = true;
        }
        if (!dumped && debug.isDumpEnabled(0) && dumpedBefore) {
            debug.dump(0, graph, "After %s %s", isTopLevel ? "phase" : "subphase", this.getName());
        }
    }

    private boolean shouldDump(StructuredGraph graph, C context) {
        DebugContext debug = graph.getDebug();
        String phaseChange = DebugOptions.DumpOnPhaseChange.getValue(graph.getOptions());
        if (phaseChange != null && Pattern.matches(phaseChange, this.getClass().getSimpleName())) {
            StructuredGraph graphCopy = (StructuredGraph)graph.copy(graph.getDebug());
            GraphChangeListener listener = new GraphChangeListener(graphCopy);
            try (Graph.NodeEventScope s = graphCopy.trackNodeEvents(listener);){
                try (DebugContext.Scope s2 = debug.sandbox("GraphChangeListener", null, new Object[0]);){
                    this.run(graphCopy, context);
                }
                catch (Throwable t) {
                    debug.handle(t);
                }
            }
            return listener.changed;
        }
        return false;
    }

    protected CharSequence getName() {
        return new ClassTypeSequence(this.getClass());
    }

    protected abstract void run(StructuredGraph var1, C var2);

    @Override
    public String contractorName() {
        return this.getName().toString();
    }

    @Override
    public float codeSizeIncrease() {
        return 1.25f;
    }

    private static final class GraphChangeListener
    extends Graph.NodeEventListener {
        boolean changed;
        private StructuredGraph graph;
        private Graph.Mark mark;

        GraphChangeListener(StructuredGraph graphCopy) {
            this.graph = graphCopy;
            this.mark = this.graph.getMark();
        }

        @Override
        public void changed(Graph.NodeEvent e, Node node) {
            if (!this.graph.isNew(this.mark, node) && node.isAlive() && (e == Graph.NodeEvent.INPUT_CHANGED || e == Graph.NodeEvent.ZERO_USAGES)) {
                this.changed = true;
            }
        }
    }

    public static class BasePhaseStatistics {
        private final TimerKey timer;
        private final CounterKey executionCount;
        private final CounterKey inputNodesCount;
        private final MemUseTrackerKey memUseTracker;

        public BasePhaseStatistics(Class<?> clazz) {
            this.timer = DebugContext.timer("PhaseTime_%s", clazz).doc("Time spent in phase.");
            this.executionCount = DebugContext.counter("PhaseCount_%s", clazz).doc("Number of phase executions.");
            this.memUseTracker = DebugContext.memUseTracker("PhaseMemUse_%s", clazz).doc("Memory allocated in phase.");
            this.inputNodesCount = DebugContext.counter("PhaseNodes_%s", clazz).doc("Number of nodes input to phase.");
        }
    }

    static class NamePatternHolder {
        static final Pattern NAME_PATTERN = Pattern.compile("[A-Z][A-Za-z0-9]+");

        NamePatternHolder() {
        }
    }

    public static class PhaseOptions {
        @Option(help={"Verify before - after relation of the relative, computed, code size of a graph"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> VerifyGraalPhasesSize = new OptionKey<Boolean>(false);
    }
}

