/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.options;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.ModuleSupport;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionKey;

public class OptionsParser {
    private static volatile List<OptionDescriptors> cachedOptionDescriptors;
    private static final float FUZZY_MATCH_THRESHOLD = 0.7f;

    public static Iterable<OptionDescriptors> getOptionsLoader() {
        if (Services.IS_IN_NATIVE_IMAGE || cachedOptionDescriptors != null) {
            return cachedOptionDescriptors;
        }
        return ModuleSupport.getOptionsLoader();
    }

    public static void setCachedOptionDescriptors(List<OptionDescriptors> list) {
        assert (Services.IS_BUILDING_NATIVE_IMAGE) : "Used to pre-initialize the option descriptors during native image generation";
        cachedOptionDescriptors = list;
    }

    public static void parseOptions(EconomicMap<String, String> optionSettings, EconomicMap<OptionKey<?>, Object> values, Iterable<OptionDescriptors> loader) {
        if (optionSettings != null && !optionSettings.isEmpty()) {
            MapCursor cursor = optionSettings.getEntries();
            while (cursor.advance()) {
                OptionsParser.parseOption((String)cursor.getKey(), cursor.getValue(), values, loader);
            }
        }
    }

    public static void parseOptionSettingTo(String optionSetting, EconomicMap<String, String> dst) {
        int eqIndex = optionSetting.indexOf(61);
        if (eqIndex == -1) {
            throw new InternalError("Option setting has does not match the pattern <name>=<value>: " + optionSetting);
        }
        dst.put((Object)optionSetting.substring(0, eqIndex), (Object)optionSetting.substring(eqIndex + 1));
    }

    private static OptionDescriptor lookup(Iterable<OptionDescriptors> loader, String name) {
        for (OptionDescriptors optionDescriptors : loader) {
            OptionDescriptor desc = optionDescriptors.get(name);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseOption(String name, Object uncheckedValue, EconomicMap<OptionKey<?>, Object> values, Iterable<OptionDescriptors> loader) {
        Object value;
        OptionDescriptor desc = OptionsParser.lookup(loader, name);
        if (desc == null) {
            List<OptionDescriptor> matches = OptionsParser.fuzzyMatch(loader, name);
            Formatter msg = new Formatter();
            msg.format("Could not find option %s", name);
            if (matches.isEmpty()) throw new IllegalArgumentException(msg.toString());
            msg.format("%nDid you mean one of the following?", new Object[0]);
            for (OptionDescriptor match : matches) {
                msg.format("%n    %s=<value>", match.getName());
            }
            throw new IllegalArgumentException(msg.toString());
        }
        Class<?> optionType = desc.getOptionValueType();
        if (!(uncheckedValue instanceof String)) {
            if (optionType != uncheckedValue.getClass()) {
                String type = optionType.getSimpleName();
                throw new IllegalArgumentException(type + " option '" + name + "' must have " + type + " value, not " + uncheckedValue.getClass() + " [toString: " + uncheckedValue + "]");
            }
            value = uncheckedValue;
        } else {
            String valueString = (String)uncheckedValue;
            if (optionType == Boolean.class) {
                if ("true".equals(valueString)) {
                    value = Boolean.TRUE;
                } else {
                    if (!"false".equals(valueString)) throw new IllegalArgumentException("Boolean option '" + name + "' must have value \"true\" or \"false\", not \"" + uncheckedValue + "\"");
                    value = Boolean.FALSE;
                }
            } else if (optionType == String.class) {
                value = valueString;
            } else if (Enum.class.isAssignableFrom(optionType)) {
                value = ((EnumOptionKey)desc.getOptionKey()).valueOf(valueString);
            } else {
                if (valueString.isEmpty()) {
                    throw new IllegalArgumentException("Non empty value required for option '" + name + "'");
                }
                try {
                    if (optionType == Float.class) {
                        value = Float.valueOf(Float.parseFloat(valueString));
                    } else if (optionType == Double.class) {
                        value = Double.parseDouble(valueString);
                    } else if (optionType == Integer.class) {
                        value = (int)OptionsParser.parseLong(valueString);
                    } else {
                        if (optionType != Long.class) throw new IllegalArgumentException("Wrong value for option '" + name + "'");
                        value = OptionsParser.parseLong(valueString);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Value for option '" + name + "' has invalid number format: " + valueString);
                }
            }
        }
        desc.getOptionKey().update(values, value);
    }

    private static long parseLong(String v) {
        String valueString = v.toLowerCase();
        long scale = 1L;
        if (valueString.endsWith("k")) {
            scale = 1024L;
        } else if (valueString.endsWith("m")) {
            scale = 0x100000L;
        } else if (valueString.endsWith("g")) {
            scale = 0x40000000L;
        } else if (valueString.endsWith("t")) {
            scale = 0x10000000000L;
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    static float stringSimiliarity(String str1, String str2) {
        int hit = 0;
        block0: for (int i = 0; i < str1.length() - 1; ++i) {
            for (int j = 0; j < str2.length() - 1; ++j) {
                if (str1.charAt(i) != str2.charAt(j) || str1.charAt(i + 1) != str2.charAt(j + 1)) continue;
                ++hit;
                continue block0;
            }
        }
        return 2.0f * (float)hit / (float)(str1.length() + str2.length());
    }

    private static List<OptionDescriptor> fuzzyMatch(Iterable<OptionDescriptors> loader, String optionName) {
        ArrayList<OptionDescriptor> matches = new ArrayList<OptionDescriptor>();
        for (OptionDescriptors options : loader) {
            OptionsParser.collectFuzzyMatches(options, optionName, matches);
        }
        return matches;
    }

    public static boolean collectFuzzyMatches(Iterable<OptionDescriptor> toSearch, String name, Collection<OptionDescriptor> matches) {
        boolean found = false;
        for (OptionDescriptor option : toSearch) {
            float score = OptionsParser.stringSimiliarity(option.getName(), name);
            if (!(score >= 0.7f)) continue;
            found = true;
            matches.add(option);
        }
        return found;
    }
}

