/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.virtual;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.virtual.LockState;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public abstract class VirtualObjectNode
extends ValueNode
implements LIRLowerable,
IterableNodeType {
    public static final NodeClass<VirtualObjectNode> TYPE = NodeClass.create(VirtualObjectNode.class);
    protected boolean hasIdentity;
    private int objectId = -1;

    protected VirtualObjectNode(NodeClass<? extends VirtualObjectNode> c, ResolvedJavaType type, boolean hasIdentity) {
        super(c, StampFactory.objectNonNull(TypeReference.createExactTrusted(type)));
        this.hasIdentity = hasIdentity;
    }

    public final int getObjectId() {
        return this.objectId;
    }

    public final void resetObjectId() {
        this.objectId = -1;
    }

    public final void setObjectId(int objectId) {
        assert (objectId != -1);
        this.objectId = objectId;
    }

    @Override
    protected void afterClone(Node other) {
        super.afterClone(other);
        this.resetObjectId();
    }

    public abstract ResolvedJavaType type();

    public abstract int entryCount();

    public abstract String entryName(int var1);

    public abstract int entryIndexForOffset(MetaAccessProvider var1, long var2, JavaKind var4);

    public abstract JavaKind entryKind(int var1);

    public abstract VirtualObjectNode duplicate();

    public boolean hasIdentity() {
        return this.hasIdentity;
    }

    public void setIdentity(boolean identity) {
        this.hasIdentity = identity;
    }

    public abstract ValueNode getMaterializedRepresentation(FixedNode var1, ValueNode[] var2, LockState var3);

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }
}

