/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.util;

import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.util.IntegerHelper;

public class UnsignedIntegerHelper
extends IntegerHelper {
    public UnsignedIntegerHelper(int bits) {
        super(bits);
    }

    @Override
    public long upperBound(IntegerStamp stamp) {
        assert (stamp.getBits() == this.bits);
        return stamp.unsignedUpperBound();
    }

    @Override
    public long lowerBound(IntegerStamp stamp) {
        assert (stamp.getBits() == this.bits);
        return stamp.unsignedLowerBound();
    }

    @Override
    protected int rawCompare(long a, long b) {
        return Long.compareUnsigned(a, b);
    }

    @Override
    protected long rawMin(long a, long b) {
        return NumUtil.minUnsigned(a, b);
    }

    @Override
    protected long rawMax(long a, long b) {
        return NumUtil.maxUnsigned(a, b);
    }

    @Override
    public long cast(long a) {
        return CodeUtil.zeroExtend((long)a, (int)this.bits);
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        return NumUtil.maxValueUnsigned(this.bits);
    }

    @Override
    public IntegerStamp stamp(long min, long max) {
        return StampFactory.forUnsignedInteger(this.bits, min, max);
    }

    @Override
    public LogicNode createCompareNode(ValueNode x, ValueNode y, NodeView view) {
        return IntegerBelowNode.create(x, y, view);
    }
}

