/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.util;

import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;

public abstract class IntegerHelper {
    protected final int bits;

    protected IntegerHelper(int bits) {
        this.bits = bits;
    }

    public abstract long upperBound(IntegerStamp var1);

    public abstract long lowerBound(IntegerStamp var1);

    public int compare(long a, long b) {
        return this.rawCompare(this.cast(a), this.cast(b));
    }

    public boolean isGreater(long a, long b) {
        return this.compare(a, b) > 0;
    }

    public boolean isSmaller(long a, long b) {
        return this.compare(a, b) < 0;
    }

    public boolean isGreaterEqual(long a, long b) {
        return this.compare(a, b) >= 0;
    }

    public boolean isSmallerEqual(long a, long b) {
        return this.compare(a, b) <= 0;
    }

    public long min(long a, long b) {
        return this.rawMin(this.cast(a), this.cast(b));
    }

    public long max(long a, long b) {
        return this.rawMax(this.cast(a), this.cast(b));
    }

    public abstract long cast(long var1);

    public abstract long minValue();

    public abstract long maxValue();

    public abstract IntegerStamp stamp(long var1, long var3);

    public abstract LogicNode createCompareNode(ValueNode var1, ValueNode var2, NodeView var3);

    protected abstract int rawCompare(long var1, long var3);

    protected abstract long rawMin(long var1, long var3);

    protected abstract long rawMax(long var1, long var3);
}

