/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.Access;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public abstract class FixedAccessNode
extends DeoptimizingFixedWithNextNode
implements Access,
IterableNodeType {
    public static final NodeClass<FixedAccessNode> TYPE = NodeClass.create(FixedAccessNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    protected GuardingNode guard;
    @Node.Input(value=InputType.Association)
    AddressNode address;
    protected final LocationIdentity location;
    protected boolean nullCheck;
    protected HeapAccess.BarrierType barrierType;

    @Override
    public AddressNode getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(AddressNode address) {
        this.updateUsages(this.address, address);
        this.address = address;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.location;
    }

    public boolean getNullCheck() {
        return this.nullCheck;
    }

    public void setNullCheck(boolean check) {
        this.nullCheck = check;
    }

    protected FixedAccessNode(NodeClass<? extends FixedAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp) {
        this(c, address, location, stamp, HeapAccess.BarrierType.NONE);
    }

    protected FixedAccessNode(NodeClass<? extends FixedAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, HeapAccess.BarrierType barrierType) {
        this(c, address, location, stamp, null, barrierType, false, null);
    }

    protected FixedAccessNode(NodeClass<? extends FixedAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, HeapAccess.BarrierType barrierType, boolean nullCheck, FrameState stateBefore) {
        super(c, stamp, stateBefore);
        this.address = address;
        this.location = location;
        this.guard = guard;
        this.barrierType = barrierType;
        this.nullCheck = nullCheck;
    }

    @Override
    public boolean canDeoptimize() {
        return this.nullCheck;
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }

    @Override
    public HeapAccess.BarrierType getBarrierType() {
        return this.barrierType;
    }
}

