/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.java.AbstractUnsafeCompareAndSwapNode;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public final class UnsafeCompareAndSwapNode
extends AbstractUnsafeCompareAndSwapNode {
    public static final NodeClass<UnsafeCompareAndSwapNode> TYPE = NodeClass.create(UnsafeCompareAndSwapNode.class);

    public UnsafeCompareAndSwapNode(ValueNode object, ValueNode offset, ValueNode expected, ValueNode newValue, JavaKind valueKind, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forKind(JavaKind.Boolean.getStackKind()), object, offset, expected, newValue, valueKind, locationIdentity);
        assert (expected.stamp(NodeView.DEFAULT).isCompatible(newValue.stamp(NodeView.DEFAULT)));
    }

    @Override
    protected void finishVirtualize(VirtualizerTool tool, LogicNode equalsNode, ValueNode currentValue) {
        ValueNode result = ConditionalNode.create(equalsNode, ConstantNode.forBoolean(true, this.graph()), ConstantNode.forBoolean(false, this.graph()), NodeView.DEFAULT);
        if (!result.isAlive()) {
            tool.addNode(result);
        }
        tool.replaceWith(result);
    }
}

