/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.MonitorEnter;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_64, cyclesRationale="Rough estimation of the enter operation", size=NodeSize.SIZE_64)
public final class RawMonitorEnterNode
extends AccessMonitorNode
implements Virtualizable,
Lowerable,
IterableNodeType,
MonitorEnter,
MemoryCheckpoint.Single {
    public static final NodeClass<RawMonitorEnterNode> TYPE = NodeClass.create(RawMonitorEnterNode.class);
    @Node.Input
    ValueNode hub;

    public RawMonitorEnterNode(ValueNode object, ValueNode hub, MonitorIdNode monitorId) {
        super(TYPE, object, monitorId);
        assert (((ObjectStamp)object.stamp(NodeView.DEFAULT)).nonNull());
        this.hub = hub;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualObjectNode virtual;
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode && (virtual = (VirtualObjectNode)alias).hasIdentity()) {
            tool.addLock(virtual, this.getMonitorId());
            tool.delete();
        }
    }

    public ValueNode getHub() {
        return this.hub;
    }
}

