/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public class NewMultiArrayNode
extends DeoptimizingFixedWithNextNode
implements Lowerable,
ArrayLengthProvider {
    public static final NodeClass<NewMultiArrayNode> TYPE = NodeClass.create(NewMultiArrayNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> dimensions;
    protected final ResolvedJavaType type;

    public ValueNode dimension(int index) {
        return (ValueNode)this.dimensions.get(index);
    }

    public int dimensionCount() {
        return this.dimensions.size();
    }

    public NodeList<ValueNode> dimensions() {
        return this.dimensions;
    }

    public NewMultiArrayNode(ResolvedJavaType type, ValueNode[] dimensions) {
        this(TYPE, type, dimensions);
    }

    protected NewMultiArrayNode(NodeClass<? extends NewMultiArrayNode> c, ResolvedJavaType type, ValueNode[] dimensions) {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)c, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(type)));
        this.type = type;
        this.dimensions = new NodeInputList((Node)this, (Node[])dimensions);
        assert (dimensions.length > 0 && type.isArray());
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    public ResolvedJavaType type() {
        return this.type;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        return this.dimension(0);
    }
}

