/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.MonitorExit;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class MonitorExitNode
extends AccessMonitorNode
implements Virtualizable,
Lowerable,
IterableNodeType,
MonitorExit,
MemoryCheckpoint.Single {
    public static final NodeClass<MonitorExitNode> TYPE = NodeClass.create(MonitorExitNode.class);
    @Node.OptionalInput
    ValueNode escapedReturnValue;

    public MonitorExitNode(ValueNode object, MonitorIdNode monitorId, ValueNode escapedValue) {
        super(TYPE, object, monitorId);
        this.escapedReturnValue = escapedValue;
    }

    public void clearEscapedValue() {
        this.updateUsages(this.escapedReturnValue, null);
        this.escapedReturnValue = null;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualObjectNode virtual;
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode && (virtual = (VirtualObjectNode)alias).hasIdentity()) {
            MonitorIdNode removedLock = tool.removeLock(virtual);
            assert (removedLock == this.getMonitorId()) : "mismatch at " + this + ": " + removedLock + " vs. " + this.getMonitorId();
            tool.delete();
        }
    }
}

