/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DynamicPiNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContextUtil;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.type.StampTool;

public interface GraphBuilderContext
extends GraphBuilderTool {
    public void push(JavaKind var1, ValueNode var2);

    default public ValueNode pop(JavaKind slotKind) {
        throw GraalError.unimplemented();
    }

    default public <T extends ValueNode> T add(T value) {
        if (value.graph() != null) {
            if (!1.$assertionsDisabled && value instanceof StateSplit && ((StateSplit)((Object)value)).stateAfter() == null) {
                throw new AssertionError();
            }
            return value;
        }
        return GraphBuilderContextUtil.setStateAfterIfNecessary(this, this.append(value));
    }

    default public ValueNode addNonNullCast(ValueNode value) {
        AbstractPointerStamp valueStamp = (AbstractPointerStamp)value.stamp(NodeView.DEFAULT);
        if (valueStamp.nonNull()) {
            return value;
        }
        LogicNode isNull = this.add(IsNullNode.create(value));
        FixedGuardNode fixedGuard = this.add(new FixedGuardNode(isNull, DeoptimizationReason.NullCheckException, DeoptimizationAction.None, true));
        Stamp newStamp = valueStamp.improveWith(StampFactory.objectNonNull());
        return this.add(PiNode.create(value, newStamp, fixedGuard));
    }

    default public <T extends ValueNode> T addPush(JavaKind kind, T value) {
        T equivalentValue = value.graph() != null ? value : this.append(value);
        this.push(kind, equivalentValue);
        return GraphBuilderContextUtil.setStateAfterIfNecessary(this, equivalentValue);
    }

    public Invoke handleReplacedInvoke(CallTargetNode.InvokeKind var1, ResolvedJavaMethod var2, ValueNode[] var3, boolean var4);

    public void handleReplacedInvoke(CallTargetNode var1, JavaKind var2);

    public boolean intrinsify(BytecodeProvider var1, ResolvedJavaMethod var2, ResolvedJavaMethod var3, InvocationPlugin.Receiver var4, ValueNode[] var5);

    public boolean intrinsify(ResolvedJavaMethod var1, StructuredGraph var2, InvocationPlugin.Receiver var3, ValueNode[] var4);

    public void setStateAfter(StateSplit var1);

    public GraphBuilderContext getParent();

    default public GraphBuilderContext getNonIntrinsicAncestor() {
        GraphBuilderContext ancestor;
        for (ancestor = this.getParent(); ancestor != null && ancestor.parsingIntrinsic(); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    public Bytecode getCode();

    public ResolvedJavaMethod getMethod();

    public int bci();

    public CallTargetNode.InvokeKind getInvokeKind();

    public JavaType getInvokeReturnType();

    default public StampPair getInvokeReturnStamp(Assumptions assumptions) {
        JavaType returnType = this.getInvokeReturnType();
        return StampFactory.forDeclaredType(assumptions, returnType, false);
    }

    default public int getDepth() {
        int result = 0;
        for (GraphBuilderContext parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ++result;
        }
        return result;
    }

    @Override
    default public boolean parsingIntrinsic() {
        return this.getIntrinsic() != null;
    }

    default public boolean isPluginEnabled(GraphBuilderPlugin plugin) {
        return this.parsingIntrinsic() || !(plugin instanceof GeneratedInvocationPlugin) || !((GeneratedInvocationPlugin)plugin).isGeneratedFromFoldOrNodeIntrinsic();
    }

    public IntrinsicContext getIntrinsic();

    public BailoutException bailout(String var1);

    default public ValueNode nullCheckedValue(ValueNode value) {
        return this.nullCheckedValue(value, DeoptimizationAction.InvalidateReprofile);
    }

    default public ValueNode nullCheckedValue(ValueNode value, DeoptimizationAction action) {
        if (!StampTool.isPointerNonNull(value)) {
            LogicNode condition = this.getGraph().unique(IsNullNode.create(value));
            FixedGuardNode fixedGuard = this.append(new FixedGuardNode(condition, DeoptimizationReason.NullCheckException, action, true));
            ValueNode nonNullReceiver = this.getGraph().addOrUniqueWithInputs(PiNode.create(value, StampFactory.objectNonNull(), fixedGuard));
            return nonNullReceiver;
        }
        return value;
    }

    default public void genCheckcastDynamic(ValueNode object, ValueNode javaClass) {
        LogicNode condition = InstanceOfDynamicNode.create(this.getAssumptions(), this.getConstantReflection(), javaClass, object, true);
        if (condition.isTautology()) {
            this.addPush(JavaKind.Object, object);
        } else {
            this.append(condition);
            FixedGuardNode fixedGuard = this.add(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.InvalidateReprofile, false));
            this.addPush(JavaKind.Object, DynamicPiNode.create(this.getAssumptions(), this.getConstantReflection(), object, fixedGuard, javaClass));
        }
    }

    default public void notifyReplacedCall(ResolvedJavaMethod targetMethod, ConstantNode node) {
    }

    default public ExternalInliningContext getExternalInliningContext() {
        return null;
    }

    default public ValueNode maskSubWordValue(ValueNode value, JavaKind kind) {
        if (kind == kind.getStackKind()) {
            return value;
        }
        ValueNode narrow = this.append(NarrowNode.create(value, kind.getBitCount(), NodeView.DEFAULT));
        if (kind.isUnsigned()) {
            return this.append(ZeroExtendNode.create(narrow, 32, NodeView.DEFAULT));
        }
        return this.append(SignExtendNode.create(narrow, 32, NodeView.DEFAULT));
    }

    default public boolean needsExplicitException() {
        return false;
    }

    default public AbstractBeginNode genExplicitExceptionEdge(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind) {
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface ExternalInliningContext {
        public int getInlinedDepth();
    }
}

