/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.gc;

import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ArrayRangeWrite;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import org.graalvm.compiler.nodes.gc.SerialWriteBarrier;
import org.graalvm.compiler.nodes.gc.WriteBarrier;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

public class CardTableBarrierSet
implements BarrierSet {
    @Override
    public void addBarriers(FixedAccessNode n) {
        if (!(n instanceof ReadNode)) {
            if (n instanceof WriteNode) {
                WriteNode write = (WriteNode)n;
                this.addWriteBarrier(write, write.value());
            } else if (n instanceof LoweredAtomicReadAndWriteNode) {
                LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
                this.addWriteBarrier(atomic, atomic.getNewValue());
            } else if (n instanceof AbstractCompareAndSwapNode) {
                AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
                this.addWriteBarrier(cmpSwap, cmpSwap.getNewValue());
            } else if (n instanceof ArrayRangeWrite) {
                this.addArrayRangeBarriers((ArrayRangeWrite)((Object)n));
            } else {
                GraalError.guarantee(n.getBarrierType() == HeapAccess.BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
            }
        }
    }

    public boolean needsBarrier(FixedAccessNode n) {
        if (n instanceof ReadNode) {
            return false;
        }
        if (n instanceof WriteNode) {
            WriteNode write = (WriteNode)n;
            return this.needsWriteBarrier(write, write.value());
        }
        if (n instanceof LoweredAtomicReadAndWriteNode) {
            LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
            return this.needsWriteBarrier(atomic, atomic.getNewValue());
        }
        if (n instanceof AbstractCompareAndSwapNode) {
            AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
            return this.needsWriteBarrier(cmpSwap, cmpSwap.getNewValue());
        }
        if (n instanceof ArrayRangeWrite) {
            return CardTableBarrierSet.needsWriteBarrier((ArrayRangeWrite)((Object)n));
        }
        GraalError.guarantee(n.getBarrierType() == HeapAccess.BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
        return false;
    }

    public boolean hasBarrier(FixedAccessNode n) {
        if (n instanceof ReadNode) {
            return false;
        }
        if (n instanceof WriteNode) {
            WriteNode write = (WriteNode)n;
            return CardTableBarrierSet.hasWriteBarrier(write);
        }
        if (n instanceof LoweredAtomicReadAndWriteNode) {
            LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
            return CardTableBarrierSet.hasWriteBarrier(atomic);
        }
        if (n instanceof AbstractCompareAndSwapNode) {
            AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
            return CardTableBarrierSet.hasWriteBarrier(cmpSwap);
        }
        if (n instanceof ArrayRangeWrite) {
            return CardTableBarrierSet.hasWriteBarrier((ArrayRangeWrite)((Object)n));
        }
        GraalError.guarantee(n.getBarrierType() == HeapAccess.BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
        return false;
    }

    public boolean isMatchingBarrier(FixedAccessNode n, WriteBarrier barrier) {
        if (n instanceof ReadNode) {
            return false;
        }
        if (n instanceof WriteNode || n instanceof LoweredAtomicReadAndWriteNode || n instanceof AbstractCompareAndSwapNode || n instanceof ArrayRangeWrite) {
            return barrier instanceof SerialWriteBarrier && CardTableBarrierSet.matches(n, (SerialWriteBarrier)barrier);
        }
        throw GraalError.shouldNotReachHere("Unexpected node: " + n.getClass());
    }

    public void addArrayRangeBarriers(ArrayRangeWrite write) {
        if (CardTableBarrierSet.needsWriteBarrier(write)) {
            StructuredGraph graph = write.asNode().graph();
            SerialArrayRangeWriteBarrier serialArrayRangeWriteBarrier = graph.add(new SerialArrayRangeWriteBarrier(write.getAddress(), write.getLength(), write.getElementStride()));
            graph.addAfterFixed(write.asNode(), serialArrayRangeWriteBarrier);
        }
    }

    private void addWriteBarrier(FixedAccessNode node, ValueNode writtenValue) {
        if (this.needsWriteBarrier(node, writtenValue)) {
            CardTableBarrierSet.addSerialPostWriteBarrier(node, node.getAddress(), node.graph());
        }
    }

    public boolean needsWriteBarrier(FixedAccessNode node, ValueNode writtenValue) {
        assert (!(node instanceof ArrayRangeWrite));
        HeapAccess.BarrierType barrierType = node.getBarrierType();
        switch (barrierType) {
            case NONE: {
                return false;
            }
            case FIELD: 
            case ARRAY: 
            case UNKNOWN: {
                return this.writeRequiresBarrier(node, writtenValue);
            }
        }
        throw new GraalError("unexpected barrier type: " + (Object)((Object)barrierType));
    }

    protected boolean writeRequiresBarrier(FixedAccessNode node, ValueNode writtenValue) {
        return CardTableBarrierSet.isNonNullObjectValue(writtenValue);
    }

    public static boolean needsWriteBarrier(ArrayRangeWrite write) {
        return write.writesObjectArray();
    }

    private static boolean hasWriteBarrier(FixedAccessNode node) {
        return node.next() instanceof SerialWriteBarrier && CardTableBarrierSet.matches(node, (SerialWriteBarrier)node.next());
    }

    private static boolean hasWriteBarrier(ArrayRangeWrite write) {
        FixedAccessNode node = write.asNode();
        return node.next() instanceof SerialArrayRangeWriteBarrier && CardTableBarrierSet.matches(write, (SerialArrayRangeWriteBarrier)node.next());
    }

    private static void addSerialPostWriteBarrier(FixedAccessNode node, AddressNode address, StructuredGraph graph) {
        boolean precise = node.getBarrierType() != HeapAccess.BarrierType.FIELD;
        graph.addAfterFixed(node, graph.add(new SerialWriteBarrier(address, precise)));
    }

    private static boolean isNonNullObjectValue(ValueNode value) {
        return value.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp && !StampTool.isPointerAlwaysNull(value);
    }

    private static boolean matches(FixedAccessNode node, SerialWriteBarrier barrier) {
        if (!barrier.usePrecise() && barrier.getAddress() instanceof OffsetAddressNode && node.getAddress() instanceof OffsetAddressNode) {
            return GraphUtil.unproxify(((OffsetAddressNode)barrier.getAddress()).getBase()) == GraphUtil.unproxify(((OffsetAddressNode)node.getAddress()).getBase());
        }
        return barrier.getAddress() == node.getAddress();
    }

    private static boolean matches(ArrayRangeWrite node, SerialArrayRangeWriteBarrier barrier) {
        return barrier.getAddress() == node.getAddress() && node.getLength() == barrier.getLength() && node.getElementStride() == barrier.getElementStride();
    }
}

