/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import java.util.Arrays;
import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSuccessorList;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="We cannot estimate the runtime cost of a switch statement without knowing the numberof case statements and the involved keys.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="We cannot estimate the code size of a switch statement without knowing the numberof case statements.")
public abstract class SwitchNode
extends ControlSplitNode {
    public static final NodeClass<SwitchNode> TYPE = NodeClass.create(SwitchNode.class);
    @Node.Successor
    protected NodeSuccessorList<AbstractBeginNode> successors;
    @Node.Input
    protected ValueNode value;
    protected final double[] keyProbabilities;
    protected final int[] keySuccessors;

    protected SwitchNode(NodeClass<? extends SwitchNode> c, ValueNode value, AbstractBeginNode[] successors, int[] keySuccessors, double[] keyProbabilities) {
        super((NodeClass<? extends ControlSplitNode>)c, StampFactory.forVoid());
        assert (value.stamp(NodeView.DEFAULT).getStackKind().isNumericInteger() || value.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp) : value.stamp(NodeView.DEFAULT) + " key not supported by SwitchNode";
        assert (keySuccessors.length == keyProbabilities.length);
        this.successors = new NodeSuccessorList((Node)this, (Node[])successors);
        this.value = value;
        this.keySuccessors = keySuccessors;
        this.keyProbabilities = keyProbabilities;
        assert (this.assertProbabilities());
    }

    private boolean assertProbabilities() {
        double total = 0.0;
        for (double d : this.keyProbabilities) {
            total += d;
            assert (d >= 0.0) : "Cannot have negative probabilities in switch node: " + d;
        }
        assert (total > 0.999 && total < 1.001) : "Total " + total;
        return true;
    }

    @Override
    public int getSuccessorCount() {
        return this.successors.count();
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        double sum = 0.0;
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            if (this.successors.get(this.keySuccessors[i]) != successor) continue;
            sum += this.keyProbabilities[i];
        }
        return sum;
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, double value) {
        assert (value <= 1.0 && value >= 0.0) : value;
        assert (this.assertProbabilities());
        double sum = 0.0;
        double otherSum = 0.0;
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            if (this.successors.get(this.keySuccessors[i]) == successor) {
                sum += this.keyProbabilities[i];
                continue;
            }
            otherSum += this.keyProbabilities[i];
        }
        if (otherSum == 0.0 || sum == 0.0) {
            return false;
        }
        double delta = value - sum;
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            this.keyProbabilities[i] = this.successors.get(this.keySuccessors[i]) == successor ? Math.max(0.0, this.keyProbabilities[i] + delta * this.keyProbabilities[i] / sum) : Math.max(0.0, this.keyProbabilities[i] - delta * this.keyProbabilities[i] / otherSum);
        }
        assert (this.assertProbabilities());
        return true;
    }

    public ValueNode value() {
        return this.value;
    }

    public abstract boolean isSorted();

    public abstract int keyCount();

    public abstract Constant keyAt(int var1);

    public boolean structureEquals(SwitchNode switchNode) {
        return Arrays.equals(this.keySuccessors, switchNode.keySuccessors) && this.equalKeys(switchNode);
    }

    public abstract boolean equalKeys(SwitchNode var1);

    public int keySuccessorIndex(int i) {
        return this.keySuccessors[i];
    }

    public AbstractBeginNode keySuccessor(int i) {
        return (AbstractBeginNode)this.successors.get(this.keySuccessors[i]);
    }

    public double keyProbability(int i) {
        return this.keyProbabilities[i];
    }

    public double defaultProbability() {
        return this.keyProbabilities[this.keyProbabilities.length - 1];
    }

    public int defaultSuccessorIndex() {
        return this.keySuccessors[this.keySuccessors.length - 1];
    }

    public AbstractBeginNode blockSuccessor(int i) {
        return (AbstractBeginNode)this.successors.get(i);
    }

    public void setBlockSuccessor(int i, AbstractBeginNode s) {
        this.successors.set(i, (Object)s);
    }

    public int blockSuccessorCount() {
        return this.successors.count();
    }

    public AbstractBeginNode defaultSuccessor() {
        if (this.defaultSuccessorIndex() == -1) {
            throw new GraalError("unexpected");
        }
        return (AbstractBeginNode)this.successors.get(this.defaultSuccessorIndex());
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return null;
    }

    protected void killOtherSuccessors(SimplifierTool tool, int survivingEdge) {
        for (Node successor : this.successors()) {
            if (successor == this.blockSuccessor(survivingEdge)) continue;
            tool.deleteBranch(successor);
        }
        tool.addToWorkList(this.blockSuccessor(survivingEdge));
        this.graph().removeSplit(this, this.blockSuccessor(survivingEdge));
    }

    public abstract Stamp getValueStampForSuccessor(AbstractBeginNode var1);

    @Override
    public NodeCycles estimatedNodeCycles() {
        if (this.keyCount() == 1) {
            return NodeCycles.CYCLES_2;
        }
        if (this.isSorted()) {
            return NodeCycles.CYCLES_8;
        }
        return NodeCycles.CYCLES_64;
    }

    @Override
    public NodeSize estimatedNodeSize() {
        if (this.keyCount() == 1) {
            return NodeSize.SIZE_2;
        }
        if (this.isSorted()) {
            return NodeSize.SIZE_8;
        }
        return NodeSize.SIZE_64;
    }
}

