/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class NullCheckNode
extends DeoptimizingFixedWithNextNode
implements LIRLowerable,
GuardingNode {
    public static final NodeClass<NullCheckNode> TYPE = NodeClass.create(NullCheckNode.class);
    @Node.Input
    ValueNode object;

    public NullCheckNode(ValueNode object) {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.object = object;
    }

    public ValueNode getObject() {
        return this.object;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.getLIRGeneratorTool().emitNullCheck(generator.operand(this.object), generator.state(this));
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Node.NodeIntrinsic
    public static native void nullCheck(Object var0);
}

