/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class GetClassNode
extends FloatingNode
implements Lowerable,
Canonicalizable,
Virtualizable {
    public static final NodeClass<GetClassNode> TYPE = NodeClass.create(GetClassNode.class);
    @Node.Input
    ValueNode object;

    public ValueNode getObject() {
        return this.object;
    }

    public GetClassNode(Stamp stamp, ValueNode object) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        this.object = object;
        assert (((ObjectStamp)object.stamp(NodeView.DEFAULT)).nonNull());
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    public static ValueNode tryFold(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, NodeView view, ValueNode object) {
        ObjectStamp objectStamp;
        if (metaAccess != null && object != null && object.stamp(view) instanceof ObjectStamp && (objectStamp = (ObjectStamp)object.stamp(view)).isExactType()) {
            return ConstantNode.forConstant(constantReflection.asJavaClass(objectStamp.type()), metaAccess);
        }
        return null;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        NodeView view = NodeView.from(tool);
        ValueNode folded = GetClassNode.tryFold(tool.getMetaAccess(), tool.getConstantReflection(), view, this.getObject());
        return folded == null ? this : folded;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getObject());
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            JavaConstant javaClass = tool.getConstantReflection().asJavaClass(virtual.type());
            tool.replaceWithValue(ConstantNode.forConstant(this.stamp(NodeView.DEFAULT), (Constant)javaClass, tool.getMetaAccess(), this.graph()));
        }
    }
}

