/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="ForeignCall#{p#descriptor/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, cyclesRationale="Rough estimation of the call operation itself.", size=NodeSize.SIZE_2, sizeRationale="Rough estimation of the call operation itself.")
public class ForeignCallNode
extends AbstractMemoryCheckpoint
implements LIRLowerable,
DeoptimizingNode.DeoptDuring,
MemoryCheckpoint.Multi {
    public static final NodeClass<ForeignCallNode> TYPE = NodeClass.create(ForeignCallNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateDuring;
    protected final ForeignCallsProvider foreignCalls;
    protected final ForeignCallDescriptor descriptor;
    protected int bci = -5;

    public static boolean intrinsify(GraphBuilderContext b, ResolvedJavaMethod targetMethod, @Node.InjectedNodeParameter Stamp returnStamp, @Node.InjectedNodeParameter ForeignCallsProvider foreignCalls, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        JavaKind returnKind;
        if (!foreignCalls.isAvailable(descriptor)) {
            return false;
        }
        ForeignCallNode node = new ForeignCallNode(foreignCalls, descriptor, arguments);
        node.setStamp(returnStamp);
        assert (ForeignCallNode.verifyDescriptor(b, targetMethod, descriptor));
        GraphBuilderContext nonIntrinsicAncestor = b.getNonIntrinsicAncestor();
        if (nonIntrinsicAncestor != null) {
            node.setBci(nonIntrinsicAncestor.bci());
        }
        if ((returnKind = targetMethod.getSignature().getReturnKind()) == JavaKind.Void) {
            b.add(node);
        } else {
            b.addPush(returnKind, node);
        }
        return true;
    }

    static boolean verifyDescriptor(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ForeignCallDescriptor descriptor) {
        int parameters = 1;
        for (Class<?> arg : descriptor.getArgumentTypes()) {
            ResolvedJavaType res = b.getMetaAccess().lookupJavaType(arg);
            ResolvedJavaType parameterType = (ResolvedJavaType)targetMethod.getSignature().getParameterType(parameters, targetMethod.getDeclaringClass());
            assert (parameterType.equals(res)) : descriptor + ": parameter " + parameters + " mismatch: " + res + " != " + parameterType;
            ++parameters;
        }
        return true;
    }

    public ForeignCallNode(ForeignCallsProvider foreignCalls, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        this(TYPE, foreignCalls, descriptor, arguments);
    }

    public ForeignCallNode(ForeignCallsProvider foreignCalls, ForeignCallDescriptor descriptor, Stamp stamp, List<ValueNode> arguments) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, stamp);
        this.arguments = new NodeInputList<ValueNode>((Node)this, arguments);
        this.descriptor = descriptor;
        this.foreignCalls = foreignCalls;
        assert (descriptor.getArgumentTypes().length == this.arguments.size()) : "wrong number of arguments to " + this;
    }

    public ForeignCallNode(ForeignCallsProvider foreignCalls, ForeignCallDescriptor descriptor, Stamp stamp) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, stamp);
        this.arguments = new NodeInputList(this);
        this.descriptor = descriptor;
        this.foreignCalls = foreignCalls;
    }

    protected ForeignCallNode(NodeClass<? extends ForeignCallNode> c, ForeignCallsProvider foreignCalls, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)c, StampFactory.forKind(JavaKind.fromJavaClass(descriptor.getResultType())));
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.descriptor = descriptor;
        this.foreignCalls = foreignCalls;
        assert (descriptor.getArgumentTypes().length == this.arguments.size()) : "wrong number of arguments to " + this;
    }

    @Override
    public boolean hasSideEffect() {
        return !this.foreignCalls.isReexecutable(this.descriptor);
    }

    public ForeignCallDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return this.foreignCalls.getKilledLocations(this.descriptor);
    }

    protected Value[] operands(NodeLIRBuilderTool gen) {
        Value[] operands = new Value[this.arguments.size()];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = gen.operand((Node)this.arguments.get(i));
        }
        return operands;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage = gen.getLIRGeneratorTool().getForeignCalls().lookupForeignCall(this.descriptor);
        Value[] operands = this.operands(gen);
        Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, gen.state(this), operands);
        if (result != null) {
            gen.setResult(this, (Value)result);
        }
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (this.hasSideEffect() || x == null);
        super.setStateAfter(x);
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    public int getBci() {
        return this.bci;
    }

    public void setBci(int bci) {
        assert (this.bci == -5 || this.bci == bci);
        this.bci = bci;
    }

    @Override
    public void computeStateDuring(FrameState currentStateAfter) {
        FrameState newStateDuring;
        if (currentStateAfter.stackSize() > 0 && currentStateAfter.stackAt(currentStateAfter.stackSize() - 1) == this || currentStateAfter.stackSize() > 1 && currentStateAfter.stackAt(currentStateAfter.stackSize() - 2) == this) {
            assert (this.bci != -5) : this;
            newStateDuring = currentStateAfter.duplicateModifiedDuringCall(this.bci, this.getStackKind());
        } else {
            newStateDuring = currentStateAfter;
        }
        this.setStateDuring(newStateDuring);
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + this.descriptor;
        }
        return super.toString(verbosity);
    }

    @Override
    public boolean canDeoptimize() {
        return this.foreignCalls.canDeoptimize(this.descriptor);
    }

    public boolean isGuaranteedSafepoint() {
        return this.foreignCalls.isGuaranteedSafepoint(this.descriptor);
    }

    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }
}

