/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.debug;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class StringToBytesNode
extends FixedWithNextNode
implements Lowerable,
MemoryCheckpoint.Single {
    public static final NodeClass<StringToBytesNode> TYPE = NodeClass.create(StringToBytesNode.class);
    private final String value;

    public StringToBytesNode(String value, Stamp stamp) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(JavaKind.Byte);
    }
}

