/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="%", cycles=NodeCycles.CYCLES_32)
public class RemNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Rem>
implements Lowerable {
    public static final NodeClass<RemNode> TYPE = NodeClass.create(RemNode.class);

    protected RemNode(ValueNode x, ValueNode y) {
        this(TYPE, x, y);
    }

    protected RemNode(NodeClass<? extends RemNode> c, ValueNode x, ValueNode y) {
        super(c, RemNode.getArithmeticOpTable(x).getRem(), x, y);
    }

    public static ValueNode create(ValueNode forX, ValueNode forY, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Rem> op = ArithmeticOpTable.forStamp(forX.stamp(view)).getRem();
        ConstantNode tryConstantFold = RemNode.tryConstantFold(op, forX, forY, stamp = op.foldStamp(forX.stamp(view), forY.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new RemNode(forX, forY);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Rem> getOp(ArithmeticOpTable table) {
        return table.getRem();
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitRem(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY()), null));
    }
}

