/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.BinaryOpLogicNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AbstractNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.PointerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.memory.VolatileReadNode;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public abstract class CompareNode
extends BinaryOpLogicNode
implements Canonicalizable.Binary<ValueNode> {
    public static final NodeClass<CompareNode> TYPE = NodeClass.create(CompareNode.class);
    protected final CanonicalCondition condition;
    protected final boolean unorderedIsTrue;

    protected CompareNode(NodeClass<? extends CompareNode> c, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode x, ValueNode y) {
        super(c, x, y);
        this.condition = condition;
        this.unorderedIsTrue = unorderedIsTrue;
    }

    public final CanonicalCondition condition() {
        return this.condition;
    }

    public final boolean unorderedIsTrue() {
        return this.unorderedIsTrue;
    }

    public static LogicNode tryConstantFold(CanonicalCondition condition, ValueNode forX, ValueNode forY, ConstantReflectionProvider constantReflection, boolean unorderedIsTrue) {
        if (forX.isConstant() && forY.isConstant() && (constantReflection != null || forX.asConstant() instanceof PrimitiveConstant)) {
            return LogicConstantNode.forBoolean(condition.foldCondition(forX.asConstant(), forY.asConstant(), constantReflection, unorderedIsTrue));
        }
        return null;
    }

    public static LogicNode tryConstantFoldPrimitive(CanonicalCondition condition, ValueNode forX, ValueNode forY, boolean unorderedIsTrue, NodeView view) {
        if (forX.asConstant() instanceof PrimitiveConstant && forY.asConstant() instanceof PrimitiveConstant) {
            return LogicConstantNode.forBoolean(condition.foldCondition((PrimitiveConstant)forX.asConstant(), (PrimitiveConstant)forY.asConstant(), unorderedIsTrue));
        }
        return null;
    }

    public boolean isIdentityComparison() {
        return this.condition == CanonicalCondition.EQ;
    }

    public static LogicNode createCompareNode(StructuredGraph graph, CanonicalCondition condition, ValueNode x, ValueNode y, ConstantReflectionProvider constantReflection, NodeView view) {
        LogicNode result = CompareNode.createCompareNode(condition, x, y, constantReflection, view);
        return result.graph() == null ? graph.addOrUniqueWithInputs(result) : result;
    }

    public static LogicNode createCompareNode(CanonicalCondition condition, ValueNode x, ValueNode y, ConstantReflectionProvider constantReflection, NodeView view) {
        LogicNode comparison;
        assert (x.getStackKind() == y.getStackKind());
        assert (!x.getStackKind().isNumericFloat());
        if (condition == CanonicalCondition.EQ) {
            if (x.stamp(view) instanceof AbstractObjectStamp) {
                comparison = ObjectEqualsNode.create(x, y, constantReflection, view);
            } else if (x.stamp(view) instanceof AbstractPointerStamp) {
                comparison = PointerEqualsNode.create(x, y, view);
            } else {
                assert (x.getStackKind().isNumericInteger());
                comparison = IntegerEqualsNode.create(x, y, view);
            }
        } else if (condition == CanonicalCondition.LT) {
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerLessThanNode.create(x, y, view);
        } else {
            assert (condition == CanonicalCondition.BT);
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerBelowNode.create(x, y, view);
        }
        return comparison;
    }

    public static LogicNode createCompareNode(StructuredGraph graph, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = CompareNode.createCompareNode(constantReflection, metaAccess, options, smallestCompareWidth, condition, x, y, view);
        return result.graph() == null ? graph.addOrUniqueWithInputs(result) : result;
    }

    public static LogicNode createCompareNode(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, ValueNode x, ValueNode y, NodeView view) {
        LogicNode comparison;
        assert (x.getStackKind() == y.getStackKind());
        assert (!x.getStackKind().isNumericFloat());
        if (condition == CanonicalCondition.EQ) {
            if (x.stamp(view) instanceof AbstractObjectStamp) {
                assert (smallestCompareWidth == null);
                comparison = ObjectEqualsNode.create(constantReflection, metaAccess, options, x, y, view);
            } else if (x.stamp(view) instanceof AbstractPointerStamp) {
                comparison = PointerEqualsNode.create(x, y, view);
            } else {
                assert (x.getStackKind().isNumericInteger());
                comparison = IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, x, y, view);
            }
        } else if (condition == CanonicalCondition.LT) {
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerLessThanNode.create(constantReflection, metaAccess, options, smallestCompareWidth, x, y, view);
        } else {
            assert (condition == CanonicalCondition.BT);
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerBelowNode.create(constantReflection, metaAccess, options, smallestCompareWidth, x, y, view);
        }
        return comparison;
    }

    public static abstract class CompareOp {
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode constantCondition = CompareNode.tryConstantFold(condition, forX, forY, constantReflection, unorderedIsTrue);
            if (constantCondition != null) {
                return constantCondition;
            }
            if (forX.isConstant()) {
                LogicNode result = this.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, forX.asConstant(), forY, true, unorderedIsTrue, view);
                if (result != null) {
                    return result;
                }
            } else if (forY.isConstant()) {
                LogicNode result = this.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, forY.asConstant(), forX, false, unorderedIsTrue, view);
                if (result != null) {
                    return result;
                }
            } else if (forX instanceof ConvertNode && forY instanceof ConvertNode) {
                ConvertNode convertX = (ConvertNode)((Object)forX);
                ConvertNode convertY = (ConvertNode)((Object)forY);
                if (convertX.preservesOrder(condition) && convertY.preservesOrder(condition) && convertX.getValue().stamp(view).isCompatible(convertY.getValue().stamp(view))) {
                    boolean supported = true;
                    if (convertX.getValue().stamp(view) instanceof IntegerStamp) {
                        IntegerStamp intStamp = (IntegerStamp)convertX.getValue().stamp(view);
                        boolean isConversionCompatible = convertX.getClass() == convertY.getClass();
                        boolean bl = supported = smallestCompareWidth != null && intStamp.getBits() >= smallestCompareWidth && isConversionCompatible;
                    }
                    if (supported) {
                        ValueNode xValue = convertX.getValue();
                        ValueNode yValue = convertY.getValue();
                        if (forX instanceof ZeroExtendNode || forX instanceof SignExtendNode) {
                            int introducedUsages = 0;
                            int eliminatedNodes = 0;
                            if (convertX.asNode().hasExactlyOneUsage()) {
                                ++eliminatedNodes;
                            } else if (xValue.hasExactlyOneUsage()) {
                                ++introducedUsages;
                            }
                            if (convertY.asNode().hasExactlyOneUsage()) {
                                ++eliminatedNodes;
                            } else if (yValue.hasExactlyOneUsage()) {
                                ++introducedUsages;
                            }
                            if (introducedUsages > eliminatedNodes) {
                                return null;
                            }
                        }
                        return this.duplicateModified(convertX.getValue(), convertY.getValue(), unorderedIsTrue, view);
                    }
                }
            }
            return null;
        }

        protected LogicNode canonicalizeSymmetricConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, Constant constant, ValueNode nonConstant, boolean mirrored, boolean unorderedIsTrue, NodeView view) {
            if (nonConstant instanceof ConditionalNode) {
                Condition realCondition = condition.asCondition();
                if (mirrored) {
                    realCondition = realCondition.mirror();
                }
                return CompareOp.optimizeConditional(constant, (ConditionalNode)nonConstant, constantReflection, realCondition, unorderedIsTrue);
            }
            if (nonConstant instanceof AbstractNormalizeCompareNode) {
                return this.optimizeNormalizeCompare(constantReflection, metaAccess, options, smallestCompareWidth, constant, (AbstractNormalizeCompareNode)nonConstant, mirrored, view);
            }
            if (nonConstant instanceof ConvertNode) {
                ConstantNode newConstant;
                NarrowNode narrowNode;
                boolean multiUsage;
                ConvertNode convert = (ConvertNode)((Object)nonConstant);
                boolean bl = multiUsage = convert.asNode().hasMoreThanOneUsage() && convert.getValue().hasExactlyOneUsage();
                if (!multiUsage && convert.asNode().hasMoreThanOneUsage() && convert.getValue() instanceof VolatileReadNode) {
                    VolatileReadNode read = (VolatileReadNode)convert.getValue();
                    int nonMemoryEdges = 0;
                    for (Node u : read.usages()) {
                        for (Position pos : u.inputPositions()) {
                            if (pos.get(u) != read || pos.getInputType() == InputType.Memory) continue;
                            ++nonMemoryEdges;
                        }
                    }
                    boolean bl2 = multiUsage = nonMemoryEdges == 1;
                }
                if (convert instanceof IntegerConvertNode && multiUsage) {
                    return null;
                }
                if (convert instanceof NarrowNode && (narrowNode = (NarrowNode)convert).getInputBits() > 32 && !constant.isDefaultForKind()) {
                    return null;
                }
                boolean supported = true;
                if (convert.getValue().stamp(view) instanceof IntegerStamp) {
                    IntegerStamp intStamp = (IntegerStamp)convert.getValue().stamp(view);
                    boolean bl3 = supported = smallestCompareWidth != null && intStamp.getBits() >= smallestCompareWidth;
                }
                if (supported && (newConstant = CompareOp.canonicalConvertConstant(constantReflection, metaAccess, options, condition, convert, constant, view)) != null) {
                    if (mirrored) {
                        return this.duplicateModified(newConstant, convert.getValue(), unorderedIsTrue, view);
                    }
                    return this.duplicateModified(convert.getValue(), newConstant, unorderedIsTrue, view);
                }
            }
            return null;
        }

        private static ConstantNode canonicalConvertConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, CanonicalCondition condition, ConvertNode convert, Constant constant, NodeView view) {
            Constant reverseConverted;
            if (convert.preservesOrder(condition, constant, constantReflection) && (reverseConverted = convert.reverse(constant, constantReflection)) != null && convert.convert(reverseConverted, constantReflection).equals(constant)) {
                if (GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
                    return null;
                }
                return ConstantNode.forConstant(convert.getValue().stamp(view), reverseConverted, metaAccess);
            }
            return null;
        }

        protected LogicNode optimizeNormalizeCompare(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, Constant constant, AbstractNormalizeCompareNode normalizeNode, boolean mirrored, NodeView view) {
            throw new PermanentBailoutException("NormalizeCompareNode connected to %s (%s %s %s)", this, constant, normalizeNode, mirrored);
        }

        private static LogicNode optimizeConditional(Constant constant, ConditionalNode conditionalNode, ConstantReflectionProvider constantReflection, Condition cond, boolean unorderedIsTrue) {
            Constant trueConstant = conditionalNode.trueValue().asConstant();
            Constant falseConstant = conditionalNode.falseValue().asConstant();
            if (falseConstant != null && trueConstant != null && constantReflection != null) {
                boolean falseResult;
                boolean trueResult = cond.foldCondition(trueConstant, constant, constantReflection, unorderedIsTrue);
                if (trueResult == (falseResult = cond.foldCondition(falseConstant, constant, constantReflection, unorderedIsTrue))) {
                    return LogicConstantNode.forBoolean(trueResult);
                }
                if (trueResult) {
                    assert (!falseResult);
                    return conditionalNode.condition();
                }
                assert (falseResult);
                return LogicNegationNode.create(conditionalNode.condition());
            }
            return null;
        }

        protected abstract LogicNode duplicateModified(ValueNode var1, ValueNode var2, boolean var3, NodeView var4);
    }
}

