/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(shortName="&")
public final class AndNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.And>
implements NarrowableArithmeticNode,
Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<AndNode> TYPE = NodeClass.create(AndNode.class);

    public AndNode(ValueNode x, ValueNode y) {
        super(TYPE, AndNode.getArithmeticOpTable(x).getAnd(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.And> op = ArithmeticOpTable.forStamp(x.stamp(view)).getAnd();
        ConstantNode tryConstantFold = AndNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return AndNode.canonical(null, op, stamp, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.And> getOp(ArithmeticOpTable table) {
        return table.getAnd();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        NodeView view = NodeView.from(tool);
        return AndNode.canonical(this, this.getOp(forX, forY), this.stamp(view), forX, forY, view);
    }

    private static ValueNode canonical(AndNode self, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.And> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
            return forX;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            return new AndNode(forY, forX);
        }
        if (forY.isConstant()) {
            Constant c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            if (c instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger()) {
                SignExtendNode ext;
                long mask;
                long rawY = ((PrimitiveConstant)c).asLong();
                if ((rawY & (mask = CodeUtil.mask((int)PrimitiveStamp.getBits(stamp)))) == 0L) {
                    return ConstantNode.forIntegerStamp(stamp, 0L);
                }
                if (forX instanceof SignExtendNode && rawY == (1L << (ext = (SignExtendNode)forX).getInputBits()) - 1L) {
                    return new ZeroExtendNode(ext.getValue(), ext.getResultBits());
                }
                IntegerStamp xStamp = (IntegerStamp)forX.stamp(view);
                if (((xStamp.upMask() | xStamp.downMask()) & (rawY ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                    return forX;
                }
            }
            return AndNode.reassociate(self != null ? self : (AndNode)new AndNode(forX, forY).maybeCommuteInputs(), ValueNode.isConstantPredicate(), forX, forY, view);
        }
        if (forX instanceof NotNode && forY instanceof NotNode) {
            return new NotNode(OrNode.create(((NotNode)forX).getValue(), ((NotNode)forY).getValue(), view));
        }
        return self != null ? self : new AndNode(forX, forY).maybeCommuteInputs();
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitAnd(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

