/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.CancellationBailoutException;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.JavaMethodContext;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

public final class StructuredGraph
extends Graph
implements JavaMethodContext {
    public static final long INVALID_GRAPH_ID = -1L;
    private static final AtomicLong uniqueGraphIds = new AtomicLong();
    private StartNode start;
    private ResolvedJavaMethod rootMethod;
    private final long graphId;
    private final CompilationIdentifier compilationId;
    private final int entryBCI;
    private GuardsStage guardsStage = GuardsStage.FLOATING_GUARDS;
    private boolean isAfterFloatingReadPhase = false;
    private boolean isAfterFixedReadPhase = false;
    private boolean hasValueProxies = true;
    private boolean isAfterExpandLogic = false;
    private final boolean useProfilingInfo;
    private final Cancellable cancellable;
    private final boolean isSubstitution;
    private final Assumptions assumptions;
    private SpeculationLog speculationLog;
    private ScheduleResult lastSchedule;
    private final InliningLog inliningLog;
    private final NodeSourcePosition callerContext;
    private final List<ResolvedJavaMethod> methods;
    private EconomicSet<ResolvedJavaField> fields = null;
    private UnsafeAccessState hasUnsafeAccess = UnsafeAccessState.NO_ACCESS;
    public static final boolean USE_PROFILING_INFO = true;
    public static final boolean NO_PROFILING_INFO = false;

    private StructuredGraph(String name, ResolvedJavaMethod method, int entryBCI, Assumptions assumptions, SpeculationLog speculationLog, boolean useProfilingInfo, boolean isSubstitution, List<ResolvedJavaMethod> methods, boolean trackNodeSourcePosition, CompilationIdentifier compilationId, OptionValues options, DebugContext debug, Cancellable cancellable, NodeSourcePosition context) {
        super(name, options, debug, trackNodeSourcePosition);
        this.setStart(this.add(new StartNode()));
        this.rootMethod = method;
        this.graphId = uniqueGraphIds.incrementAndGet();
        this.compilationId = compilationId;
        this.entryBCI = entryBCI;
        this.assumptions = assumptions;
        this.methods = methods;
        this.speculationLog = speculationLog;
        this.useProfilingInfo = useProfilingInfo;
        this.isSubstitution = isSubstitution;
        assert (StructuredGraph.checkIsSubstitutionInvariants(method, isSubstitution));
        this.cancellable = cancellable;
        this.inliningLog = new InliningLog(this.rootMethod, GraalOptions.TraceInlining.getValue(options));
        this.callerContext = context;
    }

    private static boolean checkIsSubstitutionInvariants(ResolvedJavaMethod method, boolean isSubstitution) {
        if (method != null && (method.getAnnotation(Snippet.class) != null || method.getAnnotation(MethodSubstitution.class) != null)) assert (isSubstitution) : "Graph for method " + method.format("%H.%n(%p)") + " annotated by " + Snippet.class.getName() + " or " + MethodSubstitution.class.getName() + " must have its `isSubstitution` field set to true";
        return true;
    }

    public void setLastSchedule(ScheduleResult result) {
        this.lastSchedule = result;
    }

    public ScheduleResult getLastSchedule() {
        return this.lastSchedule;
    }

    public void clearLastSchedule() {
        this.setLastSchedule(null);
    }

    @Override
    public boolean maybeCompress() {
        if (super.maybeCompress()) {
            this.clearLastSchedule();
            return true;
        }
        return false;
    }

    public Stamp getReturnStamp() {
        Stamp returnStamp = null;
        for (ReturnNode returnNode : this.getNodes(ReturnNode.TYPE)) {
            ValueNode result = returnNode.result();
            if (result == null) continue;
            if (returnStamp == null) {
                returnStamp = result.stamp(NodeView.DEFAULT);
                continue;
            }
            returnStamp = returnStamp.meet(result.stamp(NodeView.DEFAULT));
        }
        return returnStamp;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName() + ":" + this.graphId);
        String sep = "{";
        if (this.name != null) {
            buf.append(sep);
            buf.append(this.name);
            sep = ", ";
        }
        if (this.method() != null) {
            buf.append(sep);
            buf.append(this.method());
            sep = ", ";
        }
        if (!sep.equals("{")) {
            buf.append("}");
        }
        return buf.toString();
    }

    public StartNode start() {
        return this.start;
    }

    public ResolvedJavaMethod method() {
        return this.rootMethod;
    }

    public int getEntryBCI() {
        return this.entryBCI;
    }

    public Cancellable getCancellable() {
        return this.cancellable;
    }

    public void checkCancellation() {
        if (this.cancellable != null && this.cancellable.isCancelled()) {
            CancellationBailoutException.cancelCompilation();
        }
    }

    public boolean isOSR() {
        return this.entryBCI != -1;
    }

    public long graphId() {
        return this.graphId;
    }

    public CompilationIdentifier compilationId() {
        return this.compilationId;
    }

    public void setStart(StartNode start) {
        this.start = start;
    }

    public InliningLog getInliningLog() {
        return this.inliningLog;
    }

    public void logInliningTree() {
        String formattedTree;
        if (GraalOptions.TraceInlining.getValue(this.getOptions()).booleanValue() && (formattedTree = this.getInliningLog().formatAsTree(true)) != null) {
            TTY.println(formattedTree);
        }
    }

    @Override
    protected Graph copy(String newName, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, DebugContext debugForCopy) {
        return this.copy(newName, duplicationMapCallback, this.compilationId, debugForCopy);
    }

    private StructuredGraph copy(String newName, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, CompilationIdentifier newCompilationId, DebugContext debugForCopy) {
        UnmodifiableEconomicMap<Node, Node> duplicates;
        AllowAssumptions allowAssumptions = AllowAssumptions.ifNonNull(this.assumptions);
        StructuredGraph copy = new StructuredGraph(newName, this.method(), this.entryBCI, this.assumptions == null ? null : new Assumptions(), this.speculationLog, this.useProfilingInfo, this.isSubstitution, this.methods != null ? new ArrayList<ResolvedJavaMethod>(this.methods) : null, this.trackNodeSourcePosition, newCompilationId, this.getOptions(), debugForCopy, null, this.callerContext);
        if (allowAssumptions == AllowAssumptions.YES && this.assumptions != null) {
            copy.assumptions.record(this.assumptions);
        }
        copy.hasUnsafeAccess = this.hasUnsafeAccess;
        copy.setGuardsStage(this.getGuardsStage());
        copy.isAfterFloatingReadPhase = this.isAfterFloatingReadPhase;
        copy.hasValueProxies = this.hasValueProxies;
        copy.isAfterExpandLogic = this.isAfterExpandLogic;
        copy.trackNodeSourcePosition = this.trackNodeSourcePosition;
        if (this.fields != null) {
            copy.fields = StructuredGraph.createFieldSet(this.fields);
        }
        EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        replacements.put((Object)this.start, (Object)copy.start);
        try (InliningLog.UpdateScope scope = copy.getInliningLog().openDefaultUpdateScope();){
            duplicates = copy.addDuplicates(this.getNodes(), (Graph)this, this.getNodeCount(), (EconomicMap<Node, Node>)replacements);
            if (scope != null) {
                copy.getInliningLog().replaceLog(duplicates, this.getInliningLog());
            }
        }
        if (duplicationMapCallback != null) {
            duplicationMapCallback.accept(duplicates);
        }
        return copy;
    }

    public StructuredGraph copyWithIdentifier(CompilationIdentifier newCompilationId, DebugContext debugForCopy) {
        return this.copy(this.name, null, newCompilationId, debugForCopy);
    }

    public ParameterNode getParameter(int index) {
        for (ParameterNode param : this.getNodes(ParameterNode.TYPE)) {
            if (param.index() != index) continue;
            return param;
        }
        return null;
    }

    public Iterable<Invoke> getInvokes() {
        final Iterator callTargets = this.getNodes(MethodCallTargetNode.TYPE).iterator();
        return new Iterable<Invoke>(){
            private Invoke next;

            @Override
            public Iterator<Invoke> iterator() {
                return new Iterator<Invoke>(){

                    @Override
                    public boolean hasNext() {
                        if (next == null) {
                            while (callTargets.hasNext()) {
                                Invoke i = ((MethodCallTargetNode)callTargets.next()).invoke();
                                if (i == null) continue;
                                next = i;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public Invoke next() {
                        try {
                            Invoke invoke = next;
                            return invoke;
                        }
                        finally {
                            next = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean hasLoops() {
        return this.hasNode(LoopBeginNode.TYPE);
    }

    public void removeFixed(FixedWithNextNode node) {
        assert (node != null);
        if (node instanceof AbstractBeginNode) {
            ((AbstractBeginNode)node).prepareDelete();
        }
        assert (node.hasNoUsages()) : node + " " + node.getUsageCount() + ", " + node.usages().first();
        GraphUtil.unlinkFixedNode(node);
        node.safeDelete();
    }

    public void replaceFixed(FixedWithNextNode node, Node replacement) {
        if (replacement instanceof FixedWithNextNode) {
            this.replaceFixedWithFixed(node, (FixedWithNextNode)replacement);
        } else {
            assert (replacement != null) : "cannot replace " + node + " with null";
            assert (replacement instanceof FloatingNode) : "cannot replace " + node + " with " + replacement;
            this.replaceFixedWithFloating(node, (FloatingNode)replacement);
        }
    }

    public void replaceFixedWithFixed(FixedWithNextNode node, FixedWithNextNode replacement) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        FixedNode next = node.next();
        node.setNext(null);
        replacement.setNext(next);
        node.replaceAndDelete(replacement);
        if (node == this.start) {
            this.setStart((StartNode)replacement);
        }
    }

    public void replaceFixedWithFloating(FixedWithNextNode node, ValueNode replacement) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        GraphUtil.unlinkFixedNode(node);
        node.replaceAtUsagesAndDelete(replacement);
    }

    public void removeSplit(ControlSplitNode node, AbstractBeginNode survivingSuccessor) {
        assert (node != null);
        assert (node.hasNoUsages());
        assert (survivingSuccessor != null);
        node.clearSuccessors();
        node.replaceAtPredecessor(survivingSuccessor);
        node.safeDelete();
    }

    public void removeSplitPropagate(ControlSplitNode node, AbstractBeginNode survivingSuccessor) {
        assert (node != null);
        assert (node.hasNoUsages());
        assert (survivingSuccessor != null);
        List<Node> snapshot = node.successors().snapshot();
        node.clearSuccessors();
        node.replaceAtPredecessor(survivingSuccessor);
        node.safeDelete();
        for (Node successor : snapshot) {
            if (successor == null || !successor.isAlive() || successor == survivingSuccessor) continue;
            GraphUtil.killCFG((FixedNode)successor);
        }
    }

    public void replaceSplit(ControlSplitNode node, Node replacement, AbstractBeginNode survivingSuccessor) {
        if (replacement instanceof FixedWithNextNode) {
            this.replaceSplitWithFixed(node, (FixedWithNextNode)replacement, survivingSuccessor);
        } else {
            assert (replacement != null) : "cannot replace " + node + " with null";
            assert (replacement instanceof FloatingNode) : "cannot replace " + node + " with " + replacement;
            this.replaceSplitWithFloating(node, (FloatingNode)replacement, survivingSuccessor);
        }
    }

    public void replaceSplitWithFixed(ControlSplitNode node, FixedWithNextNode replacement, AbstractBeginNode survivingSuccessor) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        assert (survivingSuccessor != null);
        node.clearSuccessors();
        replacement.setNext(survivingSuccessor);
        node.replaceAndDelete(replacement);
    }

    public void replaceSplitWithFloating(ControlSplitNode node, FloatingNode replacement, AbstractBeginNode survivingSuccessor) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        assert (survivingSuccessor != null);
        node.clearSuccessors();
        node.replaceAtPredecessor(survivingSuccessor);
        node.replaceAtUsagesAndDelete(replacement);
    }

    public void addAfterFixed(FixedWithNextNode node, FixedNode newNode) {
        assert (node != null && newNode != null && node.isAlive() && newNode.isAlive()) : "cannot add " + newNode + " after " + node;
        FixedNode next = node.next();
        node.setNext(newNode);
        if (next != null) {
            assert (newNode instanceof FixedWithNextNode);
            FixedWithNextNode newFixedWithNext = (FixedWithNextNode)newNode;
            assert (newFixedWithNext.next() == null);
            newFixedWithNext.setNext(next);
        }
    }

    public void addBeforeFixed(FixedNode node, FixedWithNextNode newNode) {
        assert (node != null && newNode != null && node.isAlive() && newNode.isAlive()) : "cannot add " + newNode + " before " + node;
        assert (node.predecessor() != null && node.predecessor() instanceof FixedWithNextNode) : "cannot add " + newNode + " before " + node;
        assert (newNode.next() == null) : newNode;
        assert (!(node instanceof AbstractMergeNode));
        FixedWithNextNode pred = (FixedWithNextNode)node.predecessor();
        pred.setNext(newNode);
        newNode.setNext(node);
    }

    public void reduceDegenerateLoopBegin(LoopBeginNode begin) {
        assert (begin.loopEnds().isEmpty()) : "Loop begin still has backedges";
        if (begin.forwardEndCount() == 1) {
            this.reduceTrivialMerge(begin);
        } else {
            AbstractMergeNode merge = this.add(new MergeNode());
            for (EndNode end : begin.forwardEnds()) {
                merge.addForwardEnd(end);
            }
            this.replaceFixedWithFixed(begin, merge);
        }
    }

    public void reduceTrivialMerge(AbstractMergeNode merge) {
        assert (merge.forwardEndCount() == 1);
        assert (!(merge instanceof LoopBeginNode) || ((LoopBeginNode)merge).loopEnds().isEmpty());
        for (PhiNode phi : merge.phis().snapshot()) {
            assert (phi.valueCount() == 1);
            ValueNode singleValue = phi.valueAt(0);
            if (phi.hasUsages()) {
                phi.replaceAtUsagesAndDelete(singleValue);
                continue;
            }
            phi.safeDelete();
            if (singleValue == null) continue;
            GraphUtil.tryKillUnused(singleValue);
        }
        if (merge instanceof LoopBeginNode) {
            ((LoopBeginNode)merge).removeExits();
        }
        EndNode singleEnd = merge.forwardEndAt(0);
        FixedNode sux = merge.next();
        FrameState stateAfter = merge.stateAfter();
        merge.prepareDelete((FixedNode)singleEnd.predecessor());
        merge.safeDelete();
        if (stateAfter != null) {
            GraphUtil.tryKillUnused(stateAfter);
        }
        if (sux == null) {
            singleEnd.replaceAtPredecessor(null);
            singleEnd.safeDelete();
        } else {
            singleEnd.replaceAndDelete(sux);
        }
    }

    public GuardsStage getGuardsStage() {
        return this.guardsStage;
    }

    public void setGuardsStage(GuardsStage guardsStage) {
        assert (guardsStage.ordinal() >= this.guardsStage.ordinal());
        this.guardsStage = guardsStage;
    }

    public boolean isAfterFloatingReadPhase() {
        return this.isAfterFloatingReadPhase;
    }

    public boolean isAfterFixedReadPhase() {
        return this.isAfterFixedReadPhase;
    }

    public void setAfterFloatingReadPhase(boolean state) {
        assert (state) : "cannot 'unapply' floating read phase on graph";
        this.isAfterFloatingReadPhase = state;
    }

    public void setAfterFixReadPhase(boolean state) {
        assert (state) : "cannot 'unapply' fix reads phase on graph";
        this.isAfterFixedReadPhase = state;
    }

    public boolean hasValueProxies() {
        return this.hasValueProxies;
    }

    public void setHasValueProxies(boolean state) {
        assert (!state) : "cannot 'unapply' value proxy removal on graph";
        this.hasValueProxies = state;
    }

    public boolean isAfterExpandLogic() {
        return this.isAfterExpandLogic;
    }

    public void setAfterExpandLogic() {
        this.isAfterExpandLogic = true;
    }

    public boolean useProfilingInfo() {
        return this.useProfilingInfo;
    }

    public boolean isSubstitution() {
        return this.isSubstitution;
    }

    public ProfilingInfo getProfilingInfo() {
        return this.getProfilingInfo(this.method());
    }

    public ProfilingInfo getProfilingInfo(ResolvedJavaMethod m) {
        if (this.useProfilingInfo && m != null) {
            return m.getProfilingInfo();
        }
        return DefaultProfilingInfo.get((TriState)TriState.UNKNOWN);
    }

    public Assumptions getAssumptions() {
        return this.assumptions;
    }

    private boolean checkFrameStatesAgainstInlinedMethods() {
        for (FrameState fs : this.getNodes(FrameState.TYPE)) {
            ResolvedJavaMethod m;
            if (BytecodeFrame.isPlaceholderBci((int)fs.bci) || (m = fs.code.getMethod()).equals(this.rootMethod) || this.methods.contains(m)) continue;
            TreeSet<String> haystack = new TreeSet<String>();
            if (!this.methods.contains(this.rootMethod)) {
                haystack.add(this.rootMethod.format("%H.%n(%p)"));
            }
            for (ResolvedJavaMethod e : this.methods) {
                haystack.add(e.format("%H.%n(%p)"));
            }
            throw new AssertionError((Object)String.format("Could not find %s from %s in set(%s)", m.format("%H.%n(%p)"), fs, haystack.stream().collect(Collectors.joining(System.lineSeparator()))));
        }
        return true;
    }

    private static EconomicSet<ResolvedJavaField> createFieldSet(EconomicSet<ResolvedJavaField> init) {
        if (init != null) {
            return EconomicSet.create((Equivalence)Equivalence.DEFAULT, init);
        }
        return EconomicSet.create((Equivalence)Equivalence.DEFAULT);
    }

    public List<ResolvedJavaMethod> getMethods() {
        if (this.methods != null) {
            assert (this.isSubstitution || this.checkFrameStatesAgainstInlinedMethods());
            return Collections.unmodifiableList(this.methods);
        }
        return Collections.emptyList();
    }

    public void recordMethod(ResolvedJavaMethod method) {
        if (this.methods != null) {
            this.methods.add(method);
        }
    }

    public void updateMethods(StructuredGraph other) {
        if (this.methods != null) {
            if (other.rootMethod != null) {
                this.methods.add(other.rootMethod);
            }
            for (ResolvedJavaMethod m : other.methods) {
                this.methods.add(m);
            }
        }
    }

    public EconomicSet<ResolvedJavaField> getFields() {
        return this.fields;
    }

    public void recordField(ResolvedJavaField field) {
        assert (GraalOptions.GeneratePIC.getValue(this.getOptions()).booleanValue());
        if (this.fields == null) {
            this.fields = StructuredGraph.createFieldSet(null);
        }
        this.fields.add((Object)field);
    }

    public void updateFields(StructuredGraph other) {
        assert (this != other);
        assert (GraalOptions.GeneratePIC.getValue(this.getOptions()).booleanValue());
        if (other.fields != null) {
            if (this.fields == null) {
                this.fields = StructuredGraph.createFieldSet(null);
            }
            this.fields.addAll(other.fields);
        }
    }

    public int getBytecodeSize() {
        int res = 0;
        if (this.rootMethod != null) {
            res += this.rootMethod.getCodeSize();
        }
        if (this.methods != null) {
            for (ResolvedJavaMethod e : this.methods) {
                res += e.getCodeSize();
            }
        }
        return res;
    }

    @Override
    public JavaMethod asJavaMethod() {
        return this.method();
    }

    public boolean hasUnsafeAccess() {
        return this.hasUnsafeAccess == UnsafeAccessState.HAS_ACCESS;
    }

    public void markUnsafeAccess() {
        if (this.hasUnsafeAccess == UnsafeAccessState.DISABLED) {
            return;
        }
        this.hasUnsafeAccess = UnsafeAccessState.HAS_ACCESS;
    }

    public void disableUnsafeAccessTracking() {
        this.hasUnsafeAccess = UnsafeAccessState.DISABLED;
    }

    public boolean isUnsafeAccessTrackingEnabled() {
        return this.hasUnsafeAccess != UnsafeAccessState.DISABLED;
    }

    public SpeculationLog getSpeculationLog() {
        return this.speculationLog;
    }

    public void clearAllStateAfter() {
        for (Node node : this.getNodes()) {
            FrameState stateAfter;
            if (!(node instanceof StateSplit) || (stateAfter = ((StateSplit)((Object)node)).stateAfter()) == null) continue;
            ((StateSplit)((Object)node)).setStateAfter(null);
            if (!stateAfter.isAlive()) continue;
            GraphUtil.killWithUnusedFloatingInputs(stateAfter);
        }
    }

    public boolean hasVirtualizableAllocation() {
        for (Node n : this.getNodes()) {
            if (!(n instanceof VirtualizableAllocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void afterRegister(Node node) {
        assert (this.hasValueProxies() || !(node instanceof ValueProxyNode));
        if (GraalOptions.TraceInlining.getValue(this.getOptions()).booleanValue() && node instanceof Invokable) {
            ((Invokable)((Object)node)).updateInliningLogAfterRegister(this);
        }
    }

    public NodeSourcePosition getCallerContext() {
        return this.callerContext;
    }

    private static enum UnsafeAccessState {
        NO_ACCESS,
        HAS_ACCESS,
        DISABLED;

    }

    public static class Builder {
        private String name;
        private final Assumptions assumptions;
        private SpeculationLog speculationLog;
        private ResolvedJavaMethod rootMethod;
        private CompilationIdentifier compilationId = CompilationIdentifier.INVALID_COMPILATION_ID;
        private int entryBCI = -1;
        private boolean useProfilingInfo = true;
        private boolean recordInlinedMethods = true;
        private boolean trackNodeSourcePosition;
        private final OptionValues options;
        private Cancellable cancellable = null;
        private final DebugContext debug;
        private NodeSourcePosition callerContext;
        private boolean isSubstitution;

        public Builder(OptionValues options, DebugContext debug, AllowAssumptions allowAssumptions) {
            this.options = options;
            this.debug = debug;
            this.assumptions = allowAssumptions == AllowAssumptions.YES ? new Assumptions() : null;
            this.trackNodeSourcePosition = Graph.trackNodeSourcePositionDefault(options, debug);
        }

        public Builder(OptionValues options, DebugContext debug) {
            this.options = options;
            this.debug = debug;
            this.assumptions = null;
            this.trackNodeSourcePosition = Graph.trackNodeSourcePositionDefault(options, debug);
        }

        public String getName() {
            return this.name;
        }

        public Builder name(String s) {
            this.name = s;
            return this;
        }

        public Builder setIsSubstitution(boolean flag) {
            this.isSubstitution = flag;
            return this;
        }

        public ResolvedJavaMethod getMethod() {
            return this.rootMethod;
        }

        public Builder method(ResolvedJavaMethod method) {
            this.rootMethod = method;
            return this;
        }

        public DebugContext getDebug() {
            return this.debug;
        }

        public SpeculationLog getSpeculationLog() {
            return this.speculationLog;
        }

        public Builder speculationLog(SpeculationLog log) {
            this.speculationLog = log;
            return this;
        }

        public CompilationIdentifier getCompilationId() {
            return this.compilationId;
        }

        public Builder compilationId(CompilationIdentifier id) {
            this.compilationId = id;
            return this;
        }

        public Cancellable getCancellable() {
            return this.cancellable;
        }

        public Builder cancellable(Cancellable cancel) {
            this.cancellable = cancel;
            return this;
        }

        public int getEntryBCI() {
            return this.entryBCI;
        }

        public Builder entryBCI(int bci) {
            this.entryBCI = bci;
            return this;
        }

        public boolean getUseProfilingInfo() {
            return this.useProfilingInfo;
        }

        public Builder useProfilingInfo(boolean flag) {
            this.useProfilingInfo = flag;
            return this;
        }

        public boolean getRecordInlinedMethods() {
            return this.recordInlinedMethods;
        }

        public Builder recordInlinedMethods(boolean flag) {
            this.recordInlinedMethods = flag;
            return this;
        }

        public Builder trackNodeSourcePosition(boolean flag) {
            if (flag) {
                this.trackNodeSourcePosition = true;
            }
            return this;
        }

        public Builder callerContext(NodeSourcePosition context) {
            this.callerContext = context;
            return this;
        }

        public StructuredGraph build() {
            ArrayList inlinedMethods = this.recordInlinedMethods ? new ArrayList() : null;
            return new StructuredGraph(this.name, this.rootMethod, this.entryBCI, this.assumptions, this.speculationLog, this.useProfilingInfo, this.isSubstitution, inlinedMethods, this.trackNodeSourcePosition, this.compilationId, this.options, this.debug, this.cancellable, this.callerContext);
        }
    }

    public static class ScheduleResult {
        private final ControlFlowGraph cfg;
        private final NodeMap<Block> nodeToBlockMap;
        private final BlockMap<List<Node>> blockToNodesMap;

        public ScheduleResult(ControlFlowGraph cfg, NodeMap<Block> nodeToBlockMap, BlockMap<List<Node>> blockToNodesMap) {
            this.cfg = cfg;
            this.nodeToBlockMap = nodeToBlockMap;
            this.blockToNodesMap = blockToNodesMap;
        }

        public ControlFlowGraph getCFG() {
            return this.cfg;
        }

        public NodeMap<Block> getNodeToBlockMap() {
            return this.nodeToBlockMap;
        }

        public BlockMap<List<Node>> getBlockToNodesMap() {
            return this.blockToNodesMap;
        }

        public List<Node> nodesFor(Block block) {
            return this.blockToNodesMap.get(block);
        }
    }

    public static enum AllowAssumptions {
        YES,
        NO;


        public static AllowAssumptions ifTrue(boolean flag) {
            return flag ? YES : NO;
        }

        public static AllowAssumptions ifNonNull(Assumptions assumptions) {
            return assumptions != null ? YES : NO;
        }
    }

    public static enum GuardsStage {
        FLOATING_GUARDS,
        FIXED_DEOPTS,
        AFTER_FSA;


        public boolean allowsFloatingGuards() {
            return this == FLOATING_GUARDS;
        }

        public boolean allowsGuardInsertion() {
            return this.ordinal() <= FIXED_DEOPTS.ordinal();
        }

        public boolean areFrameStatesAtDeopts() {
            return this == AFTER_FSA;
        }

        public boolean areFrameStatesAtSideEffects() {
            return !this.areFrameStatesAtDeopts();
        }

        public boolean areDeoptsFixed() {
            return this.ordinal() >= FIXED_DEOPTS.ordinal();
        }
    }
}

