/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class LogicNegationNode
extends LogicNode
implements Canonicalizable.Unary<LogicNode> {
    public static final NodeClass<LogicNegationNode> TYPE = NodeClass.create(LogicNegationNode.class);
    @Node.Input(value=InputType.Condition)
    LogicNode value;

    public LogicNegationNode(LogicNode value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    public static LogicNode create(LogicNode value) {
        LogicNode synonym = LogicNegationNode.findSynonym(value);
        if (synonym != null) {
            return synonym;
        }
        return new LogicNegationNode(value);
    }

    private static LogicNode findSynonym(LogicNode value) {
        if (value instanceof LogicConstantNode) {
            LogicConstantNode logicConstantNode = (LogicConstantNode)value;
            return LogicConstantNode.forBoolean(!logicConstantNode.getValue());
        }
        if (value instanceof LogicNegationNode) {
            return ((LogicNegationNode)value).getValue();
        }
        return null;
    }

    @Override
    public LogicNode getValue() {
        return this.value;
    }

    public LogicNode canonical(CanonicalizerTool tool, LogicNode forValue) {
        LogicNode synonym = LogicNegationNode.findSynonym(forValue);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (other == this.getValue()) {
            return TriState.get((boolean)thisNegated);
        }
        return this.getValue().implies(!thisNegated, other);
    }
}

