/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.StructuredGraph;

public interface Invokable {
    public ResolvedJavaMethod getTargetMethod();

    public int bci();

    default public boolean isAlive() {
        return this.asFixedNode().isAlive();
    }

    public FixedNode asFixedNode();

    default public void updateInliningLogAfterRegister(StructuredGraph newGraph) {
        InliningLog log = newGraph.getInliningLog();
        if (log.getUpdateScope() != null) {
            log.getUpdateScope().accept(null, this);
        } else {
            if (!1.$assertionsDisabled && log.containsLeafCallsite(this)) {
                throw new AssertionError();
            }
            log.trackNewCallsite(this);
        }
    }

    default public void updateInliningLogAfterClone(Node other) {
        if (GraalOptions.TraceInlining.getValue(this.asFixedNode().getOptions()).booleanValue()) {
            InliningLog log = this.asFixedNode().graph().getInliningLog();
            if (!1.$assertionsDisabled && !(other instanceof Invokable)) {
                throw new AssertionError();
            }
            if (log.getUpdateScope() != null) {
                log.getUpdateScope().accept((Invokable)((Object)other), this);
            } else if (other.graph() == this.asFixedNode().graph()) {
                if (!1.$assertionsDisabled && !log.containsLeafCallsite(this)) {
                    throw new AssertionError((Object)("Node " + this + " not contained in the log."));
                }
                if (!1.$assertionsDisabled && !log.containsLeafCallsite((Invokable)((Object)other))) {
                    throw new AssertionError((Object)("Sibling " + other + " not contained in the log."));
                }
                log.removeLeafCallsite(this);
                log.trackDuplicatedCallsite((Invokable)((Object)other), this);
            } else {
                throw GraalError.shouldNotReachHere("No InliningLog.Update scope provided.");
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

