/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.loop.DerivedInductionVariable;
import org.graalvm.compiler.loop.InductionVariable;
import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.loop.MathUtil;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.SubNode;

public class DerivedOffsetInductionVariable
extends DerivedInductionVariable {
    private final ValueNode offset;
    private final BinaryArithmeticNode<?> value;

    public DerivedOffsetInductionVariable(LoopEx loop, InductionVariable base, ValueNode offset, BinaryArithmeticNode<?> value) {
        super(loop, base);
        this.offset = offset;
        this.value = value;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    @Override
    public InductionVariable.Direction direction() {
        return this.base.direction();
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public boolean isConstantInit() {
        return this.offset.isConstant() && this.base.isConstantInit();
    }

    @Override
    public boolean isConstantStride() {
        return this.base.isConstantStride();
    }

    @Override
    public long constantInit() {
        return this.op(this.base.constantInit(), this.offset.asJavaConstant().asLong());
    }

    @Override
    public long constantStride() {
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return -this.base.constantStride();
        }
        return this.base.constantStride();
    }

    @Override
    public ValueNode initNode() {
        return this.op(this.base.initNode(), this.offset);
    }

    @Override
    public ValueNode strideNode() {
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return this.graph().addOrUniqueWithInputs(NegateNode.create(this.base.strideNode(), NodeView.DEFAULT));
        }
        return this.base.strideNode();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp stamp) {
        return this.op(this.base.extremumNode(assumeLoopEntered, stamp), IntegerConvertNode.convert(this.offset, stamp, this.graph(), NodeView.DEFAULT));
    }

    @Override
    public ValueNode exitValueNode() {
        return this.op(this.base.exitValueNode(), this.offset);
    }

    @Override
    public boolean isConstantExtremum() {
        return this.offset.isConstant() && this.base.isConstantExtremum();
    }

    @Override
    public long constantExtremum() {
        return this.op(this.base.constantExtremum(), this.offset.asJavaConstant().asLong());
    }

    private long op(long b, long o) {
        if (this.value instanceof AddNode) {
            return b + o;
        }
        if (this.value instanceof SubNode) {
            if (this.base.valueNode() == this.value.getX()) {
                return b - o;
            }
            assert (this.base.valueNode() == this.value.getY());
            return o - b;
        }
        throw GraalError.shouldNotReachHere();
    }

    private ValueNode op(ValueNode b, ValueNode o) {
        if (this.value instanceof AddNode) {
            return MathUtil.add(this.graph(), b, o);
        }
        if (this.value instanceof SubNode) {
            if (this.base.valueNode() == this.value.getX()) {
                return MathUtil.sub(this.graph(), b, o);
            }
            assert (this.base.valueNode() == this.value.getY());
            return MathUtil.sub(this.graph(), o, b);
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public void deleteUnusedNodes() {
    }

    public String toString() {
        return String.format("DerivedOffsetInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.offset);
    }
}

