/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import java.util.Set;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;

public class SPARCMove {
    private static void loadEffectiveAddress(CompilationResultBuilder crb, SPARCMacroAssembler masm, SPARCAddress address, Register result, SPARCDelayedControlTransfer delaySlotHolder) {
        if (address.getIndex().equals((Object)Register.None)) {
            if (SPARCAssembler.isSimm13(address.getDisplacement())) {
                delaySlotHolder.emitControlTransfer(crb, masm);
                masm.add(address.getBase(), address.getDisplacement(), result);
            } else {
                assert (result.encoding() != address.getBase().encoding());
                masm.setx(address.getDisplacement(), result, false);
                delaySlotHolder.emitControlTransfer(crb, masm);
                masm.add(address.getBase(), result, result);
            }
        } else {
            delaySlotHolder.emitControlTransfer(crb, masm);
            masm.add(address.getBase(), address.getIndex(), result);
        }
    }

    public static void move(CompilationResultBuilder crb, SPARCMacroAssembler masm, Value result, Value input, SPARCDelayedControlTransfer delaySlotLir) {
        SPARCMove.move(crb, masm, result, SPARC.g0, input, delaySlotLir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void move(CompilationResultBuilder crb, SPARCMacroAssembler masm, Value result, Register constantTableBase, Value input, SPARCDelayedControlTransfer delaySlotLir) {
        if (ValueUtil.isRegister((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                SPARCMove.reg2reg(crb, masm, result, input, delaySlotLir);
                return;
            } else {
                if (!ValueUtil.isStackSlot((Value)result)) throw GraalError.shouldNotReachHere("Result is a: " + result);
                SPARCMove.reg2stack(crb, masm, result, input, delaySlotLir);
            }
            return;
        } else if (ValueUtil.isStackSlot((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                SPARCAddress inputAddress = (SPARCAddress)crb.asAddress(input);
                SPARCMove.emitLoad(crb, masm, inputAddress, result, false, input.getPlatformKind(), delaySlotLir, null);
                return;
            } else {
                if (!ValueUtil.isStackSlot((Value)result)) throw GraalError.shouldNotReachHere("Result is a: " + result);
                SPARCMove.stack2stack(crb, masm, result, input, delaySlotLir);
            }
            return;
        } else {
            if (!LIRValueUtil.isJavaConstant(input)) throw GraalError.shouldNotReachHere();
            JavaConstant constant = LIRValueUtil.asJavaConstant(input);
            if (ValueUtil.isRegister((Value)result)) {
                SPARCMove.const2reg(crb, masm, result, constantTableBase, constant, delaySlotLir);
                return;
            } else {
                if (!ValueUtil.isStackSlot((Value)result)) throw GraalError.shouldNotReachHere("Result is a: " + result);
                SPARCMove.const2stack(crb, masm, result, constantTableBase, delaySlotLir, constant);
            }
        }
    }

    public static void const2stack(CompilationResultBuilder crb, SPARCMacroAssembler masm, Value result, Register constantTableBase, SPARCDelayedControlTransfer delaySlotLir, JavaConstant constant) {
        if (constant.isDefaultForKind() || constant.isNull()) {
            SPARCAddress resultAddress = (SPARCAddress)crb.asAddress(result);
            SPARCMove.emitStore((Value)SPARC.g0.asValue((ValueKind)LIRKind.combine(result)), resultAddress, result.getPlatformKind(), delaySlotLir, null, crb, masm);
        } else {
            try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                RegisterValue scratchRegisterValue = sc.getRegister().asValue((ValueKind)LIRKind.combine(result));
                SPARCMove.const2reg(crb, masm, (Value)scratchRegisterValue, constantTableBase, constant, SPARCDelayedControlTransfer.DUMMY);
                SPARCAddress resultAddress = (SPARCAddress)crb.asAddress(result);
                SPARCMove.emitStore((Value)scratchRegisterValue, resultAddress, result.getPlatformKind(), delaySlotLir, null, crb, masm);
            }
        }
    }

    public static void stack2stack(CompilationResultBuilder crb, SPARCMacroAssembler masm, PlatformKind resultKind, PlatformKind inputKind, Value result, Value input, SPARCDelayedControlTransfer delaySlotLir) {
        try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            SPARCAddress inputAddress = (SPARCAddress)crb.asAddress(input);
            RegisterValue scratchRegisterValue = sc.getRegister().asValue((ValueKind)LIRKind.combine(input));
            SPARCMove.emitLoad(crb, masm, inputAddress, (Value)scratchRegisterValue, false, inputKind, SPARCDelayedControlTransfer.DUMMY, null);
            SPARCAddress resultAddress = (SPARCAddress)crb.asAddress(result);
            SPARCMove.emitStore((Value)scratchRegisterValue, resultAddress, resultKind, delaySlotLir, null, crb, masm);
        }
    }

    public static void stack2stack(CompilationResultBuilder crb, SPARCMacroAssembler masm, Value result, Value input, SPARCDelayedControlTransfer delaySlotLir) {
        SPARCMove.stack2stack(crb, masm, result.getPlatformKind(), input.getPlatformKind(), result, input, delaySlotLir);
    }

    public static void reg2stack(CompilationResultBuilder crb, SPARCMacroAssembler masm, Value result, Value input, SPARCDelayedControlTransfer delaySlotLir) {
        SPARCAddress resultAddress = (SPARCAddress)crb.asAddress(result);
        SPARCMove.emitStore(input, resultAddress, result.getPlatformKind(), delaySlotLir, null, crb, masm);
    }

    public static void reg2reg(CompilationResultBuilder crb, SPARCMacroAssembler masm, Value result, Value input, SPARCDelayedControlTransfer delaySlotLir) {
        Register dst;
        Register src = ValueUtil.asRegister((Value)input);
        if (src.equals((Object)(dst = ValueUtil.asRegister((Value)result)))) {
            return;
        }
        delaySlotLir.emitControlTransfer(crb, masm);
        if (SPARCAssembler.isCPURegister(src) && SPARCAssembler.isCPURegister(dst)) {
            masm.mov(src, dst);
        } else if (SPARCAssembler.isSingleFloatRegister(src) && SPARCAssembler.isSingleFloatRegister(dst)) {
            masm.fsrc2s(src, dst);
        } else if (SPARCAssembler.isDoubleFloatRegister(src) && SPARCAssembler.isDoubleFloatRegister(dst)) {
            masm.fsrc2d(src, dst);
        } else {
            throw GraalError.shouldNotReachHere(String.format("Trying to move between register domains src: %s dst: %s", src, dst));
        }
    }

    public static SPARCAddress generateSimm13OffsetLoad(SPARCAddress addr, SPARCMacroAssembler masm, Register scratch) {
        boolean displacementOutOfBound;
        boolean bl = displacementOutOfBound = addr.getIndex().equals((Object)Register.None) && !SPARCAssembler.isSimm13(addr.getDisplacement());
        if (displacementOutOfBound) {
            masm.setx(addr.getDisplacement(), scratch, false);
            return new SPARCAddress(addr.getBase(), scratch);
        }
        return addr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void const2reg(CompilationResultBuilder crb, SPARCMacroAssembler masm, Value result, Register constantTableBase, JavaConstant input, SPARCDelayedControlTransfer delaySlotLir) {
        try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            Set cpuFeatures = ((SPARC)masm.target.arch).getFeatures();
            boolean hasVIS1 = cpuFeatures.contains(SPARC.CPUFeature.VIS1);
            boolean hasVIS3 = cpuFeatures.contains(SPARC.CPUFeature.VIS3);
            Register resultRegister = ValueUtil.asRegister((Value)result);
            switch (input.getJavaKind().getStackKind()) {
                case Int: {
                    if (input.isDefaultForKind()) {
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.clr(resultRegister);
                        return;
                    } else if (SPARCAssembler.isSimm13(input.asInt())) {
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.or(SPARC.g0, input.asInt(), resultRegister);
                        return;
                    } else {
                        if (constantTableBase.equals((Object)SPARC.g0)) {
                            throw GraalError.shouldNotReachHere();
                        }
                        SPARCMove.loadFromConstantTable(crb, masm, constantTableBase, (Constant)input, resultRegister, delaySlotLir);
                        return;
                    }
                }
                case Long: {
                    if (input.isDefaultForKind()) {
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.clr(resultRegister);
                        return;
                    } else if (SPARCAssembler.isSimm13(input.asLong())) {
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.or(SPARC.g0, (int)input.asLong(), resultRegister);
                        return;
                    } else {
                        SPARCMove.loadFromConstantTable(crb, masm, constantTableBase, (Constant)input, resultRegister, delaySlotLir);
                        return;
                    }
                }
                case Float: {
                    float constant = input.asFloat();
                    int constantBits = Float.floatToIntBits(constant);
                    if (hasVIS1 && constantBits == 0) {
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.fzeros(resultRegister);
                        return;
                    } else if (hasVIS3 && SPARCAssembler.isSimm13(constantBits)) {
                        masm.or(SPARC.g0, constantBits, scratch);
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.movwtos(scratch, resultRegister);
                        return;
                    } else {
                        SPARCMove.loadFromConstantTable(crb, masm, constantTableBase, (Constant)input, resultRegister, delaySlotLir);
                        return;
                    }
                }
                case Double: {
                    double constant = input.asDouble();
                    long constantBits = Double.doubleToRawLongBits(constant);
                    if (hasVIS1 && constantBits == 0L) {
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.fzerod(resultRegister);
                        return;
                    } else if (hasVIS3 && SPARCAssembler.isSimm13(constantBits)) {
                        masm.or(SPARC.g0, (int)constantBits, scratch);
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.movxtod(scratch, resultRegister);
                        return;
                    } else {
                        SPARCMove.loadFromConstantTable(crb, masm, constantTableBase, (Constant)input, resultRegister, delaySlotLir);
                        return;
                    }
                }
                case Object: {
                    if (input.isNull()) {
                        delaySlotLir.emitControlTransfer(crb, masm);
                        masm.clr(resultRegister);
                        return;
                    } else {
                        SPARCMove.loadFromConstantTable(crb, masm, constantTableBase, (Constant)input, resultRegister, delaySlotLir);
                        return;
                    }
                }
                default: {
                    throw GraalError.shouldNotReachHere("missing: " + input.getJavaKind());
                }
            }
        }
    }

    protected static void compareAndSwap(CompilationResultBuilder crb, SPARCMacroAssembler masm, AllocatableValue address, AllocatableValue cmpValue, AllocatableValue newValue, SPARCDelayedControlTransfer delay) {
        delay.emitControlTransfer(crb, masm);
        switch ((SPARCKind)cmpValue.getPlatformKind()) {
            case WORD: {
                masm.cas(ValueUtil.asRegister((Value)address), ValueUtil.asRegister((Value)cmpValue), ValueUtil.asRegister((Value)newValue));
                break;
            }
            case XWORD: {
                masm.casx(ValueUtil.asRegister((Value)address), ValueUtil.asRegister((Value)cmpValue), ValueUtil.asRegister((Value)newValue));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public static void emitLoad(CompilationResultBuilder crb, SPARCMacroAssembler masm, SPARCAddress address, Value result, boolean signExtend, PlatformKind kind, SPARCDelayedControlTransfer delayedControlTransfer, LIRFrameState state) {
        try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            SPARCAddress addr = SPARCMove.generateSimm13OffsetLoad(address, masm, scratch);
            Register dst = ValueUtil.asRegister((Value)result);
            delayedControlTransfer.emitControlTransfer(crb, masm);
            if (state != null) {
                crb.recordImplicitException(masm.position(), state);
            }
            int byteCount = kind.getSizeInBytes();
            masm.ld(addr, dst, byteCount, signExtend);
        }
    }

    public static void emitStore(Value input, SPARCAddress address, PlatformKind kind, SPARCDelayedControlTransfer delayedControlTransfer, LIRFrameState state, CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            SPARCAddress addr = SPARCMove.generateSimm13OffsetLoad(address, masm, scratch);
            delayedControlTransfer.emitControlTransfer(crb, masm);
            if (state != null) {
                crb.recordImplicitException(masm.position(), state);
            }
            int byteCount = kind.getSizeInBytes();
            masm.st(ValueUtil.asRegister((Value)input), addr, byteCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadFromConstantTable(CompilationResultBuilder crb, SPARCMacroAssembler masm, Register constantTableBase, Constant input, Register dest, SPARCDelayedControlTransfer delaySlotInstruction) {
        try (SPARCMacroAssembler.ScratchRegister scratch = null;){
            SPARCAddress address;
            DataSection.Data data = crb.createDataItem(input);
            int size = data.getSize();
            if (masm.isImmediateConstantLoad()) {
                address = new SPARCAddress(constantTableBase, 0);
                delaySlotInstruction.emitControlTransfer(crb, masm);
                crb.recordDataReferenceInCode(data, size);
            } else {
                scratch = masm.getScratchRegister();
                Register sr = scratch.getRegister();
                crb.recordDataReferenceInCode(data, size);
                masm.sethix(0L, sr, true);
                address = new SPARCAddress(sr, 0);
            }
            masm.ld(address, dest, size, false);
            int n = size;
            return n;
        }
    }

    public static final class StoreConstantOp
    extends MemOp
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<StoreConstantOp> TYPE = LIRInstructionClass.create(StoreConstantOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
        protected final JavaConstant input;

        public StoreConstantOp(PlatformKind kind, SPARCAddressValue address, JavaConstant input, LIRFrameState state) {
            super(TYPE, SIZE, kind, address, state);
            this.input = input;
            if (!input.isDefaultForKind()) {
                throw GraalError.shouldNotReachHere("Can only store null constants to memory");
            }
        }

        @Override
        public void emitMemAccess(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                SPARCAddress addr = SPARCMove.generateSimm13OffsetLoad(this.address.toAddress(), masm, scratch);
                this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
                if (this.state != null) {
                    crb.recordImplicitException(masm.position(), this.state);
                }
                int byteCount = this.kind.getSizeInBytes();
                masm.st(SPARC.g0, addr, byteCount);
            }
        }
    }

    public static class StoreOp
    extends MemOp
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<StoreOp> TYPE = LIRInstructionClass.create(StoreOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public StoreOp(PlatformKind kind, SPARCAddressValue address, AllocatableValue input, LIRFrameState state) {
            super(TYPE, SIZE, kind, address, state);
            this.input = input;
        }

        @Override
        public void emitMemAccess(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCMove.emitStore((Value)this.input, this.address.toAddress(), this.kind, this.getDelayedControlTransfer(), this.state, crb, masm);
        }
    }

    public static final class StackLoadAddressOp
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<StackLoadAddressOp> TYPE = LIRInstructionClass.create(StackLoadAddressOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        protected AllocatableValue slot;

        public StackLoadAddressOp(AllocatableValue result, AllocatableValue slot) {
            super(TYPE, SIZE);
            this.result = result;
            this.slot = slot;
            assert (slot instanceof VirtualStackSlot || slot instanceof StackSlot);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCAddress address = (SPARCAddress)crb.asAddress((Value)this.slot);
            SPARCMove.loadEffectiveAddress(crb, masm, address, ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD), this.getDelayedControlTransfer());
        }
    }

    @Opcode(value="CAS")
    public static final class CompareAndSwapOp
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<CompareAndSwapOp> TYPE = LIRInstructionClass.create(CompareAndSwapOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue address;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue cmpValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue newValue;

        public CompareAndSwapOp(AllocatableValue result, AllocatableValue address, AllocatableValue cmpValue, AllocatableValue newValue) {
            super(TYPE, SIZE);
            this.result = result;
            this.address = address;
            this.cmpValue = cmpValue;
            this.newValue = newValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCMove.move(crb, masm, (Value)this.result, (Value)this.newValue, SPARCDelayedControlTransfer.DUMMY);
            SPARCMove.compareAndSwap(crb, masm, this.address, this.cmpValue, this.result, this.getDelayedControlTransfer());
        }
    }

    public static final class NullCheckOp
    extends SPARCLIRInstruction
    implements StandardOp.NullCheck,
    SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<NullCheckOp> TYPE = LIRInstructionClass.create(NullCheckOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected SPARCAddressValue input;
        @LIRInstruction.State
        protected LIRFrameState state;

        public NullCheckOp(SPARCAddressValue input, LIRFrameState state) {
            super(TYPE, SIZE);
            this.input = input;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
            SPARCAddress addr = this.input.toAddress();
            crb.recordImplicitException(masm.position(), this.state);
            masm.ldub(addr, SPARC.g0);
        }

        @Override
        public Value getCheckedValue() {
            return this.input;
        }

        @Override
        public LIRFrameState getState() {
            return this.state;
        }
    }

    public static final class MembarOp
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<MembarOp> TYPE = LIRInstructionClass.create(MembarOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
        private final int barriers;

        public MembarOp(int barriers) {
            super(TYPE, SIZE);
            this.barriers = barriers;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
            masm.membar(2);
        }

        @Override
        public void verify() {
            assert (this.barriers == 4) : String.format("Got barriers 0x%x; On SPARC only STORE_LOAD barriers are accepted; all other barriers are not neccessary due to TSO", this.barriers);
        }
    }

    public static final class LoadDataAddressOp
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<LoadDataAddressOp> TYPE = LIRInstructionClass.create(LoadDataAddressOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        private final DataPointerConstant data;

        public LoadDataAddressOp(AllocatableValue result, DataPointerConstant data) {
            super(TYPE);
            this.result = result;
            this.data = data;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCAddress addr = (SPARCAddress)crb.recordDataReferenceInCode((Constant)this.data, Math.max(SPARCKind.WORD.getSizeInBytes(), this.data.getAlignment()));
            assert (addr == masm.getPlaceholder(-1));
            boolean forceRelocatable = true;
            Register dstReg = ValueUtil.asRegister((Value)this.result);
            masm.setx(0L, dstReg, true);
        }

        @Override
        public SPARCLIRInstructionMixin.SizeEstimate estimateSize() {
            return SPARCLIRInstructionMixin.SizeEstimate.create(8, this.data.getSerializedSize());
        }
    }

    public static final class LoadAddressOp
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<LoadAddressOp> TYPE = LIRInstructionClass.create(LoadAddressOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(8);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE, LIRInstruction.OperandFlag.UNINITIALIZED})
        protected SPARCAddressValue addressValue;

        public LoadAddressOp(AllocatableValue result, SPARCAddressValue address) {
            super(TYPE, SIZE);
            this.result = result;
            this.addressValue = address;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCAddress address = this.addressValue.toAddress();
            SPARCMove.loadEffectiveAddress(crb, masm, address, ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD), this.getDelayedControlTransfer());
        }
    }

    public static final class LoadOp
    extends MemOp
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<LoadOp> TYPE = LIRInstructionClass.create(LoadOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        protected boolean signExtend;

        public LoadOp(PlatformKind kind, AllocatableValue result, SPARCAddressValue address, LIRFrameState state) {
            this(kind, result, address, state, false);
        }

        public LoadOp(PlatformKind kind, AllocatableValue result, SPARCAddressValue address, LIRFrameState state, boolean signExtend) {
            super(TYPE, SIZE, kind, address, state);
            this.result = result;
            this.signExtend = signExtend;
        }

        @Override
        public void emitMemAccess(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCMove.emitLoad(crb, masm, this.address.toAddress(), (Value)this.result, this.signExtend, this.kind, this.getDelayedControlTransfer(), this.state);
        }
    }

    public static abstract class MemOp
    extends SPARCLIRInstruction
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<MemOp> TYPE = LIRInstructionClass.create(MemOp.class);
        protected final PlatformKind kind;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected SPARCAddressValue address;
        @LIRInstruction.State
        protected LIRFrameState state;

        public MemOp(LIRInstructionClass<? extends MemOp> c, SPARCLIRInstructionMixin.SizeEstimate size, PlatformKind kind, SPARCAddressValue address, LIRFrameState state) {
            super(c, size);
            this.kind = kind;
            this.address = address;
            this.state = state;
        }

        protected abstract void emitMemAccess(CompilationResultBuilder var1, SPARCMacroAssembler var2);

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            this.emitMemAccess(crb, masm);
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.address.isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    @Opcode(value="MOVE_FPGP")
    public static final class MoveFpGp
    extends SPARCLIRInstruction
    implements StandardOp.ValueMoveOp,
    SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<MoveFpGp> TYPE = LIRInstructionClass.create(MoveFpGp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue temp;

        public MoveFpGp(AllocatableValue result, AllocatableValue input, AllocatableValue temp) {
            super(TYPE, SIZE);
            this.result = result;
            this.input = input;
            this.temp = temp;
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCKind inputKind = (SPARCKind)this.input.getPlatformKind();
            SPARCKind resultKind = (SPARCKind)this.result.getPlatformKind();
            if (AllocatableValue.ILLEGAL.equals((Object)this.temp)) {
                this.moveDirect(crb, masm, inputKind, resultKind);
            } else {
                this.moveViaStack(crb, masm, inputKind, resultKind);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void moveDirect(CompilationResultBuilder crb, SPARCMacroAssembler masm, SPARCKind inputKind, SPARCKind resultKind) {
            this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
            if (resultKind == SPARCKind.SINGLE) {
                if (inputKind != SPARCKind.WORD) throw GraalError.shouldNotReachHere("inputKind: " + inputKind);
                masm.movwtos(ValueUtil.asRegister((Value)this.input, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE));
                return;
            } else if (resultKind == SPARCKind.DOUBLE) {
                if (inputKind == SPARCKind.WORD) {
                    masm.movxtod(ValueUtil.asRegister((Value)this.input, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE));
                    return;
                } else {
                    masm.movxtod(ValueUtil.asRegister((Value)this.input, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE));
                }
                return;
            } else if (inputKind == SPARCKind.SINGLE) {
                if (resultKind == SPARCKind.WORD) {
                    masm.movstosw(ValueUtil.asRegister((Value)this.input, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD));
                    return;
                } else {
                    masm.movstouw(ValueUtil.asRegister((Value)this.input, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD));
                }
                return;
            } else {
                if (inputKind != SPARCKind.DOUBLE) return;
                if (resultKind != SPARCKind.XWORD) throw GraalError.shouldNotReachHere();
                masm.movdtox(ValueUtil.asRegister((Value)this.input, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD));
            }
        }

        private void moveViaStack(CompilationResultBuilder crb, SPARCMacroAssembler masm, SPARCKind inputKind, SPARCKind resultKind) {
            int resultKindSize = resultKind.getSizeInBytes();
            assert (inputKind.getSizeInBytes() == resultKindSize);
            try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                SPARCAddress tempAddress = SPARCMove.generateSimm13OffsetLoad((SPARCAddress)crb.asAddress((Value)this.temp), masm, scratch);
                masm.st(ValueUtil.asRegister((Value)this.input), tempAddress, resultKindSize);
                this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
                masm.ld(tempAddress, ValueUtil.asRegister((Value)this.result), resultKindSize, false);
            }
        }
    }

    @Opcode(value="MOVE")
    public static class Move
    extends SPARCLIRInstruction
    implements StandardOp.ValueMoveOp,
    SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<Move> TYPE = LIRInstructionClass.create(Move.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(8);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public Move(AllocatableValue result, AllocatableValue input) {
            super(TYPE, SIZE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCMove.move(crb, masm, (Value)this.getResult(), (Value)this.getInput(), this.getDelayedControlTransfer());
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    public static class LoadConstantFromTable
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<LoadConstantFromTable> TYPE = LIRInstructionClass.create(LoadConstantFromTable.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1, 8);
        private JavaConstant constant;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private AllocatableValue constantTableBase;

        public LoadConstantFromTable(JavaConstant constant, AllocatableValue constantTableBase, AllocatableValue result) {
            super(TYPE, SIZE);
            this.constant = constant;
            this.result = result;
            this.constantTableBase = constantTableBase;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            int byteCount = this.result.getPlatformKind().getSizeInBytes();
            assert (byteCount > 1) : "Byte values must not be loaded via constant table";
            Register baseRegister = ValueUtil.asRegister((Value)this.constantTableBase);
            if (ValueUtil.isRegister((Value)this.result)) {
                Register resultRegister = ValueUtil.asRegister((Value)this.result);
                SPARCMove.loadFromConstantTable(crb, masm, baseRegister, (Constant)this.constant, resultRegister, this.getDelayedControlTransfer());
            } else if (ValueUtil.isStackSlot((Value)this.result)) {
                try (SPARCMacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                    Register scratchRegister = scratch.getRegister();
                    SPARCMove.loadFromConstantTable(crb, masm, baseRegister, (Constant)this.constant, scratchRegister, this.getDelayedControlTransfer());
                    StackSlot slot = ValueUtil.asStackSlot((Value)this.result);
                    SPARCMove.reg2stack(crb, masm, (Value)slot, (Value)scratchRegister.asValue(), this.getDelayedControlTransfer());
                }
            }
        }
    }

    public static class LoadInlineConstant
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction,
    StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadInlineConstant> TYPE = LIRInstructionClass.create(LoadInlineConstant.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
        private JavaConstant constant;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;

        public LoadInlineConstant(JavaConstant constant, AllocatableValue result) {
            super(TYPE, SIZE);
            this.constant = constant;
            this.result = result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                SPARCMove.const2reg(crb, masm, (Value)this.result, SPARC.g0, this.constant, this.getDelayedControlTransfer());
            } else if (ValueUtil.isStackSlot((Value)this.result)) {
                StackSlot slot = ValueUtil.asStackSlot((Value)this.result);
                SPARCMove.const2stack(crb, masm, (Value)slot, SPARC.g0, this.getDelayedControlTransfer(), this.constant);
            }
        }

        @Override
        public Constant getConstant() {
            return this.constant;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }
}

