/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;

public class SPARCArithmetic {

    public static final class MulHighOp
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<MulHighOp> TYPE = LIRInstructionClass.create(MulHighOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(4);
        @Opcode
        private final MulHigh opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        public AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        public AllocatableValue x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        public AllocatableValue y;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        public AllocatableValue scratch;

        public MulHighOp(MulHigh opcode, AllocatableValue x, AllocatableValue y, AllocatableValue result, AllocatableValue scratch) {
            super(TYPE, SIZE);
            this.opcode = opcode;
            this.x = x;
            this.y = y;
            this.scratch = scratch;
            this.result = result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            assert (ValueUtil.isRegister((Value)this.x) && ValueUtil.isRegister((Value)this.y) && ValueUtil.isRegister((Value)this.result) && ValueUtil.isRegister((Value)this.scratch));
            switch (this.opcode) {
                case IMUL: {
                    masm.sra(ValueUtil.asRegister((Value)this.x), 0, ValueUtil.asRegister((Value)this.x));
                    masm.sra(ValueUtil.asRegister((Value)this.y), 0, ValueUtil.asRegister((Value)this.y));
                    masm.mulx(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD));
                    masm.srax(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD), 32, ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD));
                    break;
                }
                case LMUL: {
                    assert (!ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD).equals((Object)ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD)));
                    masm.umulxhi(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD));
                    masm.srlx(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), 63, ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD));
                    masm.mulx(ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD));
                    masm.sub(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD));
                    masm.srlx(ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), 63, ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD));
                    masm.mulx(ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD));
                    masm.sub(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }

        public static enum MulHigh {
            IMUL,
            LMUL;

        }
    }

    public static final class SPARCLMulccOp
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<SPARCLMulccOp> TYPE = LIRInstructionClass.create(SPARCLMulccOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(13);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue scratch1;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue scratch2;

        public SPARCLMulccOp(AllocatableValue result, AllocatableValue x, AllocatableValue y, LIRGeneratorTool gen) {
            super(TYPE, SIZE);
            this.result = result;
            this.x = x;
            this.y = y;
            this.scratch1 = gen.newVariable(LIRKind.combine(new Value[]{x, y}));
            this.scratch2 = gen.newVariable(LIRKind.combine(new Value[]{x, y}));
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            Label noOverflow = new Label();
            masm.mulx(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD));
            masm.umulxhi(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD));
            masm.srax(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), 63, ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD));
            masm.and(ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD));
            masm.sub(ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD));
            masm.srax(ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), 63, ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD));
            masm.and(ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD));
            masm.sub(ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD));
            masm.srax(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD), 63, ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD));
            masm.cmp(ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD));
            SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.Equal, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, noOverflow);
            masm.nop();
            masm.wrccr(SPARC.g0, 32);
            masm.bind(noOverflow);
        }
    }

    public static final class SPARCIMulccOp
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<SPARCIMulccOp> TYPE = LIRInstructionClass.create(SPARCIMulccOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(10);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;

        public SPARCIMulccOp(AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super(TYPE, SIZE);
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            try (SPARCMacroAssembler.ScratchRegister tmpScratch = masm.getScratchRegister();){
                Register tmp = tmpScratch.getRegister();
                Register resultRegister = ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD);
                Register xRegister = ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.WORD);
                Register yRegister = ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.WORD);
                masm.sra(xRegister, 0, xRegister);
                masm.sra(yRegister, 0, yRegister);
                masm.mulx(xRegister, yRegister, resultRegister);
                Label noOverflow = new Label();
                masm.sra(resultRegister, 0, tmp);
                masm.compareBranch(tmp, resultRegister, SPARCAssembler.ConditionFlag.Equal, SPARCAssembler.CC.Xcc, noOverflow, SPARCAssembler.BranchPredict.PREDICT_TAKEN, null);
                masm.wrccr(SPARC.g0, 2);
                masm.bind(noOverflow);
            }
        }
    }

    public static final class RemOp
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<RemOp> TYPE = LIRInstructionClass.create(RemOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(4);
        @Opcode
        private final Rem opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value y;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue scratch1;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue scratch2;
        @LIRInstruction.State
        protected LIRFrameState state;

        public RemOp(Rem opcode, AllocatableValue result, Value x, Value y, AllocatableValue scratch1, AllocatableValue scratch2, LIRFrameState state) {
            super(TYPE, SIZE);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
            this.scratch1 = scratch1;
            this.scratch2 = scratch2;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            block23: {
                block22: {
                    if (LIRValueUtil.isJavaConstant(this.x) || !LIRValueUtil.isJavaConstant(this.y)) break block22;
                    assert (SPARCAssembler.isSimm13(crb.asIntConst(this.y)));
                    assert (!this.x.equals((Object)this.scratch1));
                    assert (!this.x.equals((Object)this.scratch2));
                    assert (!this.y.equals((Object)this.scratch1));
                    switch (this.opcode) {
                        case LUREM: {
                            if (this.state != null) {
                                crb.recordImplicitException(masm.position(), this.state);
                            }
                            masm.udivx(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), crb.asIntConst(this.y), ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD));
                            masm.mulx(ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD), crb.asIntConst(this.y), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD));
                            this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
                            masm.sub(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD));
                            break block23;
                        }
                        case IUREM: {
                            GraalError.unimplemented();
                            break block23;
                        }
                        default: {
                            throw GraalError.shouldNotReachHere();
                        }
                    }
                }
                if (ValueUtil.isRegister((Value)this.x) && ValueUtil.isRegister((Value)this.y)) {
                    Value xLeft = this.x;
                    switch (this.opcode) {
                        case LUREM: {
                            if (LIRValueUtil.isJavaConstant(this.x)) {
                                masm.setx(crb.asLongConst(this.x), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.XWORD), false);
                                xLeft = this.scratch2;
                            }
                            assert (!ValueUtil.asRegister((Value)xLeft, (PlatformKind)SPARCKind.XWORD).equals((Object)ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD)));
                            assert (!ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD).equals((Object)ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD)));
                            if (this.state != null) {
                                crb.recordImplicitException(masm.position(), this.state);
                            }
                            masm.udivx(ValueUtil.asRegister((Value)xLeft, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD));
                            masm.mulx(ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD));
                            this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
                            masm.sub(ValueUtil.asRegister((Value)xLeft, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.XWORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD));
                            break;
                        }
                        case IUREM: {
                            assert (!ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD).equals((Object)ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.WORD)));
                            assert (!ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD).equals((Object)ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.WORD)));
                            masm.srl(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.WORD), 0, ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.WORD));
                            masm.srl(ValueUtil.asRegister((Value)this.y, (PlatformKind)SPARCKind.WORD), 0, ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD));
                            if (this.state != null) {
                                crb.recordImplicitException(masm.position(), this.state);
                            }
                            masm.udivx(ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.WORD));
                            masm.mulx(ValueUtil.asRegister((Value)this.scratch2, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD));
                            this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
                            masm.sub(ValueUtil.asRegister((Value)this.scratch1, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD));
                            break;
                        }
                        default: {
                            throw GraalError.shouldNotReachHere();
                        }
                    }
                } else {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }

        public static enum Rem {
            IUREM,
            LUREM;

        }
    }

    public static final class FloatConvertOp
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<FloatConvertOp> TYPE = LIRInstructionClass.create(FloatConvertOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(5);
        @Opcode
        private final FloatConvert opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected Value x;

        public FloatConvertOp(FloatConvert opcode, Value x, AllocatableValue result) {
            super(TYPE, SIZE);
            this.opcode = opcode;
            this.x = x;
            this.result = result;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            Label notOrdered = new Label();
            switch (this.opcode) {
                case F2L: {
                    masm.fcmp(SPARCAssembler.CC.Fcc0, SPARCAssembler.Opfs.Fcmps, ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.SINGLE));
                    SPARCAssembler.FBPCC.emit(masm, SPARCAssembler.CC.Fcc0, SPARCAssembler.ConditionFlag.F_Ordered, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, notOrdered);
                    masm.fstox(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE));
                    masm.fxtod(ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result));
                    masm.fsubd(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE));
                    masm.bind(notOrdered);
                    break;
                }
                case F2I: {
                    masm.fcmp(SPARCAssembler.CC.Fcc0, SPARCAssembler.Opfs.Fcmps, ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.SINGLE));
                    SPARCAssembler.FBPCC.emit(masm, SPARCAssembler.CC.Fcc0, SPARCAssembler.ConditionFlag.F_Ordered, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, notOrdered);
                    masm.fstoi(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE));
                    masm.fitos(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE));
                    masm.fsubs(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE));
                    masm.bind(notOrdered);
                    break;
                }
                case D2L: {
                    masm.fcmp(SPARCAssembler.CC.Fcc0, SPARCAssembler.Opfs.Fcmpd, ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.DOUBLE));
                    SPARCAssembler.FBPCC.emit(masm, SPARCAssembler.CC.Fcc0, SPARCAssembler.ConditionFlag.F_Ordered, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, notOrdered);
                    masm.fdtox(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE));
                    masm.fxtod(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE));
                    masm.fsubd(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.DOUBLE));
                    masm.bind(notOrdered);
                    break;
                }
                case D2I: {
                    masm.fcmp(SPARCAssembler.CC.Fcc0, SPARCAssembler.Opfs.Fcmpd, ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.DOUBLE));
                    SPARCAssembler.FBPCC.emit(masm, SPARCAssembler.CC.Fcc0, SPARCAssembler.ConditionFlag.F_Ordered, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, notOrdered);
                    masm.fdtoi(ValueUtil.asRegister((Value)this.x, (PlatformKind)SPARCKind.DOUBLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE));
                    masm.fitos(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE));
                    masm.fsubs(ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.SINGLE));
                    masm.bind(notOrdered);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("missing: " + (Object)((Object)this.opcode));
                }
            }
        }

        public static enum FloatConvert {
            F2I,
            D2I,
            F2L,
            D2L;

        }
    }
}

