/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.phases;

import java.util.ArrayList;
import java.util.ListIterator;

public class GenericContext {
    private ArrayList<Object> context = null;

    public <T> void contextAdd(T obj) {
        if (this.context == null) {
            this.context = new ArrayList();
        }
        this.context.add(obj);
    }

    public <T> T contextLookup(Class<T> clazz) {
        if (this.context != null) {
            for (Object e : this.context) {
                if (!clazz.isInstance(e)) continue;
                return (T)e;
            }
        }
        return null;
    }

    public <T> T contextRemove(Class<T> clazz) {
        if (this.context != null) {
            ListIterator<Object> it = this.context.listIterator();
            while (it.hasNext()) {
                Object e = it.next();
                if (!clazz.isInstance(e)) continue;
                it.remove();
                if (this.context.isEmpty()) {
                    this.context = null;
                }
                return (T)e;
            }
        }
        return null;
    }
}

