/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.vector;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AMD64VectorCompareOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64VectorCompareOp> TYPE = LIRInstructionClass.create(AMD64VectorCompareOp.class);
    @Opcode
    private final AMD64Assembler.VexRMOp opcode;
    private final AVXKind.AVXSize size;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue x;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
    protected AllocatableValue y;

    public AMD64VectorCompareOp(AMD64Assembler.VexRMOp opcode, AllocatableValue x, AllocatableValue y) {
        this(opcode, AVXKind.AVXSize.XMM, x, y);
    }

    public AMD64VectorCompareOp(AMD64Assembler.VexRMOp opcode, AVXKind.AVXSize size, AllocatableValue x, AllocatableValue y) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.size = size;
        this.x = x;
        this.y = y;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (ValueUtil.isRegister((Value)this.y)) {
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        } else {
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y));
        }
    }
}

