/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.lir.framemap.FrameMap;

public class AMD64FrameMap
extends FrameMap {
    private StackSlot rbpSpillSlot;

    public AMD64FrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory) {
        this(codeCache, registerConfig, referenceMapFactory, false);
    }

    public AMD64FrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory, boolean useBasePointer) {
        super(codeCache, registerConfig, referenceMapFactory);
        this.spillSize = this.initialSpillSize = this.returnAddressSize() + (useBasePointer ? this.getTarget().arch.getWordSize() : 0);
    }

    @Override
    public int totalFrameSize() {
        int result = this.frameSize() + this.initialSpillSize;
        assert (result % this.getTarget().stackAlignment == 0) : "Total frame size not aligned: " + result;
        return result;
    }

    @Override
    public int currentFrameSize() {
        return this.alignFrameSize(this.outgoingSize + this.spillSize - this.initialSpillSize);
    }

    @Override
    protected int alignFrameSize(int size) {
        return NumUtil.roundUp(size + this.initialSpillSize, this.getTarget().stackAlignment) - this.initialSpillSize;
    }

    @Override
    public int offsetForStackSlot(StackSlot slot) {
        assert (!slot.getRawAddFrameSize() && slot.getRawOffset() < this.outgoingSize || slot.getRawAddFrameSize() && slot.getRawOffset() < 0 && -slot.getRawOffset() <= this.spillSize || slot.getRawAddFrameSize() && slot.getRawOffset() >= 0) : String.format("RawAddFrameSize: %b RawOffset: 0x%x spillSize: 0x%x outgoingSize: 0x%x", slot.getRawAddFrameSize(), slot.getRawOffset(), this.spillSize, this.outgoingSize);
        return super.offsetForStackSlot(slot);
    }

    StackSlot allocateRBPSpillSlot() {
        assert (this.spillSize == this.initialSpillSize) : "RBP spill slot must be the first allocated stack slots";
        this.rbpSpillSlot = this.allocateSpillSlot(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        assert (ValueUtil.asStackSlot((Value)this.rbpSpillSlot).getRawOffset() == -16) : ValueUtil.asStackSlot((Value)this.rbpSpillSlot).getRawOffset();
        return this.rbpSpillSlot;
    }

    void freeRBPSpillSlot() {
        int size = this.spillSlotSize(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        assert (this.spillSize == NumUtil.roundUp(this.initialSpillSize + size, size)) : "RBP spill slot can not be freed after allocation other stack slots";
        this.spillSize = this.initialSpillSize;
    }

    public StackSlot allocateDeoptimizationRescueSlot() {
        assert (this.spillSize == this.initialSpillSize || this.spillSize == this.initialSpillSize + this.spillSlotSize(LIRKind.value((PlatformKind)AMD64Kind.QWORD))) : "Deoptimization rescue slot must be the first or second (if there is an RBP spill slot) stack slot";
        return this.allocateSpillSlot(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
    }
}

