/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64BlockEndOp;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64ControlFlow {
    private static void floatJcc(AMD64MacroAssembler masm, AMD64Assembler.ConditionFlag condition, boolean unorderedIsTrue, Label label) {
        Label endLabel = new Label();
        if (unorderedIsTrue && !AMD64ControlFlow.trueOnUnordered(condition)) {
            masm.jcc(AMD64Assembler.ConditionFlag.Parity, label);
        } else if (!unorderedIsTrue && AMD64ControlFlow.trueOnUnordered(condition)) {
            masm.jccb(AMD64Assembler.ConditionFlag.Parity, endLabel);
        }
        masm.jcc(condition, label);
        masm.bind(endLabel);
    }

    private static void cmove(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, boolean isFloat, AMD64Assembler.ConditionFlag condition, boolean unorderedIsTrue, Value trueValue, Value falseValue) {
        assert (!result.equals((Object)trueValue));
        AMD64Move.move(crb, masm, result, falseValue);
        AMD64ControlFlow.cmove(crb, masm, result, condition, trueValue);
        if (isFloat) {
            if (unorderedIsTrue && !AMD64ControlFlow.trueOnUnordered(condition)) {
                AMD64ControlFlow.cmove(crb, masm, result, AMD64Assembler.ConditionFlag.Parity, trueValue);
            } else if (!unorderedIsTrue && AMD64ControlFlow.trueOnUnordered(condition)) {
                AMD64ControlFlow.cmove(crb, masm, result, AMD64Assembler.ConditionFlag.Parity, falseValue);
            }
        }
    }

    private static void cmove(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, AMD64Assembler.ConditionFlag cond, Value other) {
        block10: {
            block9: {
                if (!ValueUtil.isRegister((Value)other)) break block9;
                assert (!ValueUtil.asRegister((Value)other).equals((Object)ValueUtil.asRegister((Value)result))) : "other already overwritten by previous move";
                switch ((AMD64Kind)other.getPlatformKind()) {
                    case BYTE: 
                    case WORD: 
                    case DWORD: {
                        masm.cmovl(cond, ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)other));
                        break block10;
                    }
                    case QWORD: {
                        masm.cmovq(cond, ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)other));
                        break block10;
                    }
                    default: {
                        throw GraalError.shouldNotReachHere();
                    }
                }
            }
            AMD64Address addr = (AMD64Address)crb.asAddress(other);
            switch ((AMD64Kind)other.getPlatformKind()) {
                case BYTE: 
                case WORD: 
                case DWORD: {
                    masm.cmovl(cond, ValueUtil.asRegister((Value)result), addr);
                    break;
                }
                case QWORD: {
                    masm.cmovq(cond, ValueUtil.asRegister((Value)result), addr);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    private static void setcc(AMD64MacroAssembler masm, Value result, AMD64Assembler.ConditionFlag cond) {
        switch ((AMD64Kind)result.getPlatformKind()) {
            case BYTE: 
            case WORD: 
            case DWORD: {
                masm.setl(cond, ValueUtil.asRegister((Value)result));
                break;
            }
            case QWORD: {
                masm.setq(cond, ValueUtil.asRegister((Value)result));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    private static AMD64Assembler.ConditionFlag intCond(Condition cond) {
        switch (cond) {
            case EQ: {
                return AMD64Assembler.ConditionFlag.Equal;
            }
            case NE: {
                return AMD64Assembler.ConditionFlag.NotEqual;
            }
            case LT: {
                return AMD64Assembler.ConditionFlag.Less;
            }
            case LE: {
                return AMD64Assembler.ConditionFlag.LessEqual;
            }
            case GE: {
                return AMD64Assembler.ConditionFlag.GreaterEqual;
            }
            case GT: {
                return AMD64Assembler.ConditionFlag.Greater;
            }
            case BE: {
                return AMD64Assembler.ConditionFlag.BelowEqual;
            }
            case AE: {
                return AMD64Assembler.ConditionFlag.AboveEqual;
            }
            case AT: {
                return AMD64Assembler.ConditionFlag.Above;
            }
            case BT: {
                return AMD64Assembler.ConditionFlag.Below;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private static AMD64Assembler.ConditionFlag floatCond(Condition cond) {
        switch (cond) {
            case EQ: {
                return AMD64Assembler.ConditionFlag.Equal;
            }
            case NE: {
                return AMD64Assembler.ConditionFlag.NotEqual;
            }
            case LT: {
                return AMD64Assembler.ConditionFlag.Below;
            }
            case LE: {
                return AMD64Assembler.ConditionFlag.BelowEqual;
            }
            case GE: {
                return AMD64Assembler.ConditionFlag.AboveEqual;
            }
            case GT: {
                return AMD64Assembler.ConditionFlag.Above;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public static boolean trueOnUnordered(Condition condition) {
        return AMD64ControlFlow.trueOnUnordered(AMD64ControlFlow.floatCond(condition));
    }

    private static boolean trueOnUnordered(AMD64Assembler.ConditionFlag condition) {
        switch (condition) {
            case AboveEqual: 
            case NotEqual: 
            case Above: 
            case Less: 
            case Overflow: {
                return false;
            }
            case Equal: 
            case BelowEqual: 
            case Below: 
            case GreaterEqual: 
            case NoOverflow: {
                return true;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Opcode(value="CMOVE")
    public static final class FloatCondMoveOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<FloatCondMoveOp> TYPE = LIRInstructionClass.create(FloatCondMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected Value result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value trueValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value falseValue;
        private final AMD64Assembler.ConditionFlag condition;
        private final boolean unorderedIsTrue;

        public FloatCondMoveOp(Variable result, Condition condition, boolean unorderedIsTrue, Variable trueValue, Variable falseValue) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.floatCond(condition);
            this.unorderedIsTrue = unorderedIsTrue;
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.cmove(crb, masm, this.result, true, this.condition, this.unorderedIsTrue, this.trueValue, this.falseValue);
        }
    }

    @Opcode(value="CMOVE")
    public static final class CondMoveOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CondMoveOp> TYPE = LIRInstructionClass.create(CondMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value trueValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.CONST})
        protected Value falseValue;
        private final AMD64Assembler.ConditionFlag condition;

        public CondMoveOp(Variable result, Condition condition, AllocatableValue trueValue, Value falseValue) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.intCond(condition);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.cmove(crb, masm, this.result, false, this.condition, false, this.trueValue, this.falseValue);
        }
    }

    @Opcode(value="SETcc")
    public static final class FloatCondSetOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<FloatCondSetOp> TYPE = LIRInstructionClass.create(FloatCondSetOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value result;
        private final AMD64Assembler.ConditionFlag condition;

        public FloatCondSetOp(Variable result, Condition condition) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.floatCond(condition);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.setcc(masm, this.result, this.condition);
        }
    }

    @Opcode(value="SETcc")
    public static final class CondSetOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CondSetOp> TYPE = LIRInstructionClass.create(CondSetOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value result;
        private final AMD64Assembler.ConditionFlag condition;

        public CondSetOp(Variable result, Condition condition) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.intCond(condition);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.setcc(masm, this.result, this.condition);
        }
    }

    public static final class HashTableSwitchOp
    extends AMD64BlockEndOp {
        public static final LIRInstructionClass<HashTableSwitchOp> TYPE = LIRInstructionClass.create(HashTableSwitchOp.class);
        private final JavaConstant[] keys;
        private final LabelRef defaultTarget;
        private final LabelRef[] targets;
        @LIRInstruction.Alive
        protected Value value;
        @LIRInstruction.Alive
        protected Value hash;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected Value entryScratch;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected Value scratch;

        public HashTableSwitchOp(JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, Value value, Value hash, Variable scratch, Variable entryScratch) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)TYPE);
            this.keys = keys;
            this.defaultTarget = defaultTarget;
            this.targets = targets;
            this.value = value;
            this.hash = hash;
            this.scratch = scratch;
            this.entryScratch = entryScratch;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            Register valueReg = ValueUtil.asRegister((Value)this.value, (PlatformKind)AMD64Kind.DWORD);
            Register indexReg = ValueUtil.asRegister((Value)this.hash, (PlatformKind)AMD64Kind.DWORD);
            Register scratchReg = ValueUtil.asRegister((Value)this.scratch, (PlatformKind)AMD64Kind.QWORD);
            Register entryScratchReg = ValueUtil.asRegister((Value)this.entryScratch, (PlatformKind)AMD64Kind.QWORD);
            masm.leaq(scratchReg, new AMD64Address(AMD64.rip, 0));
            int afterLea = masm.position();
            if (this.defaultTarget != null) {
                masm.movq(entryScratchReg, new AMD64Address(scratchReg, indexReg, AMD64Address.Scale.Times8, 0));
                masm.cmpl(entryScratchReg, valueReg);
                masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, this.defaultTarget.label());
                masm.sarq(entryScratchReg, 32);
            } else {
                masm.movslq(entryScratchReg, new AMD64Address(scratchReg, indexReg, AMD64Address.Scale.Times4, 0));
            }
            masm.addq(scratchReg, entryScratchReg);
            masm.jmp(scratchReg);
            if (this.defaultTarget != null) {
                masm.align(8);
            } else {
                masm.align(4);
            }
            int jumpTablePos = masm.position();
            int leaDisplacementPosition = afterLea - 4;
            masm.emitInt(jumpTablePos - afterLea, leaDisplacementPosition);
            for (int i = 0; i < this.targets.length; ++i) {
                Label label = this.targets[i].label();
                if (this.defaultTarget != null) {
                    masm.emitInt(this.keys[i].asInt());
                }
                if (label.isBound()) {
                    int imm32 = label.position() - jumpTablePos;
                    masm.emitInt(imm32);
                    continue;
                }
                int offsetToJumpTableBase = masm.position() - jumpTablePos;
                label.addPatchAt(masm.position(), masm);
                masm.emitByte(0);
                masm.emitShort(offsetToJumpTableBase);
                masm.emitByte(0);
            }
            CompilationResult.JumpTable jt = new CompilationResult.JumpTable(jumpTablePos, this.keys[0].asInt(), this.keys[this.keys.length - 1].asInt(), 4);
            crb.compilationResult.addAnnotation(jt);
        }
    }

    public static final class TableSwitchOp
    extends AMD64BlockEndOp {
        public static final LIRInstructionClass<TableSwitchOp> TYPE = LIRInstructionClass.create(TableSwitchOp.class);
        private final int lowKey;
        private final LabelRef defaultTarget;
        private final LabelRef[] targets;
        @LIRInstruction.Use
        protected Value index;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value idxScratch;
        @LIRInstruction.Temp
        protected Value scratch;

        public TableSwitchOp(int lowKey, LabelRef defaultTarget, LabelRef[] targets, Value index, Variable scratch, Variable idxScratch) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)TYPE);
            this.lowKey = lowKey;
            this.defaultTarget = defaultTarget;
            this.targets = targets;
            this.index = index;
            this.scratch = scratch;
            this.idxScratch = idxScratch;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            Register indexReg = ValueUtil.asRegister((Value)this.index, (PlatformKind)AMD64Kind.DWORD);
            Register idxScratchReg = ValueUtil.asRegister((Value)this.idxScratch, (PlatformKind)AMD64Kind.DWORD);
            Register scratchReg = ValueUtil.asRegister((Value)this.scratch, (PlatformKind)AMD64Kind.QWORD);
            if (!indexReg.equals((Object)idxScratchReg)) {
                masm.movl(idxScratchReg, indexReg);
            }
            int highKey = this.lowKey + this.targets.length - 1;
            if (this.lowKey != 0) {
                masm.subl(idxScratchReg, this.lowKey);
                masm.cmpl(idxScratchReg, highKey - this.lowKey);
            } else {
                masm.cmpl(idxScratchReg, highKey);
            }
            if (this.defaultTarget != null) {
                masm.jcc(AMD64Assembler.ConditionFlag.Above, this.defaultTarget.label());
            }
            masm.leaq(scratchReg, new AMD64Address(AMD64.rip, 0));
            int afterLea = masm.position();
            masm.movslq(idxScratchReg, new AMD64Address(scratchReg, idxScratchReg, AMD64Address.Scale.Times4, 0));
            masm.addq(scratchReg, idxScratchReg);
            masm.jmp(scratchReg);
            masm.align(4);
            int jumpTablePos = masm.position();
            int leaDisplacementPosition = afterLea - 4;
            masm.emitInt(jumpTablePos - afterLea, leaDisplacementPosition);
            for (LabelRef target : this.targets) {
                Label label = target.label();
                int offsetToJumpTableBase = masm.position() - jumpTablePos;
                if (label.isBound()) {
                    int imm32 = label.position() - jumpTablePos;
                    masm.emitInt(imm32);
                    continue;
                }
                label.addPatchAt(masm.position(), masm);
                masm.emitByte(0);
                masm.emitShort(offsetToJumpTableBase);
                masm.emitByte(0);
            }
            CompilationResult.JumpTable jt = new CompilationResult.JumpTable(jumpTablePos, this.lowKey, highKey, 4);
            crb.compilationResult.addAnnotation(jt);
        }
    }

    public static class StrategySwitchOp
    extends AMD64BlockEndOp {
        public static final LIRInstructionClass<StrategySwitchOp> TYPE = LIRInstructionClass.create(StrategySwitchOp.class);
        protected final Constant[] keyConstants;
        private final LabelRef[] keyTargets;
        private LabelRef defaultTarget;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value key;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value scratch;
        protected final SwitchStrategy strategy;

        public StrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, Value key, Value scratch) {
            this(TYPE, strategy, keyTargets, defaultTarget, key, scratch);
        }

        protected StrategySwitchOp(LIRInstructionClass<? extends StrategySwitchOp> c, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, Value key, Value scratch) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)c);
            this.strategy = strategy;
            this.keyConstants = strategy.getKeyConstants();
            this.keyTargets = keyTargets;
            this.defaultTarget = defaultTarget;
            this.key = key;
            this.scratch = scratch;
            assert (this.keyConstants.length == keyTargets.length);
            assert (this.keyConstants.length == strategy.keyProbabilities.length);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            this.strategy.run(new SwitchClosure(ValueUtil.asRegister((Value)this.key), crb, masm));
        }

        public class SwitchClosure
        extends SwitchStrategy.BaseSwitchClosure {
            protected final Register keyRegister;
            protected final CompilationResultBuilder crb;
            protected final AMD64MacroAssembler masm;

            protected SwitchClosure(Register keyRegister, CompilationResultBuilder crb, AMD64MacroAssembler masm) {
                super(crb, masm, StrategySwitchOp.this.keyTargets, StrategySwitchOp.this.defaultTarget);
                this.keyRegister = keyRegister;
                this.crb = crb;
                this.masm = masm;
            }

            protected void emitComparison(Constant c) {
                JavaConstant jc = (JavaConstant)c;
                switch (jc.getJavaKind()) {
                    case Int: {
                        long lc = jc.asLong();
                        assert (NumUtil.isInt(lc));
                        this.masm.cmpl(this.keyRegister, (int)lc);
                        break;
                    }
                    case Long: {
                        this.masm.cmpq(this.keyRegister, (AMD64Address)this.crb.asLongConstRef(jc));
                        break;
                    }
                    case Object: {
                        AMD64Move.const2reg(this.crb, this.masm, ValueUtil.asRegister((Value)StrategySwitchOp.this.scratch), jc, AMD64Kind.QWORD);
                        this.masm.cmpptr(this.keyRegister, ValueUtil.asRegister((Value)StrategySwitchOp.this.scratch));
                        break;
                    }
                    default: {
                        throw new GraalError("switch only supported for int, long and object");
                    }
                }
            }

            @Override
            protected void conditionalJump(int index, Condition condition, Label target) {
                this.emitComparison(StrategySwitchOp.this.keyConstants[index]);
                this.masm.jcc(AMD64ControlFlow.intCond(condition), target);
            }
        }
    }

    public static final class FloatBranchOp
    extends BranchOp {
        public static final LIRInstructionClass<FloatBranchOp> TYPE = LIRInstructionClass.create(FloatBranchOp.class);
        protected boolean unorderedIsTrue;

        public FloatBranchOp(Condition condition, boolean unorderedIsTrue, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.floatCond(condition), trueDestination, falseDestination, trueDestinationProbability);
            this.unorderedIsTrue = unorderedIsTrue;
        }

        @Override
        protected void jcc(AMD64MacroAssembler masm, boolean negate, LabelRef target) {
            AMD64ControlFlow.floatJcc(masm, negate ? this.condition.negate() : this.condition, negate ? !this.unorderedIsTrue : this.unorderedIsTrue, target.label());
        }
    }

    public static class BranchOp
    extends AMD64BlockEndOp
    implements StandardOp.BranchOp {
        public static final LIRInstructionClass<BranchOp> TYPE = LIRInstructionClass.create(BranchOp.class);
        protected final AMD64Assembler.ConditionFlag condition;
        protected final LabelRef trueDestination;
        protected final LabelRef falseDestination;
        private final double trueDestinationProbability;

        public BranchOp(Condition condition, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            this(AMD64ControlFlow.intCond(condition), trueDestination, falseDestination, trueDestinationProbability);
        }

        public BranchOp(AMD64Assembler.ConditionFlag condition, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            this(TYPE, condition, trueDestination, falseDestination, trueDestinationProbability);
        }

        protected BranchOp(LIRInstructionClass<? extends BranchOp> c, AMD64Assembler.ConditionFlag condition, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)c);
            this.condition = condition;
            this.trueDestination = trueDestination;
            this.falseDestination = falseDestination;
            this.trueDestinationProbability = trueDestinationProbability;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            boolean isNegated = false;
            int jccPos = masm.position();
            if (crb.isSuccessorEdge(this.trueDestination)) {
                this.jcc(masm, true, this.falseDestination);
                isNegated = true;
            } else if (crb.isSuccessorEdge(this.falseDestination)) {
                this.jcc(masm, false, this.trueDestination);
            } else if (this.trueDestinationProbability < 0.5) {
                this.jcc(masm, true, this.falseDestination);
                masm.jmp(this.trueDestination.label());
                isNegated = true;
            } else {
                this.jcc(masm, false, this.trueDestination);
                masm.jmp(this.falseDestination.label());
            }
            crb.recordBranch(jccPos, isNegated);
        }

        protected void jcc(AMD64MacroAssembler masm, boolean negate, LabelRef target) {
            masm.jcc(negate ? this.condition.negate() : this.condition, target.label());
        }
    }

    public static final class ReturnOp
    extends AMD64BlockEndOp
    implements StandardOp.BlockEndOp {
        public static final LIRInstructionClass<ReturnOp> TYPE = LIRInstructionClass.create(ReturnOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value x;

        public ReturnOp(Value x) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)TYPE);
            this.x = x;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            crb.frameContext.leave(crb);
            if (masm.supports(AMD64.CPUFeature.AVX)) {
                masm.vzeroupper();
            }
            masm.ret(0);
        }
    }
}

