/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="ARRAY_COMPARE_TO")
public final class AMD64ArrayCompareToOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ArrayCompareToOp> TYPE = LIRInstructionClass.create(AMD64ArrayCompareToOp.class);
    private final JavaKind kind1;
    private final JavaKind kind2;
    private final int array1BaseOffset;
    private final int array2BaseOffset;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array2Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length1Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length2Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length1ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length2ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value vectorTemp1;

    public AMD64ArrayCompareToOp(LIRGeneratorTool tool, JavaKind kind1, JavaKind kind2, Value result, Value array1, Value array2, Value length1, Value length2) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.kind1 = kind1;
        this.kind2 = kind2;
        this.array1BaseOffset = tool.getProviders().getMetaAccess().getArrayBaseOffset(kind1);
        this.array2BaseOffset = tool.getProviders().getMetaAccess().getArrayBaseOffset(kind2);
        this.resultValue = result;
        this.array1Value = array1;
        this.array2Value = array2;
        this.length1Value = length1;
        this.length2Value = length2;
        this.length1ValueTemp = length1;
        this.length2ValueTemp = length2;
        this.temp1 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp2 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.vectorTemp1 = AMD64ArrayCompareToOp.supportsSSE42(tool.target()) ? tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DOUBLE)) : Value.ILLEGAL;
    }

    private static boolean supportsSSE42(TargetDescription target) {
        AMD64 arch = (AMD64)target.arch;
        return arch.getFeatures().contains(AMD64.CPUFeature.SSE4_2);
    }

    private static boolean supportsAVX2(TargetDescription target) {
        AMD64 arch = (AMD64)target.arch;
        return arch.getFeatures().contains(AMD64.CPUFeature.AVX2);
    }

    private static boolean supportsAVX512VLBW(TargetDescription target) {
        EnumSet features = ((AMD64)target.arch).getFeatures();
        return features.contains(AMD64.CPUFeature.AVX512BW) && features.contains(AMD64.CPUFeature.AVX512VL);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        int stride;
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register str1 = ValueUtil.asRegister((Value)this.temp1);
        Register str2 = ValueUtil.asRegister((Value)this.temp2);
        masm.leaq(str1, new AMD64Address(ValueUtil.asRegister((Value)this.array1Value), this.array1BaseOffset));
        masm.leaq(str2, new AMD64Address(ValueUtil.asRegister((Value)this.array2Value), this.array2BaseOffset));
        Register cnt1 = ValueUtil.asRegister((Value)this.length1Value);
        Register cnt2 = ValueUtil.asRegister((Value)this.length2Value);
        Label LENGTH_DIFF_LABEL = new Label();
        Label POP_LABEL = new Label();
        Label DONE_LABEL = new Label();
        Label WHILE_HEAD_LABEL = new Label();
        Label COMPARE_WIDE_VECTORS_LOOP_FAILED = new Label();
        int adr_stride = -1;
        int adr_stride1 = -1;
        int adr_stride2 = -1;
        int stride2x2 = 64;
        AMD64Address.Scale scale = null;
        AMD64Address.Scale scale1 = null;
        AMD64Address.Scale scale2 = null;
        if (this.kind1 != JavaKind.Byte || this.kind2 != JavaKind.Byte) {
            stride2x2 = 32;
        }
        if (this.kind1 != this.kind2) {
            masm.shrl(cnt2, 1);
        }
        masm.movl(result, cnt1);
        masm.subl(cnt1, cnt2);
        masm.push(cnt1);
        masm.cmovl(AMD64Assembler.ConditionFlag.LessEqual, cnt2, result);
        masm.testl(cnt2, cnt2);
        masm.jcc(AMD64Assembler.ConditionFlag.Zero, LENGTH_DIFF_LABEL);
        if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
            masm.movzbl(result, new AMD64Address(str1, 0));
            masm.movzbl(cnt1, new AMD64Address(str2, 0));
        } else if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.movzwl(result, new AMD64Address(str1, 0));
            masm.movzwl(cnt1, new AMD64Address(str2, 0));
        } else {
            masm.movzbl(result, new AMD64Address(str1, 0));
            masm.movzwl(cnt1, new AMD64Address(str2, 0));
        }
        masm.subl(result, cnt1);
        masm.jcc(AMD64Assembler.ConditionFlag.NotZero, POP_LABEL);
        if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.shrl(cnt2, 1);
        }
        masm.cmpl(cnt2, 1);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, LENGTH_DIFF_LABEL);
        if (this.kind1 == this.kind2) {
            masm.cmpptr(str1, str2);
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, LENGTH_DIFF_LABEL);
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                scale = AMD64Address.Scale.Times1;
                stride = 16;
            } else {
                scale = AMD64Address.Scale.Times2;
                stride = 8;
            }
        } else {
            scale1 = AMD64Address.Scale.Times1;
            scale2 = AMD64Address.Scale.Times2;
            stride = 8;
        }
        if (AMD64ArrayCompareToOp.supportsAVX2(crb.target) && AMD64ArrayCompareToOp.supportsSSE42(crb.target)) {
            Register vec1 = ValueUtil.asRegister((Value)this.vectorTemp1, (PlatformKind)AMD64Kind.DOUBLE);
            Label COMPARE_WIDE_VECTORS = new Label();
            Label VECTOR_NOT_EQUAL = new Label();
            Label COMPARE_WIDE_TAIL = new Label();
            Label COMPARE_SMALL_STR = new Label();
            Label COMPARE_WIDE_VECTORS_LOOP = new Label();
            Label COMPARE_16_CHARS = new Label();
            Label COMPARE_INDEX_CHAR = new Label();
            Label COMPARE_WIDE_VECTORS_LOOP_AVX2 = new Label();
            Label COMPARE_TAIL_LONG = new Label();
            Label COMPARE_WIDE_VECTORS_LOOP_AVX3 = new Label();
            int pcmpmask = 25;
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                pcmpmask &= 0xFFFFFFFE;
            }
            int stride2 = this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte ? 32 : 16;
            if (this.kind1 == this.kind2) {
                adr_stride = stride << scale.log2;
            } else {
                adr_stride1 = 8;
                adr_stride2 = 16;
            }
            assert (result.equals((Object)AMD64.rax) && cnt2.equals((Object)AMD64.rdx) && cnt1.equals((Object)AMD64.rcx)) : "pcmpestri";
            masm.movl(result, cnt2);
            masm.andl(cnt2, ~(stride2 - 1));
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, COMPARE_TAIL_LONG);
            masm.bind(COMPARE_16_CHARS);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, 0));
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, 0));
            }
            masm.pcmpestri(vec1, new AMD64Address(str2, 0), pcmpmask);
            masm.jccb(AMD64Assembler.ConditionFlag.Below, COMPARE_INDEX_CHAR);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, adr_stride));
                masm.pcmpestri(vec1, new AMD64Address(str2, adr_stride), pcmpmask);
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, adr_stride1));
                masm.pcmpestri(vec1, new AMD64Address(str2, adr_stride2), pcmpmask);
            }
            masm.jccb(AMD64Assembler.ConditionFlag.AboveEqual, COMPARE_WIDE_VECTORS);
            masm.addl(cnt1, stride);
            masm.bind(COMPARE_INDEX_CHAR);
            this.loadNextElements(masm, result, cnt2, str1, str2, scale, scale1, scale2, cnt1);
            masm.subl(result, cnt2);
            masm.jmp(POP_LABEL);
            masm.bind(COMPARE_WIDE_VECTORS);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.subl(result, stride2);
            masm.subl(cnt2, stride2);
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, COMPARE_WIDE_TAIL);
            masm.negq(result);
            masm.bind(COMPARE_WIDE_VECTORS_LOOP);
            if (AMD64ArrayCompareToOp.supportsAVX512VLBW(crb.target)) {
                masm.cmpl(cnt2, stride2x2);
                masm.jccb(AMD64Assembler.ConditionFlag.Below, COMPARE_WIDE_VECTORS_LOOP_AVX2);
                masm.testl(cnt2, stride2x2 - 1);
                masm.jccb(AMD64Assembler.ConditionFlag.NotZero, COMPARE_WIDE_VECTORS_LOOP_AVX2);
                masm.bind(COMPARE_WIDE_VECTORS_LOOP_AVX3);
                if (this.kind1 == this.kind2) {
                    masm.evmovdqu64(vec1, new AMD64Address(str1, result, scale));
                    masm.evpcmpeqb(AMD64.k7, vec1, new AMD64Address(str2, result, scale));
                } else {
                    masm.evpmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                    masm.evpcmpeqb(AMD64.k7, vec1, new AMD64Address(str2, result, scale2));
                }
                masm.kortestq(AMD64.k7, AMD64.k7);
                masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, COMPARE_WIDE_VECTORS_LOOP_FAILED);
                masm.addq(result, stride2x2);
                masm.subl(cnt2, stride2x2);
                masm.jccb(AMD64Assembler.ConditionFlag.NotZero, COMPARE_WIDE_VECTORS_LOOP_AVX3);
                masm.vpxor(vec1, vec1, vec1);
                masm.jmpb(COMPARE_WIDE_TAIL);
            }
            masm.bind(COMPARE_WIDE_VECTORS_LOOP_AVX2);
            if (this.kind1 == this.kind2) {
                masm.vmovdqu(vec1, new AMD64Address(str1, result, scale));
                masm.vpxor(vec1, vec1, new AMD64Address(str2, result, scale));
            } else {
                masm.vpmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                masm.vpxor(vec1, vec1, new AMD64Address(str2, result, scale2));
            }
            masm.vptest(vec1, vec1);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, VECTOR_NOT_EQUAL);
            masm.addq(result, stride2);
            masm.subl(cnt2, stride2);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, COMPARE_WIDE_VECTORS_LOOP);
            masm.vpxor(vec1, vec1, vec1);
            masm.bind(COMPARE_WIDE_TAIL);
            masm.testq(result, result);
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, LENGTH_DIFF_LABEL);
            masm.movl(result, stride2);
            masm.movl(cnt2, result);
            masm.negq(result);
            masm.jmp(COMPARE_WIDE_VECTORS_LOOP_AVX2);
            masm.bind(VECTOR_NOT_EQUAL);
            masm.vpxor(vec1, vec1, vec1);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.jmp(COMPARE_16_CHARS);
            masm.bind(COMPARE_TAIL_LONG);
            masm.movl(cnt2, result);
            masm.cmpl(cnt2, stride);
            masm.jcc(AMD64Assembler.ConditionFlag.Less, COMPARE_SMALL_STR);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, 0));
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, 0));
            }
            masm.pcmpestri(vec1, new AMD64Address(str2, 0), pcmpmask);
            masm.jcc(AMD64Assembler.ConditionFlag.Below, COMPARE_INDEX_CHAR);
            masm.subq(cnt2, stride);
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, LENGTH_DIFF_LABEL);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.negq(cnt2);
            masm.jmpb(WHILE_HEAD_LABEL);
            masm.bind(COMPARE_SMALL_STR);
        } else if (AMD64ArrayCompareToOp.supportsSSE42(crb.target)) {
            Register vec1 = ValueUtil.asRegister((Value)this.vectorTemp1, (PlatformKind)AMD64Kind.DOUBLE);
            Label COMPARE_WIDE_VECTORS = new Label();
            Label VECTOR_NOT_EQUAL = new Label();
            Label COMPARE_TAIL = new Label();
            int pcmpmask = 25;
            masm.movl(result, cnt2);
            masm.andl(cnt2, ~(stride - 1));
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                pcmpmask &= 0xFFFFFFFE;
            }
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, COMPARE_TAIL);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.negq(result);
            assert (result.equals((Object)AMD64.rax) && cnt2.equals((Object)AMD64.rdx) && cnt1.equals((Object)AMD64.rcx)) : "pcmpestri";
            masm.bind(COMPARE_WIDE_VECTORS);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, result, scale));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale), pcmpmask);
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale2), pcmpmask);
            }
            masm.jccb(AMD64Assembler.ConditionFlag.Below, VECTOR_NOT_EQUAL);
            masm.addq(result, stride);
            masm.subq(cnt2, stride);
            masm.jccb(AMD64Assembler.ConditionFlag.NotZero, COMPARE_WIDE_VECTORS);
            masm.testq(result, result);
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, LENGTH_DIFF_LABEL);
            masm.movl(cnt2, stride);
            masm.movl(result, stride);
            masm.negq(result);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, result, scale));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale), pcmpmask);
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale2), pcmpmask);
            }
            masm.jccb(AMD64Assembler.ConditionFlag.AboveEqual, LENGTH_DIFF_LABEL);
            masm.bind(VECTOR_NOT_EQUAL);
            masm.addq(cnt1, result);
            this.loadNextElements(masm, result, cnt2, str1, str2, scale, scale1, scale2, cnt1);
            masm.subl(result, cnt2);
            masm.jmpb(POP_LABEL);
            masm.bind(COMPARE_TAIL);
            masm.movl(cnt2, result);
        }
        if (this.kind1 == this.kind2) {
            masm.leaq(str1, new AMD64Address(str1, cnt2, scale));
            masm.leaq(str2, new AMD64Address(str2, cnt2, scale));
        } else {
            masm.leaq(str1, new AMD64Address(str1, cnt2, scale1));
            masm.leaq(str2, new AMD64Address(str2, cnt2, scale2));
        }
        masm.decrementl(cnt2);
        masm.negq(cnt2);
        masm.bind(WHILE_HEAD_LABEL);
        this.loadNextElements(masm, result, cnt1, str1, str2, scale, scale1, scale2, cnt2);
        masm.subl(result, cnt1);
        masm.jccb(AMD64Assembler.ConditionFlag.NotZero, POP_LABEL);
        masm.incrementq(cnt2, 1);
        masm.jccb(AMD64Assembler.ConditionFlag.NotZero, WHILE_HEAD_LABEL);
        masm.bind(LENGTH_DIFF_LABEL);
        masm.pop(result);
        if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.sarl(result, 1);
        }
        masm.jmpb(DONE_LABEL);
        if (AMD64ArrayCompareToOp.supportsAVX512VLBW(crb.target)) {
            masm.bind(COMPARE_WIDE_VECTORS_LOOP_FAILED);
            masm.kmovq(cnt1, AMD64.k7);
            masm.notq(cnt1);
            masm.bsfq(cnt2, cnt1);
            if (this.kind1 != JavaKind.Byte || this.kind2 != JavaKind.Byte) {
                masm.sarl(cnt2, 1);
            }
            masm.addq(result, cnt2);
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                masm.movzbl(cnt1, new AMD64Address(str2, result, AMD64Address.Scale.Times1));
                masm.movzbl(result, new AMD64Address(str1, result, AMD64Address.Scale.Times1));
            } else if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
                masm.movzwl(cnt1, new AMD64Address(str2, result, scale));
                masm.movzwl(result, new AMD64Address(str1, result, scale));
            } else {
                masm.movzwl(cnt1, new AMD64Address(str2, result, scale2));
                masm.movzbl(result, new AMD64Address(str1, result, scale1));
            }
            masm.subl(result, cnt1);
            masm.jmpb(POP_LABEL);
        }
        masm.bind(POP_LABEL);
        masm.pop(cnt1);
        masm.bind(DONE_LABEL);
        if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Byte) {
            masm.negl(result);
        }
    }

    private void loadNextElements(AMD64MacroAssembler masm, Register elem1, Register elem2, Register str1, Register str2, AMD64Address.Scale scale, AMD64Address.Scale scale1, AMD64Address.Scale scale2, Register index) {
        if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
            masm.movzbl(elem1, new AMD64Address(str1, index, scale, 0));
            masm.movzbl(elem2, new AMD64Address(str2, index, scale, 0));
        } else if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.movzwl(elem1, new AMD64Address(str1, index, scale, 0));
            masm.movzwl(elem2, new AMD64Address(str2, index, scale, 0));
        } else {
            masm.movzbl(elem1, new AMD64Address(str1, index, scale1, 0));
            masm.movzwl(elem2, new AMD64Address(str2, index, scale2, 0));
        }
    }
}

