/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public enum AMD64Arithmetic {
    FREM,
    DREM;


    public static class FPDivRemOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<FPDivRemOp> TYPE = LIRInstructionClass.create(FPDivRemOp.class);
        @Opcode
        private final AMD64Arithmetic opcode;
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Use
        protected AllocatableValue x;
        @LIRInstruction.Use
        protected AllocatableValue y;
        @LIRInstruction.Temp
        protected AllocatableValue raxTemp;

        public FPDivRemOp(AMD64Arithmetic opcode, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.result = result;
            this.raxTemp = AMD64.rax.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.DWORD));
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Address tmp = new AMD64Address(AMD64.rsp);
            masm.subq(AMD64.rsp, 8);
            if (this.opcode == FREM) {
                masm.movflt(tmp, ValueUtil.asRegister((Value)this.y));
                masm.flds(tmp);
                masm.movflt(tmp, ValueUtil.asRegister((Value)this.x));
                masm.flds(tmp);
            } else {
                assert (this.opcode == DREM);
                masm.movdbl(tmp, ValueUtil.asRegister((Value)this.y));
                masm.fldd(tmp);
                masm.movdbl(tmp, ValueUtil.asRegister((Value)this.x));
                masm.fldd(tmp);
            }
            Label label = new Label();
            masm.bind(label);
            masm.fprem();
            masm.fwait();
            masm.fnstswAX();
            masm.testl(AMD64.rax, 1024);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, label);
            masm.fxch(1);
            masm.fpop();
            if (this.opcode == FREM) {
                masm.fstps(tmp);
                masm.movflt(ValueUtil.asRegister((Value)this.result), tmp);
            } else {
                masm.fstpd(tmp);
                masm.movdbl(ValueUtil.asRegister((Value)this.result), tmp);
            }
            masm.addq(AMD64.rsp, 8);
        }

        @Override
        public void verify() {
            super.verify();
            assert (this.opcode.name().startsWith("F") && this.result.getPlatformKind() == AMD64Kind.SINGLE && this.x.getPlatformKind() == AMD64Kind.SINGLE && this.y.getPlatformKind() == AMD64Kind.SINGLE || this.opcode.name().startsWith("D") && this.result.getPlatformKind() == AMD64Kind.DOUBLE && this.x.getPlatformKind() == AMD64Kind.DOUBLE && this.y.getPlatformKind() == AMD64Kind.DOUBLE);
        }
    }
}

