/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc;

import java.util.EnumSet;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;

public class AllocationStageVerifier
extends AllocationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.verifyLIR(lirGenRes.getLIR());
    }

    protected void verifyLIR(LIR lir) {
        for (AbstractBlockBase block : lir.getControlFlowGraph().getBlocks()) {
            this.verifyBlock(lir, block);
        }
    }

    protected void verifyBlock(LIR lir, AbstractBlockBase<?> block) {
        for (LIRInstruction inst : lir.getLIRforBlock(block)) {
            this.verifyInstruction(inst);
        }
    }

    protected void verifyInstruction(LIRInstruction inst) {
        inst.visitEachInput(this::verifyOperands);
        inst.visitEachOutput(this::verifyOperands);
        inst.visitEachAlive(this::verifyOperands);
        inst.visitEachTemp(this::verifyOperands);
    }

    protected void verifyOperands(LIRInstruction instruction, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        assert (!LIRValueUtil.isVirtualStackSlot(value) && !LIRValueUtil.isVariable(value)) : "Virtual values not allowed after allocation stage: " + value;
    }
}

