/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64BitFieldOp
extends AArch64LIRInstruction {
    private static final LIRInstructionClass<AArch64BitFieldOp> TYPE = LIRInstructionClass.create(AArch64BitFieldOp.class);
    @Opcode
    private final BitFieldOpCode opcode;
    @LIRInstruction.Def
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    private final int lsb;
    private final int width;

    public AArch64BitFieldOp(BitFieldOpCode opcode, AllocatableValue result, AllocatableValue input, int lsb, int width) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
        this.lsb = lsb;
        this.width = width;
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        int size = this.input.getPlatformKind().getSizeInBytes() * 8;
        switch (this.opcode) {
            case UBFX: {
                masm.ubfm(size, dst, src, this.lsb, this.lsb + this.width - 1);
                break;
            }
            case UBFIZ: {
                masm.ubfm(size, dst, src, size - this.lsb, this.width - 1);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public static enum BitFieldOpCode {
        UBFX,
        UBFIZ;

    }
}

