/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import org.graalvm.compiler.core.common.FieldIntrospection;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.core.common.FieldsScanner;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.CompositeValue;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRIntrospection;

public final class CompositeValueClass<T>
extends FieldIntrospection<T> {
    private static final ClassValue<CompositeValueClass<?>> compositeClass = new ClassValue<CompositeValueClass<?>>(){

        @Override
        protected CompositeValueClass<?> computeValue(Class<?> type) {
            CompositeValueClass compositeValueClass = new CompositeValueClass(type);
            assert (compositeValueClass.values.getDirectCount() == compositeValueClass.values.getCount()) : "only direct fields are allowed in composites";
            return compositeValueClass;
        }
    };
    private final LIRIntrospection.Values values;

    public static <T> CompositeValueClass<T> get(Class<T> type) {
        return compositeClass.get(type);
    }

    private CompositeValueClass(Class<T> clazz) {
        super(clazz);
        CompositeValueFieldsScanner vfs = new CompositeValueFieldsScanner(new FieldsScanner.DefaultCalcOffset());
        vfs.scan(clazz, CompositeValue.class, false);
        this.values = new LIRIntrospection.Values((LIRIntrospection.OperandModeAnnotation)vfs.valueAnnotations.get(CompositeValue.Component.class));
        this.data = new Fields(vfs.data);
    }

    @Override
    public Fields[] getAllFields() {
        return new Fields[]{this.data, this.values};
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName()).append(" ").append(this.getClazz().getSimpleName()).append(" components[");
        this.values.appendFields(str);
        str.append("] data[");
        this.data.appendFields(str);
        str.append("]");
        return str.toString();
    }

    public static String format(CompositeValue obj) {
        CompositeValueClass<?> valueClass = compositeClass.get(((Object)((Object)obj)).getClass());
        StringBuilder result = new StringBuilder();
        LIRIntrospection.appendValues(result, (Object)obj, "", "", "{", "}", new String[]{""}, valueClass.values);
        for (int i = 0; i < valueClass.data.getCount(); ++i) {
            result.append(" ").append(valueClass.data.getName(i)).append(": ").append(LIRIntrospection.getFieldString((Object)obj, i, valueClass.data));
        }
        return result.toString();
    }

    private static class CompositeValueFieldsScanner
    extends LIRIntrospection.LIRFieldsScanner {
        CompositeValueFieldsScanner(FieldsScanner.CalcOffset calc) {
            super(calc);
            this.valueAnnotations.put(CompositeValue.Component.class, (Object)new LIRIntrospection.OperandModeAnnotation());
        }

        @Override
        protected EnumSet<LIRInstruction.OperandFlag> getFlags(Field field) {
            EnumSet<LIRInstruction.OperandFlag> result = EnumSet.noneOf(LIRInstruction.OperandFlag.class);
            if (field.isAnnotationPresent(CompositeValue.Component.class)) {
                result.addAll(Arrays.asList(field.getAnnotation(CompositeValue.Component.class).value()));
            } else {
                GraalError.shouldNotReachHere();
            }
            return result;
        }
    }
}

