/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.JavaMethodContext;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.hotspot.stubs.ForeignCallSnippets;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import org.graalvm.compiler.replacements.GraphKit;
import org.graalvm.compiler.replacements.nodes.ReadRegisterNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public class ForeignCallStub
extends Stub {
    private final HotSpotJVMCIRuntime jvmciRuntime;
    private final HotSpotForeignCallLinkage target;
    protected final boolean prependThread;

    public ForeignCallStub(OptionValues options, HotSpotJVMCIRuntime runtime, HotSpotProviders providers, long address, ForeignCallDescriptor descriptor, boolean prependThread, HotSpotForeignCallLinkage.Transition transition, HotSpotForeignCallLinkage.Reexecutability reexecutability, LocationIdentity ... killedLocations) {
        super(options, providers, HotSpotForeignCallLinkageImpl.create(providers.getMetaAccess(), (CodeCacheProvider)providers.getCodeCache(), providers.getWordTypes(), providers.getForeignCalls(), descriptor, 0L, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, (CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, transition, reexecutability, killedLocations));
        this.jvmciRuntime = runtime;
        this.prependThread = prependThread;
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        Class<?>[] targetParameterTypes = this.createTargetParameters(descriptor);
        ForeignCallDescriptor targetSig = new ForeignCallDescriptor(descriptor.getName() + ":C", descriptor.getResultType(), targetParameterTypes);
        this.target = HotSpotForeignCallLinkageImpl.create(metaAccess, (CodeCacheProvider)providers.getCodeCache(), providers.getWordTypes(), providers.getForeignCalls(), targetSig, address, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, transition, reexecutability, killedLocations);
    }

    public HotSpotForeignCallLinkage getTargetLinkage() {
        return this.target;
    }

    private Class<?>[] createTargetParameters(ForeignCallDescriptor descriptor) {
        Class<?>[] parameters = descriptor.getArgumentTypes();
        if (this.prependThread) {
            Class[] newParameters = new Class[parameters.length + 1];
            System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
            newParameters[0] = Word.class;
            return newParameters;
        }
        return parameters;
    }

    @Override
    protected ResolvedJavaMethod getInstalledCodeOwner() {
        return null;
    }

    @Override
    protected Object debugScopeContext() {
        return new DebugScopeContext(){};
    }

    @Override
    protected StructuredGraph getGraph(DebugContext debug, CompilationIdentifier compilationId) {
        HotSpotWordTypes wordTypes = this.providers.getWordTypes();
        Class<?>[] args = this.linkage.getDescriptor().getArgumentTypes();
        boolean isObjectResult = !LIRKind.isValue((Value)this.linkage.getOutgoingCallingConvention().getReturn());
        boolean shouldClearException = this.linkage.isReexecutable();
        try {
            HotSpotLoweringProvider lowerer = (HotSpotLoweringProvider)this.providers.getLowerer();
            ForeignCallSnippets.Templates foreignCallSnippets = lowerer.getForeignCallSnippets();
            ResolvedJavaMethod handlePendingException = foreignCallSnippets.handlePendingException.getMethod();
            ResolvedJavaMethod getAndClearObjectResult = foreignCallSnippets.getAndClearObjectResult.getMethod();
            ResolvedJavaMethod verifyObject = foreignCallSnippets.verifyObject.getMethod();
            ResolvedJavaMethod thisMethod = this.getGraphMethod();
            GraphKit kit = new GraphKit(debug, thisMethod, this.providers, wordTypes, this.providers.getGraphBuilderPlugins(), compilationId, this.toString());
            StructuredGraph graph = kit.getGraph();
            ParameterNode[] params = this.createParameters(kit, args);
            ReadRegisterNode thread = kit.append(new ReadRegisterNode(this.providers.getRegisters().getThreadRegister(), wordTypes.getWordKind(), true, false));
            FixedWithNextNode result = this.createTargetCall(kit, params, thread);
            ForeignCallStub.createStaticInvoke(kit, handlePendingException, thread, ConstantNode.forBoolean(shouldClearException, graph), ConstantNode.forBoolean(isObjectResult, graph));
            if (isObjectResult) {
                InvokeNode object = ForeignCallStub.createStaticInvoke(kit, getAndClearObjectResult, thread);
                result = ForeignCallStub.createStaticInvoke(kit, verifyObject, object);
            }
            kit.append(new ReturnNode(this.linkage.getDescriptor().getResultType() == Void.TYPE ? null : result));
            debug.dump(3, graph, "Initial stub graph");
            kit.inlineInvokes("Foreign call stub.", "Backend");
            new RemoveValueProxyPhase().apply(graph);
            debug.dump(3, graph, "Stub graph before compilation");
            return graph;
        }
        catch (Exception e) {
            throw GraalError.shouldNotReachHere(e);
        }
    }

    private static InvokeNode createStaticInvoke(GraphKit kit, ResolvedJavaMethod method, ValueNode ... args) {
        return kit.createInvoke(method, CallTargetNode.InvokeKind.Static, null, -5, args);
    }

    private ResolvedJavaMethod getGraphMethod() {
        ResolvedJavaMethod thisMethod = null;
        for (ResolvedJavaMethod method : this.providers.getMetaAccess().lookupJavaType(ForeignCallStub.class).getDeclaredMethods()) {
            if (!method.getName().equals("getGraph")) continue;
            if (thisMethod == null) {
                thisMethod = method;
                continue;
            }
            throw new InternalError("getGraph is ambiguous");
        }
        if (thisMethod == null) {
            throw new InternalError("Can't find getGraph");
        }
        return thisMethod;
    }

    private ParameterNode[] createParameters(GraphKit kit, Class<?>[] args) {
        ParameterNode[] params = new ParameterNode[args.length];
        ResolvedJavaType accessingClass = this.providers.getMetaAccess().lookupJavaType(this.getClass());
        for (int i = 0; i < args.length; ++i) {
            ParameterNode param;
            ResolvedJavaType type = this.providers.getMetaAccess().lookupJavaType(args[i]).resolve(accessingClass);
            StampPair stamp = StampFactory.forDeclaredType(kit.getGraph().getAssumptions(), (JavaType)type, false);
            params[i] = param = kit.unique(new ParameterNode(i, stamp));
        }
        return params;
    }

    private StubForeignCallNode createTargetCall(GraphKit kit, ParameterNode[] params, ReadRegisterNode thread) {
        Stamp stamp = StampFactory.forKind(JavaKind.fromJavaClass(this.target.getDescriptor().getResultType()));
        if (this.prependThread) {
            ValueNode[] targetArguments = new ValueNode[1 + params.length];
            targetArguments[0] = thread;
            System.arraycopy(params, 0, targetArguments, 1, params.length);
            return kit.append(new StubForeignCallNode(this.providers.getForeignCalls(), stamp, this.target.getDescriptor(), targetArguments));
        }
        return kit.append(new StubForeignCallNode(this.providers.getForeignCalls(), stamp, this.target.getDescriptor(), params));
    }

    private class DebugScopeContext
    implements JavaMethod,
    JavaMethodContext {
        private DebugScopeContext() {
        }

        @Override
        public JavaMethod asJavaMethod() {
            return this;
        }

        public Signature getSignature() {
            ForeignCallDescriptor d = ForeignCallStub.this.linkage.getDescriptor();
            MetaAccessProvider metaAccess = ForeignCallStub.this.providers.getMetaAccess();
            Class<?>[] arguments = d.getArgumentTypes();
            ResolvedJavaType[] parameters = new ResolvedJavaType[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                parameters[i] = metaAccess.lookupJavaType(arguments[i]);
            }
            return new HotSpotSignature(ForeignCallStub.this.jvmciRuntime, metaAccess.lookupJavaType(d.getResultType()), parameters);
        }

        public String getName() {
            return ForeignCallStub.this.linkage.getDescriptor().getName();
        }

        public JavaType getDeclaringClass() {
            return ForeignCallStub.this.providers.getMetaAccess().lookupJavaType(ForeignCallStub.class);
        }

        public String toString() {
            return this.format("ForeignCallStub<%n(%p)>");
        }
    }
}

