/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCCall;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

@Opcode(value="CALL_INDIRECT")
final class SPARCIndirectCallOp
extends SPARCCall.IndirectCallOp {
    public static final LIRInstructionClass<SPARCIndirectCallOp> TYPE = LIRInstructionClass.create(SPARCIndirectCallOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
    public static final Register METHOD = SPARC.g5;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value metaspaceMethod;
    private final GraalHotSpotVMConfig config;

    SPARCIndirectCallOp(ResolvedJavaMethod targetMethod, Value result, Value[] parameters, Value[] temps, Value metaspaceMethod, Value targetAddress, LIRFrameState state, GraalHotSpotVMConfig config) {
        super(TYPE, SIZE, targetMethod, result, parameters, temps, targetAddress, state);
        this.metaspaceMethod = metaspaceMethod;
        this.config = config;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        crb.recordMark(this.config.MARKID_INLINE_INVOKE);
        Register callReg = ValueUtil.asRegister((Value)this.targetAddress);
        assert (!callReg.equals((Object)METHOD));
        SPARCCall.indirectCall(crb, masm, callReg, (InvokeTarget)this.callTarget, this.state);
    }

    @Override
    public void verify() {
        super.verify();
        assert (ValueUtil.asRegister((Value)this.metaspaceMethod).equals((Object)METHOD));
    }
}

