/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotDebugInfoBuilder;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotNodeLIRBuilder;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

@Opcode(value="SAFEPOINT")
public class SPARCHotSpotSafepointOp
extends SPARCLIRInstruction {
    public static final LIRInstructionClass<SPARCHotSpotSafepointOp> TYPE = LIRInstructionClass.create(SPARCHotSpotSafepointOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(9);
    @LIRInstruction.State
    protected LIRFrameState state;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue safepointPollAddress;
    private final GraalHotSpotVMConfig config;
    private final Register thread;

    public SPARCHotSpotSafepointOp(LIRFrameState state, GraalHotSpotVMConfig config, Register thread, LIRGeneratorTool tool) {
        super(TYPE, SIZE);
        this.state = state;
        this.config = config;
        this.thread = thread;
        SPARCHotSpotLIRGenerator lirGen = (SPARCHotSpotLIRGenerator)tool;
        this.safepointPollAddress = lirGen.getSafepointAddressValue();
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        SPARCHotSpotSafepointOp.emitCode(crb, masm, this.config, false, this.state, this.thread, (Value)this.safepointPollAddress);
    }

    public static void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm, GraalHotSpotVMConfig config, boolean atReturn, LIRFrameState state, Register thread, Value safepointPollAddress) {
        if (config.threadLocalHandshakes) {
            SPARCHotSpotSafepointOp.emitThreadLocalPoll(crb, masm, config, atReturn, state, thread);
        } else {
            SPARCHotSpotSafepointOp.emitGlobalPoll(crb, masm, config, atReturn, state, ValueUtil.asRegister((Value)safepointPollAddress));
        }
    }

    private static void emitGlobalPoll(CompilationResultBuilder crb, SPARCMacroAssembler masm, GraalHotSpotVMConfig config, boolean atReturn, LIRFrameState state, Register safepointPollAddress) {
        crb.recordMark(atReturn ? config.MARKID_POLL_RETURN_FAR : config.MARKID_POLL_FAR);
        if (state != null) {
            int pos = masm.position();
            crb.recordInfopoint(pos, state, InfopointReason.SAFEPOINT);
        }
        masm.ldx(new SPARCAddress(safepointPollAddress, 0), SPARC.g0);
    }

    private static void emitThreadLocalPoll(CompilationResultBuilder crb, SPARCMacroAssembler masm, GraalHotSpotVMConfig config, boolean atReturn, LIRFrameState state, Register thread) {
        assert (!atReturn || state == null) : "state is unneeded at return";
        assert (config.threadPollingPageOffset >= 0);
        try (SPARCMacroAssembler.ScratchRegister scratchReg = masm.getScratchRegister();){
            Register scratch = scratchReg.getRegister();
            masm.ldx(new SPARCAddress(thread, config.threadPollingPageOffset), scratch);
            crb.recordMark(atReturn ? config.MARKID_POLL_RETURN_FAR : config.MARKID_POLL_FAR);
            if (state != null) {
                int pos = masm.position();
                crb.recordInfopoint(pos, state, InfopointReason.SAFEPOINT);
            }
            masm.ldx(new SPARCAddress(scratch, 0), SPARC.g0);
        }
    }

    static AllocatableValue getSafepointAddressValue(SPARCHotSpotLIRGenerator gen) {
        if (gen.config.threadLocalHandshakes) {
            return Value.ILLEGAL;
        }
        return gen.newVariable(LIRKind.value(gen.target().arch.getWordKind()));
    }

    static void emitPrologue(SPARCHotSpotNodeLIRBuilder lir, SPARCHotSpotLIRGenerator gen) {
        if (!gen.config.threadLocalHandshakes) {
            AllocatableValue var = gen.getSafepointAddressValue();
            lir.append(new SPARCLoadSafepointPollAddress(var, gen.config));
            gen.append(((HotSpotDebugInfoBuilder)lir.getDebugInfoBuilder()).lockStack());
        }
    }

    public static class SPARCLoadSafepointPollAddress
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<SPARCLoadSafepointPollAddress> TYPE = LIRInstructionClass.create(SPARCLoadSafepointPollAddress.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        private final GraalHotSpotVMConfig config;

        public SPARCLoadSafepointPollAddress(AllocatableValue result, GraalHotSpotVMConfig config) {
            super(TYPE, SIZE);
            this.result = result;
            this.config = config;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            masm.setx(this.config.safepointPollingAddress, ValueUtil.asRegister((Value)this.result), false);
        }
    }
}

