/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.core.sparc.SPARCNodeLIRBuilder;
import org.graalvm.compiler.core.sparc.SPARCNodeMatchRules;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotDebugInfoBuilder;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.HotSpotLockStack;
import org.graalvm.compiler.hotspot.HotSpotNodeLIRBuilder;
import org.graalvm.compiler.hotspot.nodes.HotSpotDirectCallTargetNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotIndirectCallTargetNode;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotJumpToExceptionHandlerInCallerOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotJumpToExceptionHandlerOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotPatchReturnAddressOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotSafepointOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotspotDirectStaticCallOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotspotDirectVirtualCallOp;
import org.graalvm.compiler.hotspot.sparc.SPARCIndirectCallOp;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCBreakpointOp;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeValueMap;

public class SPARCHotSpotNodeLIRBuilder
extends SPARCNodeLIRBuilder
implements HotSpotNodeLIRBuilder {
    public SPARCHotSpotNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen, SPARCNodeMatchRules nodeMatchRules) {
        super(graph, lirGen, nodeMatchRules);
        assert (this.gen instanceof SPARCHotSpotLIRGenerator);
        assert (this.getDebugInfoBuilder() instanceof HotSpotDebugInfoBuilder);
        ((SPARCHotSpotLIRGenerator)this.gen).setDebugInfoBuilder((HotSpotDebugInfoBuilder)this.getDebugInfoBuilder());
    }

    @Override
    protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
        HotSpotLockStack lockStack = new HotSpotLockStack(this.gen.getResult().getFrameMapBuilder(), LIRKind.value((PlatformKind)SPARCKind.XWORD));
        return new HotSpotDebugInfoBuilder(nodeValueMap, lockStack, (HotSpotLIRGenerator)((Object)this.gen));
    }

    private SPARCHotSpotLIRGenerator getGen() {
        return (SPARCHotSpotLIRGenerator)this.gen;
    }

    @Override
    public void visitSafepointNode(SafepointNode i) {
        LIRFrameState info = this.state(i);
        Register thread = this.getGen().getProviders().getRegisters().getThreadRegister();
        this.append(new SPARCHotSpotSafepointOp(info, this.getGen().config, thread, this.gen));
    }

    @Override
    protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        CallTargetNode.InvokeKind invokeKind = ((HotSpotDirectCallTargetNode)callTarget).invokeKind();
        if (invokeKind.isIndirect()) {
            this.append(new SPARCHotspotDirectVirtualCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        } else {
            assert (invokeKind.isDirect());
            HotSpotResolvedJavaMethod resolvedMethod = (HotSpotResolvedJavaMethod)callTarget.targetMethod();
            assert (resolvedMethod.isConcrete()) : "Cannot make direct call to abstract method.";
            this.append(new SPARCHotspotDirectStaticCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        }
    }

    @Override
    protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        Value metaspaceMethodSrc = this.operand(((HotSpotIndirectCallTargetNode)callTarget).metaspaceMethod());
        RegisterValue metaspaceMethod = SPARC.g5.asValue(metaspaceMethodSrc.getValueKind());
        this.gen.emitMove((AllocatableValue)metaspaceMethod, metaspaceMethodSrc);
        Value targetAddressSrc = this.operand(callTarget.computedAddress());
        RegisterValue targetAddress = SPARC.o7.asValue(targetAddressSrc.getValueKind());
        this.gen.emitMove((AllocatableValue)targetAddress, targetAddressSrc);
        this.append(new SPARCIndirectCallOp(callTarget.targetMethod(), result, parameters, temps, (Value)metaspaceMethod, (Value)targetAddress, callState, this.getGen().config));
    }

    @Override
    public void emitPatchReturnAddress(ValueNode address) {
        this.append(new SPARCHotSpotPatchReturnAddressOp(this.gen.load(this.operand(address))));
    }

    @Override
    public void emitJumpToExceptionHandler(ValueNode address) {
        this.append(new SPARCHotSpotJumpToExceptionHandlerOp(this.gen.load(this.operand(address))));
    }

    @Override
    public void emitJumpToExceptionHandlerInCaller(ValueNode handlerInCallerPc, ValueNode exception, ValueNode exceptionPc) {
        Variable handler = this.gen.load(this.operand(handlerInCallerPc));
        ForeignCallLinkage linkage = this.gen.getForeignCalls().lookupForeignCall(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER);
        CallingConvention linkageCc = linkage.getOutgoingCallingConvention();
        assert (linkageCc.getArgumentCount() == 2);
        RegisterValue exceptionFixed = (RegisterValue)linkageCc.getArgument(0);
        RegisterValue exceptionPcFixed = (RegisterValue)linkageCc.getArgument(1);
        this.gen.emitMove((AllocatableValue)exceptionFixed, this.operand(exception));
        this.gen.emitMove((AllocatableValue)exceptionPcFixed, this.operand(exceptionPc));
        Register thread = this.getGen().getProviders().getRegisters().getThreadRegister();
        SPARCHotSpotJumpToExceptionHandlerInCallerOp op = new SPARCHotSpotJumpToExceptionHandlerInCallerOp(handler, (AllocatableValue)exceptionFixed, (AllocatableValue)exceptionPcFixed, this.getGen().config.threadIsMethodHandleReturnOffset, thread);
        this.append(op);
    }

    @Override
    protected void emitPrologue(StructuredGraph graph) {
        super.emitPrologue(graph);
        SPARCHotSpotSafepointOp.emitPrologue(this, this.getGen());
    }

    @Override
    public void visitFullInfopointNode(FullInfopointNode i) {
        if (i.getState() != null && i.getState().bci == -3) {
            i.getDebug().log("Ignoring InfopointNode for AFTER_BCI");
        } else {
            super.visitFullInfopointNode(i);
        }
    }

    @Override
    public void visitBreakpointNode(BreakpointNode node) {
        JavaType[] sig = new JavaType[node.arguments().size()];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
        }
        Value[] parameters = this.visitInvokeArguments(this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, null, sig, (ValueKindFactory)this.gen), node.arguments());
        this.append(new SPARCBreakpointOp(parameters));
    }
}

