/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.gen.LIRGenerationProvider;
import org.graalvm.compiler.core.sparc.SPARCNodeMatchRules;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotDataBuilder;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotNodeLIRBuilder;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotRegisterAllocationConfig;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCCall;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCFrameMap;
import org.graalvm.compiler.lir.sparc.SPARCFrameMapBuilder;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.options.OptionValues;

public class SPARCHotSpotBackend
extends HotSpotHostBackend
implements LIRGenerationProvider {
    private static final SizeEstimateStatistics CONSTANT_ESTIMATED_STATS = new SizeEstimateStatistics("ESTIMATE");
    private static final SizeEstimateStatistics CONSTANT_ACTUAL_STATS = new SizeEstimateStatistics("ACTUAL");

    public SPARCHotSpotBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(config, runtime, providers);
    }

    @Override
    protected FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        SPARCFrameMap frameMap = new SPARCFrameMap(this.getCodeCache(), registerConfigNonNull, this);
        return new SPARCFrameMapBuilder(frameMap, this.getCodeCache(), registerConfigNonNull);
    }

    @Override
    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        return new SPARCHotSpotLIRGenerator(this.getProviders(), this.getRuntime().getVMConfig(), lirGenRes);
    }

    @Override
    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        return new SPARCHotSpotNodeLIRBuilder(graph, lirGen, new SPARCNodeMatchRules(lirGen));
    }

    @Override
    protected void bangStackWithOffset(CompilationResultBuilder crb, int bangOffset) {
        SPARCMacroAssembler masm = (SPARCMacroAssembler)crb.asm;
        SPARCAddress address = new SPARCAddress(SPARC.sp, -bangOffset);
        if (SPARCAssembler.isSimm13(address.getDisplacement())) {
            masm.stx(SPARC.g0, address);
        } else {
            try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                assert (SPARCAssembler.isGlobalRegister(scratch)) : "Only global (g1-g7) registers are allowed if the frame was not initialized here. Got register " + scratch;
                masm.setx(address.getDisplacement(), scratch, false);
                masm.stx(SPARC.g0, new SPARCAddress(SPARC.sp, scratch));
            }
        }
    }

    @Override
    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenRes, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        HotSpotLIRGenerationResult gen = (HotSpotLIRGenerationResult)lirGenRes;
        LIR lir = gen.getLIR();
        assert (gen.getDeoptimizationRescueSlot() == null || frameMap.frameNeedsAllocating()) : "method that can deoptimize must have a frame";
        Stub stub = gen.getStub();
        SPARCMacroAssembler masm = new SPARCMacroAssembler(this.getTarget());
        HotSpotFrameContext frameContext = new HotSpotFrameContext(stub != null);
        HotSpotDataBuilder dataBuilder = new HotSpotDataBuilder(this.getCodeCache().getTarget());
        OptionValues options = lir.getOptions();
        DebugContext debug = lir.getDebug();
        CompilationResultBuilder crb = factory.createBuilder((CodeCacheProvider)this.getProviders().getCodeCache(), this.getProviders().getForeignCalls(), frameMap, masm, dataBuilder, frameContext, options, debug, compilationResult, Register.None);
        crb.setTotalFrameSize(frameMap.totalFrameSize());
        crb.setMaxInterpreterFrameSize(gen.getMaxInterpreterFrameSize());
        StackSlot deoptimizationRescueSlot = gen.getDeoptimizationRescueSlot();
        if (deoptimizationRescueSlot != null && stub == null) {
            crb.compilationResult.setCustomStackAreaOffset(deoptimizationRescueSlot);
        }
        if (stub != null) {
            this.updateStub(stub, gen, frameMap);
        }
        assert (SPARCHotSpotBackend.registerSizePredictionValidator(crb, debug));
        return crb;
    }

    private static boolean registerSizePredictionValidator(CompilationResultBuilder crb, DebugContext debug) {
        class ValidationState {
            LIRInstruction op;
            final DebugContext debug;
            int constantSizeBefore;
            final /* synthetic */ CompilationResultBuilder val$crb;

            ValidationState(DebugContext debugContext) {
                this.val$crb = debugContext;
                this.debug = debug;
            }

            public void before(LIRInstruction before) {
                assert (this.op == null) : "LIRInstruction " + this.op + " no after call received";
                this.op = before;
                this.constantSizeBefore = SPARCHotSpotBackend.calculateDataSectionSize(this.val$crb.compilationResult.getDataSection());
            }

            public void after(LIRInstruction after) {
                assert (after.equals(this.op)) : "Instructions before/after don't match " + this.op + "/" + after;
                int constantSizeAfter = SPARCHotSpotBackend.calculateDataSectionSize(this.val$crb.compilationResult.getDataSection());
                int actual = constantSizeAfter - this.constantSizeBefore;
                if (this.op instanceof SPARCLIRInstructionMixin) {
                    SPARCLIRInstructionMixin.SizeEstimate size = ((SPARCLIRInstructionMixin)((Object)this.op)).estimateSize();
                    assert (size != null) : "No size prediction available for op: " + this.op;
                    Class<?> c = this.op.getClass();
                    CONSTANT_ESTIMATED_STATS.add(c, size.constantSize, this.debug);
                    CONSTANT_ACTUAL_STATS.add(c, actual, this.debug);
                    assert (size.constantSize >= actual) : "Op " + this.op + " exceeded estimated constant size; predicted: " + size.constantSize + " actual: " + actual;
                } else assert (actual == 0) : "Op " + this.op + " emitted to DataSection without any estimate.";
                this.op = null;
                this.constantSizeBefore = 0;
            }
        }
        ValidationState state = new ValidationState(debug, crb);
        crb.setOpCallback(op -> state.before((LIRInstruction)op), op -> state.after((LIRInstruction)op));
        return true;
    }

    private static int calculateDataSectionSize(DataSection ds) {
        int sum = 0;
        for (DataSection.Data d : ds) {
            sum += d.getSize();
        }
        return sum;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod installedCodeOwner) {
        SPARCMacroAssembler masm = (SPARCMacroAssembler)crb.asm;
        SPARCHotSpotBackend.stuffDelayedControlTransfers(lir);
        int constantSize = SPARCHotSpotBackend.calculateConstantSize(lir);
        boolean canUseImmediateConstantLoad = constantSize < 8192;
        masm.setImmediateConstantLoad(canUseImmediateConstantLoad);
        FrameMap frameMap = crb.frameMap;
        RegisterConfig regConfig = frameMap.getRegisterConfig();
        Label unverifiedStub = installedCodeOwner == null || installedCodeOwner.isStatic() ? null : new Label();
        for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                crb.resetForEmittingCode();
                lir.resetLabels();
                SPARCHotSpotBackend.resetDelayedControlTransfers(lir);
            }
            if (unverifiedStub != null) {
                crb.recordMark(this.config.MARKID_UNVERIFIED_ENTRY);
                CallingConvention cc = regConfig.getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, null, new JavaType[]{this.getProviders().getMetaAccess().lookupJavaType(Object.class)}, (ValueKindFactory)this);
                Register inlineCacheKlass = SPARC.g5;
                try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    Register scratch = sc.getRegister();
                    Register receiver = ValueUtil.asRegister((Value)cc.getArgument(0));
                    SPARCAddress src = new SPARCAddress(receiver, this.config.hubOffset);
                    masm.ldx(src, scratch);
                    masm.cmp(scratch, inlineCacheKlass);
                }
                SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, unverifiedStub);
                masm.nop();
            }
            masm.align(this.config.codeEntryAlignment);
            crb.recordMark(this.config.MARKID_OSR_ENTRY);
            crb.recordMark(this.config.MARKID_VERIFIED_ENTRY);
            crb.emit(lir);
        }
        this.profileInstructions(lir, crb);
        HotSpotFrameContext frameContext = (HotSpotFrameContext)crb.frameContext;
        HotSpotForeignCallsProvider foreignCalls = this.getProviders().getForeignCalls();
        if (!frameContext.isStub) {
            crb.recordMark(this.config.MARKID_EXCEPTION_HANDLER_ENTRY);
            SPARCCall.directCall(crb, masm, foreignCalls.lookupForeignCall(EXCEPTION_HANDLER), null, null);
            crb.recordMark(this.config.MARKID_DEOPT_HANDLER_ENTRY);
            SPARCCall.directCall(crb, masm, foreignCalls.lookupForeignCall(DEOPTIMIZATION_HANDLER), null, null);
        }
        if (unverifiedStub != null) {
            masm.bind(unverifiedStub);
            try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                SPARCCall.indirectJmp(crb, masm, scratch, foreignCalls.lookupForeignCall(IC_MISS_HANDLER));
            }
        }
        masm.peephole();
    }

    private static int calculateConstantSize(LIR lir) {
        int size = 0;
        for (AbstractBlockBase<?> block : lir.codeEmittingOrder()) {
            if (block == null) continue;
            for (LIRInstruction inst : lir.getLIRforBlock(block)) {
                SPARCLIRInstructionMixin.SizeEstimate pred;
                if (!(inst instanceof SPARCLIRInstructionMixin) || (pred = ((SPARCLIRInstructionMixin)((Object)inst)).estimateSize()) == null) continue;
                size += pred.constantSize;
            }
        }
        return size;
    }

    private static void resetDelayedControlTransfers(LIR lir) {
        for (AbstractBlockBase<?> block : lir.codeEmittingOrder()) {
            if (block == null) continue;
            for (LIRInstruction inst : lir.getLIRforBlock(block)) {
                if (!(inst instanceof SPARCDelayedControlTransfer)) continue;
                ((SPARCDelayedControlTransfer)((Object)inst)).resetState();
            }
        }
    }

    private static void stuffDelayedControlTransfers(LIR l) {
        for (AbstractBlockBase<?> b : l.codeEmittingOrder()) {
            if (b == null) continue;
            SPARCHotSpotBackend.stuffDelayedControlTransfers(l, b);
        }
    }

    private static void stuffDelayedControlTransfers(LIR l, AbstractBlockBase<?> block) {
        ArrayList<LIRInstruction> instructions = l.getLIRforBlock(block);
        if (instructions.size() >= 2) {
            LIRDependencyAccumulator acc = new LIRDependencyAccumulator();
            SPARCDelayedControlTransfer delayedTransfer = null;
            int delayTransferPosition = -1;
            for (int i = instructions.size() - 1; i >= 0; --i) {
                boolean overlap;
                boolean adjacent;
                LIRInstruction inst = instructions.get(i);
                boolean bl = adjacent = delayTransferPosition - i == 1;
                if (!adjacent || inst.destroysCallerSavedRegisters() || SPARCHotSpotBackend.leavesRegisterWindow(inst)) {
                    delayedTransfer = null;
                }
                if (inst instanceof SPARCDelayedControlTransfer) {
                    delayedTransfer = (SPARCDelayedControlTransfer)((Object)inst);
                    acc.start(inst);
                    delayTransferPosition = i;
                    continue;
                }
                if (delayedTransfer == null || (overlap = acc.add(inst)) || !(inst instanceof SPARCTailDelayedLIRInstruction)) continue;
                ((SPARCTailDelayedLIRInstruction)((Object)inst)).setDelayedControlTransfer(delayedTransfer);
                delayedTransfer = null;
            }
        }
    }

    private static boolean leavesRegisterWindow(LIRInstruction inst) {
        return inst instanceof SPARCLIRInstructionMixin && ((SPARCLIRInstructionMixin)((Object)inst)).leavesRegisterWindow();
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new SPARCHotSpotRegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo);
    }

    @Override
    public EconomicSet<Register> translateToCallerRegisters(EconomicSet<Register> calleeRegisters) {
        EconomicSet callerRegisters = EconomicSet.create((Equivalence)Equivalence.IDENTITY, (int)calleeRegisters.size());
        for (Register register : calleeRegisters) {
            if (SPARC.l0.number <= register.number && register.number <= SPARC.l7.number || SPARC.o0.number <= register.number && register.number <= SPARC.o7.number) continue;
            if (SPARC.i0.number <= register.number && register.number <= SPARC.i7.number) {
                callerRegisters.add((Object)this.translateInputToOutputRegister(register));
                continue;
            }
            callerRegisters.add((Object)register);
        }
        return callerRegisters;
    }

    private Register translateInputToOutputRegister(Register register) {
        assert (SPARC.i0.number <= register.number && register.number <= SPARC.i7.number) : "Not an input register " + register;
        return this.getTarget().arch.getRegisters().get(SPARC.o0.number + register.number - SPARC.i0.number);
    }

    private static class LIRDependencyAccumulator {
        private final Set<Object> inputs = new HashSet<Object>(10);
        private boolean overlap = false;
        private final InstructionValueConsumer valueConsumer = (instruction, value, mode, flags) -> {
            Value valueObject = value;
            if (ValueUtil.isRegister((Value)value)) {
                valueObject = ValueUtil.asRegister((Value)value);
            }
            if (!this.inputs.add(valueObject)) {
                this.overlap = true;
            }
        };

        private LIRDependencyAccumulator() {
        }

        public void start(LIRInstruction initial) {
            this.inputs.clear();
            this.overlap = false;
            initial.visitEachInput(this.valueConsumer);
            initial.visitEachTemp(this.valueConsumer);
            initial.visitEachAlive(this.valueConsumer);
        }

        public boolean add(LIRInstruction inst) {
            this.overlap = false;
            inst.visitEachOutput(this.valueConsumer);
            inst.visitEachTemp(this.valueConsumer);
            inst.visitEachInput(this.valueConsumer);
            inst.visitEachAlive(this.valueConsumer);
            return this.overlap;
        }
    }

    public class HotSpotFrameContext
    implements FrameContext {
        final boolean isStub;

        HotSpotFrameContext(boolean isStub) {
            this.isStub = isStub;
        }

        @Override
        public boolean hasFrame() {
            return true;
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            int frameSize = crb.frameMap.totalFrameSize();
            int stackpointerChange = -frameSize;
            SPARCMacroAssembler masm = (SPARCMacroAssembler)crb.asm;
            if (!this.isStub) {
                SPARCHotSpotBackend.this.emitStackOverflowCheck(crb);
            }
            if (SPARCAssembler.isSimm13(stackpointerChange)) {
                masm.save(SPARC.sp, stackpointerChange, SPARC.sp);
            } else {
                try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    Register scratch = sc.getRegister();
                    assert (SPARCAssembler.isGlobalRegister(scratch)) : "Only global registers are allowed before save. Got register " + scratch;
                    masm.setx(stackpointerChange, scratch, false);
                    masm.save(SPARC.sp, scratch, SPARC.sp);
                }
            }
            if (GraalOptions.ZapStackOnMethodEntry.getValue(crb.getOptions()).booleanValue()) {
                int slotSize = 8;
                for (int i = 0; i < frameSize / 8; ++i) {
                    masm.stx(SPARC.g0, new SPARCAddress(SPARC.sp, i * 8));
                }
            }
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            SPARCMacroAssembler masm = (SPARCMacroAssembler)crb.asm;
            masm.restoreWindow();
        }
    }

    private static class SizeEstimateStatistics {
        private static final ConcurrentHashMap<String, CounterKey> counters = new ConcurrentHashMap();
        private final String suffix;

        SizeEstimateStatistics(String suffix) {
            this.suffix = suffix;
        }

        public void add(Class<?> c, int count, DebugContext debug) {
            String name = SizeEstimateStatistics.class.getSimpleName() + "_" + c.getSimpleName() + "." + this.suffix;
            CounterKey m = counters.computeIfAbsent(name, n -> DebugContext.counter(n));
            m.add(debug, count);
        }
    }
}

