/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;

@ClassSubstitution(className={"java.lang.StringUTF16"}, optional=true)
public class StringUTF16Substitutions {
    private static final int MAX_LENGTH = 0x3FFFFFFF;

    @MethodSubstitution
    public static byte[] toBytes(char[] value, int srcBegin, int length) {
        if (BranchProbabilityNode.probability(0.010000000000000009, srcBegin < 0) || BranchProbabilityNode.probability(0.010000000000000009, length < 0) || BranchProbabilityNode.probability(0.010000000000000009, length > 0x3FFFFFFF) || BranchProbabilityNode.probability(0.010000000000000009, srcBegin > value.length - length)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        byte[] val = (byte[])NewArrayNode.newUninitializedArray(Byte.TYPE, length << 1);
        ArrayCopyCallNode.disjointArraycopyKillsAny(value, srcBegin, val, 0, length, JavaKind.Char, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG));
        return val;
    }

    @MethodSubstitution
    public static void getChars(byte[] value, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int length = srcEnd - srcBegin;
        if (BranchProbabilityNode.probability(0.010000000000000009, srcBegin < 0) || BranchProbabilityNode.probability(0.010000000000000009, length < 0) || BranchProbabilityNode.probability(0.010000000000000009, srcBegin > (value.length >> 1) - length) || BranchProbabilityNode.probability(0.010000000000000009, dstBegin > dst.length - length)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        ArrayCopyCallNode.disjointArraycopyKillsAny(value, srcBegin, dst, dstBegin, length, JavaKind.Char, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG));
    }
}

