/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.nodes.DimensionsNode;
import org.graalvm.compiler.hotspot.nodes.KlassBeingInitializedCheckNode;
import org.graalvm.compiler.hotspot.nodes.aot.LoadConstantIndirectlyFixedNode;
import org.graalvm.compiler.hotspot.nodes.aot.LoadConstantIndirectlyNode;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.replacements.AssertionSnippets;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HotspotSnippetsOptions;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.PiArrayNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.PrefetchAllocateNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.debug.DynamicCounterNode;
import org.graalvm.compiler.nodes.debug.VerifyHeapNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.replacements.nodes.ExplodeLoopNode;
import org.graalvm.compiler.replacements.nodes.ZeroMemoryNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class NewObjectSnippets
implements Snippets {
    public static final int MAX_ARRAY_FAST_PATH_ALLOCATION_LENGTH = 0xFFFFFF;
    public static final ForeignCallDescriptor DYNAMIC_NEW_INSTANCE = new ForeignCallDescriptor("dynamic_new_instance", Object.class, Class.class);
    public static final ForeignCallDescriptor DYNAMIC_NEW_INSTANCE_OR_NULL = new ForeignCallDescriptor("dynamic_new_instance_or_null", Object.class, Class.class);
    private static final int MAX_UNROLLED_OBJECT_ZEROING_STORES = 8;

    @Fold
    static String createName(@Fold.InjectedParameter OptionValues options, String path, String typeContext) {
        switch ((ProfileContext)((Object)HotspotSnippetsOptions.ProfileAllocationsContext.getValue(options))) {
            case AllocatingMethod: {
                return "";
            }
            case InstanceOrArray: {
                return path;
            }
            case AllocatedType: 
            case AllocatedTypesInMethod: {
                return typeContext;
            }
            case Total: {
                return "bytes";
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Fold
    static boolean doProfile(@Fold.InjectedParameter OptionValues options) {
        return HotspotSnippetsOptions.ProfileAllocations.getValue(options);
    }

    @Fold
    static boolean withContext(@Fold.InjectedParameter OptionValues options) {
        ProfileContext context = (ProfileContext)((Object)HotspotSnippetsOptions.ProfileAllocationsContext.getValue(options));
        return context == ProfileContext.AllocatingMethod || context == ProfileContext.AllocatedTypesInMethod;
    }

    protected static void profileAllocation(String path, long size, String typeContext) {
        if (NewObjectSnippets.doProfile(GraalHotSpotVMConfigBase.INJECTED_OPTIONVALUES)) {
            String name = NewObjectSnippets.createName(GraalHotSpotVMConfigBase.INJECTED_OPTIONVALUES, path, typeContext);
            boolean context = NewObjectSnippets.withContext(GraalHotSpotVMConfigBase.INJECTED_OPTIONVALUES);
            DynamicCounterNode.counter("number of bytes allocated", name, size, context);
            DynamicCounterNode.counter("number of allocations", name, 1L, context);
        }
    }

    public static void emitPrefetchAllocate(Word address, boolean isArray) {
        if (HotSpotReplacementsUtil.allocatePrefetchStyle(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG) > 0) {
            int lines = isArray ? HotSpotReplacementsUtil.allocatePrefetchLines(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG) : HotSpotReplacementsUtil.allocateInstancePrefetchLines(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
            int stepSize = HotSpotReplacementsUtil.allocatePrefetchStepSize(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
            int distance = HotSpotReplacementsUtil.allocatePrefetchDistance(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
            ExplodeLoopNode.explodeLoop();
            for (int i = 0; i < lines; ++i) {
                PrefetchAllocateNode.prefetch(OffsetAddressNode.address(address, distance));
                distance += stepSize;
            }
        }
    }

    @Snippet
    public static Object allocateInstance(@Snippet.ConstantParameter long size, KlassPointer hub, Word prototypeMarkWord, @Snippet.ConstantParameter boolean fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean constantSize, @Snippet.ConstantParameter String typeContext, @Snippet.ConstantParameter Counters counters) {
        return PiNode.piCastToSnippetReplaceeStamp(NewObjectSnippets.allocateInstanceHelper(size, hub, prototypeMarkWord, fillContents, emitMemoryBarrier, threadRegister, constantSize, typeContext, counters));
    }

    public static Object allocateInstanceHelper(long size, KlassPointer hub, Word prototypeMarkWord, boolean fillContents, boolean emitMemoryBarrier, Register threadRegister, boolean constantSize, String typeContext, Counters counters) {
        Object result;
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        Word top = HotSpotReplacementsUtil.readTlabTop(thread);
        Word end = HotSpotReplacementsUtil.readTlabEnd(thread);
        Word newTop = top.add((Word)WordFactory.unsigned((long)size));
        if (HotSpotReplacementsUtil.useTLAB(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG) && BranchProbabilityNode.probability(0.99, newTop.belowOrEqual(end))) {
            HotSpotReplacementsUtil.writeTlabTop(thread, newTop);
            NewObjectSnippets.emitPrefetchAllocate(newTop, false);
            result = NewObjectSnippets.formatObject(hub, size, top, prototypeMarkWord, fillContents, emitMemoryBarrier, constantSize, counters);
        } else {
            Counters theCounters = counters;
            if (theCounters != null && theCounters.stub != null) {
                theCounters.stub.inc();
            }
            result = NewObjectSnippets.newInstanceStub(hub);
        }
        NewObjectSnippets.profileAllocation("instance", size, typeContext);
        return HotSpotReplacementsUtil.verifyOop(result);
    }

    public static Object newInstanceStub(KlassPointer hub) {
        if (NewObjectSnippets.useNullAllocationStubs(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG)) {
            return NewObjectSnippets.nonNullOrDeopt(NewObjectSnippets.newInstanceOrNull(HotSpotBackend.NEW_INSTANCE_OR_NULL, hub));
        }
        return NewObjectSnippets.newInstance(HotSpotBackend.NEW_INSTANCE, hub);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    private static native Object newInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    private static native Object newInstanceOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1);

    @Snippet
    public static Object allocateInstancePIC(@Snippet.ConstantParameter long size, KlassPointer hub, Word prototypeMarkWord, @Snippet.ConstantParameter boolean fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean constantSize, @Snippet.ConstantParameter String typeContext, @Snippet.ConstantParameter Counters counters) {
        KlassPointer picHub = LoadConstantIndirectlyFixedNode.loadKlass(hub);
        return PiNode.piCastToSnippetReplaceeStamp(NewObjectSnippets.allocateInstanceHelper(size, picHub, prototypeMarkWord, fillContents, emitMemoryBarrier, threadRegister, constantSize, typeContext, counters));
    }

    @Snippet
    public static Object allocateInstanceDynamic(Class<?> type, Class<?> classClass, @Snippet.ConstantParameter boolean fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter Counters counters) {
        if (BranchProbabilityNode.probability(0.0, type == null)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        Class<?> nonNullType = PiNode.piCastNonNullClass(type, SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability(0.0, DynamicNewInstanceNode.throwsInstantiationException(type, classClass))) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        return PiNode.piCastToSnippetReplaceeStamp(NewObjectSnippets.allocateInstanceDynamicHelper(type, fillContents, emitMemoryBarrier, threadRegister, counters, nonNullType));
    }

    private static Object allocateInstanceDynamicHelper(Class<?> type, boolean fillContents, boolean emitMemoryBarrier, Register threadRegister, Counters counters, Class<?> nonNullType) {
        KlassPointer hub = ClassGetHubNode.readClass(nonNullType);
        if (BranchProbabilityNode.probability(0.99, !hub.isNull())) {
            KlassPointer nonNullHub = ClassGetHubNode.piCastNonNull(hub, SnippetAnchorNode.anchor());
            if (BranchProbabilityNode.probability(0.999, HotSpotReplacementsUtil.isInstanceKlassFullyInitialized(nonNullHub))) {
                int layoutHelper = HotSpotReplacementsUtil.readLayoutHelper(nonNullHub);
                if (BranchProbabilityNode.probability(0.99, (layoutHelper & 1) == 0)) {
                    Word prototypeMarkWord = nonNullHub.readWord(HotSpotReplacementsUtil.prototypeMarkWordOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG), HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION);
                    return NewObjectSnippets.allocateInstanceHelper(layoutHelper, nonNullHub, prototypeMarkWord, fillContents, emitMemoryBarrier, threadRegister, false, "", counters);
                }
            } else {
                DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
            }
        }
        return NewObjectSnippets.dynamicNewInstanceStub(type);
    }

    @Snippet
    public static Object allocatePrimitiveArrayPIC(KlassPointer hub, int length, Word prototypeMarkWord, @Snippet.ConstantParameter int headerSize, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter boolean fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter String typeContext, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter Counters counters) {
        KlassPointer picHub = LoadConstantIndirectlyNode.loadKlass(hub);
        return NewObjectSnippets.allocateArrayImpl(picHub, length, prototypeMarkWord, headerSize, log2ElementSize, fillContents, emitMemoryBarrier, threadRegister, maybeUnroll, typeContext, supportsBulkZeroing, counters);
    }

    @Snippet
    public static Object allocateArrayPIC(KlassPointer hub, int length, Word prototypeMarkWord, @Snippet.ConstantParameter int headerSize, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter boolean fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter String typeContext, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter Counters counters) {
        KlassPointer picHub = LoadConstantIndirectlyFixedNode.loadKlass(hub);
        return NewObjectSnippets.allocateArrayImpl(picHub, length, prototypeMarkWord, headerSize, log2ElementSize, fillContents, emitMemoryBarrier, threadRegister, maybeUnroll, typeContext, supportsBulkZeroing, counters);
    }

    @Snippet
    public static Object allocateArray(KlassPointer hub, int length, Word prototypeMarkWord, @Snippet.ConstantParameter int headerSize, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter boolean fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter String typeContext, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter Counters counters) {
        Object result = NewObjectSnippets.allocateArrayImpl(hub, length, prototypeMarkWord, headerSize, log2ElementSize, fillContents, emitMemoryBarrier, threadRegister, maybeUnroll, typeContext, supportsBulkZeroing, counters);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp(HotSpotReplacementsUtil.verifyOop(result), length);
    }

    @Fold
    static boolean useNullAllocationStubs(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.areNullAllocationStubsAvailable();
    }

    private static Object allocateArrayImpl(KlassPointer hub, int length, Word prototypeMarkWord, int headerSize, int log2ElementSize, boolean fillContents, boolean emitMemoryBarrier, Register threadRegister, boolean maybeUnroll, String typeContext, boolean supportsBulkZeroing, Counters counters) {
        Object result;
        long allocationSize = HotSpotReplacementsUtil.arrayAllocationSize(length, headerSize, log2ElementSize);
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        Word top = HotSpotReplacementsUtil.readTlabTop(thread);
        Word end = HotSpotReplacementsUtil.readTlabEnd(thread);
        Word newTop = top.add((Word)WordFactory.unsigned((long)allocationSize));
        if (BranchProbabilityNode.probability(0.9, UnsignedMath.belowThan(length, 0xFFFFFF)) && HotSpotReplacementsUtil.useTLAB(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG) && BranchProbabilityNode.probability(0.99, newTop.belowOrEqual(end))) {
            HotSpotReplacementsUtil.writeTlabTop(thread, newTop);
            NewObjectSnippets.emitPrefetchAllocate(newTop, true);
            Counters theCounters = counters;
            if (theCounters != null && theCounters.arrayLoopInit != null) {
                theCounters.arrayLoopInit.inc();
            }
            result = NewObjectSnippets.formatArray(hub, allocationSize, length, headerSize, top, prototypeMarkWord, fillContents, emitMemoryBarrier, maybeUnroll, supportsBulkZeroing, counters);
        } else {
            result = NewObjectSnippets.newArrayStub(hub, length);
        }
        NewObjectSnippets.profileAllocation("array", allocationSize, typeContext);
        return result;
    }

    public static Object newArrayStub(KlassPointer hub, int length) {
        if (NewObjectSnippets.useNullAllocationStubs(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG)) {
            return NewObjectSnippets.nonNullOrDeopt(NewObjectSnippets.newArrayOrNull(HotSpotBackend.NEW_ARRAY_OR_NULL, hub, length));
        }
        return NewObjectSnippets.newArray(HotSpotBackend.NEW_ARRAY, hub, length);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    private static native Object newArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    private static native Object newArrayOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2);

    public static Object dynamicNewInstanceStub(Class<?> elementType) {
        if (NewObjectSnippets.useNullAllocationStubs(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG)) {
            return NewObjectSnippets.nonNullOrDeopt(NewObjectSnippets.dynamicNewInstanceOrNull(DYNAMIC_NEW_INSTANCE_OR_NULL, elementType));
        }
        return NewObjectSnippets.dynamicNewInstance(DYNAMIC_NEW_INSTANCE, elementType);
    }

    private static Object nonNullOrDeopt(Object obj) {
        if (BranchProbabilityNode.probability(0.0, obj == null)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        return obj;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    public static native Object dynamicNewInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    public static native Object dynamicNewInstanceOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @Snippet
    public static Object allocateArrayDynamic(Class<?> elementType, Class<?> voidClass, int length, @Snippet.ConstantParameter boolean fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter JavaKind knownElementKind, @Snippet.ConstantParameter int knownLayoutHelper, @Snippet.ConstantParameter boolean supportsBulkZeroing, Word prototypeMarkWord, @Snippet.ConstantParameter Counters counters) {
        Object result = NewObjectSnippets.allocateArrayDynamicImpl(elementType, voidClass, length, fillContents, emitMemoryBarrier, threadRegister, knownElementKind, knownLayoutHelper, supportsBulkZeroing, prototypeMarkWord, counters);
        return result;
    }

    private static Object allocateArrayDynamicImpl(Class<?> elementType, Class<?> voidClass, int length, boolean fillContents, boolean emitMemoryBarrier, Register threadRegister, JavaKind knownElementKind, int knownLayoutHelper, boolean supportsBulkZeroing, Word prototypeMarkWord, Counters counters) {
        int layoutHelper;
        KlassPointer klass;
        ReplacementsUtil.staticAssert(knownElementKind != JavaKind.Void, "unsupported knownElementKind");
        if (knownElementKind == JavaKind.Illegal && BranchProbabilityNode.probability(0.010000000000000009, elementType == null || DynamicNewArrayNode.throwsIllegalArgumentException(elementType, voidClass))) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        if (BranchProbabilityNode.probability(0.0, (klass = HotSpotReplacementsUtil.loadKlassFromObject(elementType, HotSpotReplacementsUtil.arrayKlassOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG), HotSpotReplacementsUtil.CLASS_ARRAY_KLASS_LOCATION)).isNull())) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        KlassPointer nonNullKlass = ClassGetHubNode.piCastNonNull(klass, SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability(0.0, length < 0)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        if (knownElementKind == JavaKind.Illegal) {
            layoutHelper = HotSpotReplacementsUtil.readLayoutHelper(nonNullKlass);
        } else {
            ReplacementsUtil.runtimeAssert(knownLayoutHelper == HotSpotReplacementsUtil.readLayoutHelper(nonNullKlass), "layout mismatch");
            layoutHelper = knownLayoutHelper;
        }
        int headerSize = layoutHelper >> HotSpotReplacementsUtil.layoutHelperHeaderSizeShift(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG) & HotSpotReplacementsUtil.layoutHelperHeaderSizeMask(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
        int log2ElementSize = layoutHelper >> HotSpotReplacementsUtil.layoutHelperLog2ElementSizeShift(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG) & HotSpotReplacementsUtil.layoutHelperLog2ElementSizeMask(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
        Object result = NewObjectSnippets.allocateArrayImpl(nonNullKlass, length, prototypeMarkWord, headerSize, log2ElementSize, fillContents, emitMemoryBarrier, threadRegister, false, "dynamic type", supportsBulkZeroing, counters);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp(HotSpotReplacementsUtil.verifyOop(result), length);
    }

    @Snippet
    private static Object newmultiarray(KlassPointer hub, @Snippet.ConstantParameter int rank, @Snippet.VarargsParameter int[] dimensions) {
        Word dims = DimensionsNode.allocaDimsArray(rank);
        ExplodeLoopNode.explodeLoop();
        for (int i = 0; i < rank; ++i) {
            dims.writeInt(i * 4, dimensions[i], LocationIdentity.init());
        }
        return NewObjectSnippets.newMultiArrayStub(hub, rank, dims);
    }

    private static Object newMultiArrayStub(KlassPointer hub, int rank, Word dims) {
        if (NewObjectSnippets.useNullAllocationStubs(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG)) {
            return NewObjectSnippets.nonNullOrDeopt(NewObjectSnippets.newMultiArrayOrNull(HotSpotBackend.NEW_MULTI_ARRAY_OR_NULL, hub, rank, dims));
        }
        return NewObjectSnippets.newMultiArray(HotSpotBackend.NEW_MULTI_ARRAY, hub, rank, dims);
    }

    @Snippet
    private static Object newmultiarrayPIC(KlassPointer hub, @Snippet.ConstantParameter int rank, @Snippet.VarargsParameter int[] dimensions) {
        KlassPointer picHub = LoadConstantIndirectlyFixedNode.loadKlass(hub);
        return NewObjectSnippets.newmultiarray(picHub, rank, dimensions);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    private static native Object newMultiArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2, Word var3);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    private static native Object newMultiArrayOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2, Word var3);

    private static void zeroMemory(Word memory, int startOffset, long endOffset, boolean isEndOffsetConstant, boolean manualUnroll, boolean supportsBulkZeroing, Counters counters) {
        NewObjectSnippets.fillMemory(0L, memory, startOffset, endOffset, isEndOffsetConstant, manualUnroll, supportsBulkZeroing, counters);
    }

    private static void fillMemory(long value, Word memory, int startOffset, long endOffset, boolean constantOffsetLimit, boolean manualUnroll, boolean supportsBulkZeroing, Counters counters) {
        ReplacementsUtil.runtimeAssert((endOffset & 7L) == 0L, "unaligned object size");
        int offset = startOffset;
        if ((offset & 7) != 0) {
            memory.writeInt(offset, (int)value, LocationIdentity.init());
            offset += 4;
        }
        ReplacementsUtil.runtimeAssert((offset & 7) == 0, "unaligned offset");
        Counters theCounters = counters;
        if (manualUnroll && (endOffset - (long)offset) / 8L <= 8L) {
            ReplacementsUtil.staticAssert(!constantOffsetLimit, "size shouldn't be constant at instantiation time");
            if (theCounters != null && theCounters.instanceSeqInit != null) {
                theCounters.instanceSeqInit.inc();
            }
            ExplodeLoopNode.explodeLoop();
            int i = 0;
            while (i < 8 && (long)offset != endOffset) {
                memory.initializeLong(offset, value, LocationIdentity.init());
                ++i;
                offset += 8;
            }
        } else {
            Word off = (Word)WordFactory.signed((int)offset);
            if (supportsBulkZeroing && value == 0L && BranchProbabilityNode.probability(0.010000000000000009, endOffset - (long)offset >= (long)NewObjectSnippets.getMinimalBulkZeroingSize(GraalHotSpotVMConfigBase.INJECTED_OPTIONVALUES))) {
                if (theCounters != null && theCounters.instanceBulkInit != null) {
                    theCounters.instanceBulkInit.inc();
                }
                ZeroMemoryNode.zero(memory.add(off), endOffset - (long)offset, true, LocationIdentity.init());
            } else {
                if (constantOffsetLimit && (endOffset - (long)offset) / 8L <= 8L) {
                    if (theCounters != null && theCounters.instanceSeqInit != null) {
                        theCounters.instanceSeqInit.inc();
                    }
                    ExplodeLoopNode.explodeLoop();
                } else if (theCounters != null && theCounters.instanceLoopInit != null) {
                    theCounters.instanceLoopInit.inc();
                }
                while (off.rawValue() < endOffset) {
                    memory.initializeLong((WordBase)off, value, LocationIdentity.init());
                    off = off.add(8);
                }
            }
        }
    }

    @Fold
    static int getMinimalBulkZeroingSize(@Fold.InjectedParameter OptionValues optionValues) {
        return GraalOptions.MinimalBulkZeroingSize.getValue(optionValues);
    }

    private static void fillWithGarbage(Word memory, int startOffset, long endOffset, boolean isEndOffsetConstant, boolean manualUnroll, Counters counters) {
        NewObjectSnippets.fillMemory(-72340172838076674L, memory, startOffset, endOffset, isEndOffsetConstant, manualUnroll, false, counters);
    }

    private static Object formatObject(KlassPointer hub, long size, Word memory, Word compileTimePrototypeMarkWord, boolean fillContents, boolean emitMemoryBarrier, boolean constantSize, Counters counters) {
        Word prototypeMarkWord = HotSpotReplacementsUtil.useBiasedLocking(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG) ? hub.readWord(HotSpotReplacementsUtil.prototypeMarkWordOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG), HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION) : compileTimePrototypeMarkWord;
        HotSpotReplacementsUtil.initializeObjectHeader(memory, prototypeMarkWord, hub);
        if (fillContents) {
            NewObjectSnippets.zeroMemory(memory, HotSpotReplacementsUtil.instanceHeaderSize(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG), size, constantSize, false, false, counters);
        } else if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
            NewObjectSnippets.fillWithGarbage(memory, HotSpotReplacementsUtil.instanceHeaderSize(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG), size, constantSize, false, counters);
        }
        if (emitMemoryBarrier) {
            MembarNode.memoryBarrier(8, LocationIdentity.init());
        }
        return memory.toObjectNonNull();
    }

    @Snippet
    private static void verifyHeap(@Snippet.ConstantParameter Register threadRegister) {
        Word topValueContents;
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        Word topValue = HotSpotReplacementsUtil.readTlabTop(thread);
        if (!topValue.equal((Word)WordFactory.zero()) && (topValueContents = (Word)topValue.readWord(0, HotSpotReplacementsUtil.MARK_WORD_LOCATION)).equal((Word)WordFactory.zero())) {
            AssertionSnippets.vmMessageC(AssertionSnippets.ASSERTION_VM_MESSAGE_C, true, CStringConstant.cstring("overzeroing of TLAB detected"), 0L, 0L, 0L);
        }
    }

    @Snippet
    private static void threadBeingInitializedCheck(@Snippet.ConstantParameter Register threadRegister, KlassPointer klass) {
        byte state = HotSpotReplacementsUtil.readInstanceKlassInitState(klass);
        if (state != HotSpotReplacementsUtil.instanceKlassStateBeingInitialized(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG)) {
            DeoptimizeNode.deopt(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.RuntimeConstraint);
        } else if (HotSpotReplacementsUtil.registerAsWord(threadRegister) != HotSpotReplacementsUtil.readInstanceKlassInitThread(klass)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
    }

    private static Object formatArray(KlassPointer hub, long allocationSize, int length, int headerSize, Word memory, Word prototypeMarkWord, boolean fillContents, boolean emitMemoryBarrier, boolean maybeUnroll, boolean supportsBulkZeroing, Counters counters) {
        memory.writeInt(HotSpotReplacementsUtil.arrayLengthOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG), length, LocationIdentity.init());
        HotSpotReplacementsUtil.initializeObjectHeader(memory, prototypeMarkWord, hub);
        if (fillContents) {
            NewObjectSnippets.zeroMemory(memory, headerSize, allocationSize, false, maybeUnroll, supportsBulkZeroing, counters);
        } else if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
            NewObjectSnippets.fillWithGarbage(memory, headerSize, allocationSize, false, maybeUnroll, counters);
        }
        if (emitMemoryBarrier) {
            MembarNode.memoryBarrier(8, LocationIdentity.init());
        }
        return memory.toObjectNonNull();
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo allocateInstance = this.snippet(NewObjectSnippets.class, "allocateInstance", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION, HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION);
        private final SnippetTemplate.SnippetInfo allocateInstancePIC = this.snippet(NewObjectSnippets.class, "allocateInstancePIC", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION, HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION);
        private final SnippetTemplate.SnippetInfo allocateArray = this.snippet(NewObjectSnippets.class, "allocateArray", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
        private final SnippetTemplate.SnippetInfo allocateArrayPIC = this.snippet(NewObjectSnippets.class, "allocateArrayPIC", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
        private final SnippetTemplate.SnippetInfo allocatePrimitiveArrayPIC = this.snippet(NewObjectSnippets.class, "allocatePrimitiveArrayPIC", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
        private final SnippetTemplate.SnippetInfo allocateArrayDynamic = this.snippet(NewObjectSnippets.class, "allocateArrayDynamic", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
        private final SnippetTemplate.SnippetInfo allocateInstanceDynamic = this.snippet(NewObjectSnippets.class, "allocateInstanceDynamic", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION, HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION, HotSpotReplacementsUtil.CLASS_INIT_STATE_LOCATION);
        private final SnippetTemplate.SnippetInfo newmultiarray = this.snippet(NewObjectSnippets.class, "newmultiarray", HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
        private final SnippetTemplate.SnippetInfo newmultiarrayPIC = this.snippet(NewObjectSnippets.class, "newmultiarrayPIC", HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
        private final SnippetTemplate.SnippetInfo verifyHeap = this.snippet(NewObjectSnippets.class, "verifyHeap", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo threadBeingInitializedCheck = this.snippet(NewObjectSnippets.class, "threadBeingInitializedCheck", new LocationIdentity[0]);
        private final GraalHotSpotVMConfig config;
        private final Counters counters;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, HotSpotProviders providers, TargetDescription target, GraalHotSpotVMConfig config) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
            this.config = config;
            this.counters = new Counters(factory);
        }

        public void lower(NewInstanceNode newInstanceNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            StructuredGraph graph = newInstanceNode.graph();
            HotSpotResolvedObjectType type = (HotSpotResolvedObjectType)newInstanceNode.instanceClass();
            assert (!type.isArray());
            ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), type.klass(), this.providers.getMetaAccess(), graph);
            long size = Templates.instanceSize(type);
            OptionValues localOptions = graph.getOptions();
            SnippetTemplate.SnippetInfo snippet = GraalOptions.GeneratePIC.getValue(localOptions) != false ? this.allocateInstancePIC : this.allocateInstance;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.addConst("size", size);
            args.add("hub", hub);
            args.add("prototypeMarkWord", type.prototypeMarkWord());
            args.addConst("fillContents", newInstanceNode.fillContents());
            args.addConst("emitMemoryBarrier", newInstanceNode.emitMemoryBarrier());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.addConst("constantSize", true);
            args.addConst("typeContext", HotspotSnippetsOptions.ProfileAllocations.getValue(localOptions) != false ? type.toJavaName(false) : "");
            args.addConst("counters", this.counters);
            SnippetTemplate template = this.template(newInstanceNode, args);
            graph.getDebug().log("Lowering allocateInstance in %s: node=%s, template=%s, arguments=%s", graph, (Object)newInstanceNode, (Object)template, (Object)args);
            template.instantiate(this.providers.getMetaAccess(), newInstanceNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(NewArrayNode newArrayNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            StructuredGraph graph = newArrayNode.graph();
            ResolvedJavaType elementType = newArrayNode.elementType();
            HotSpotResolvedObjectType arrayType = (HotSpotResolvedObjectType)elementType.getArrayClass();
            JavaKind elementKind = elementType.getJavaKind();
            ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), arrayType.klass(), this.providers.getMetaAccess(), graph);
            int headerSize = tool.getMetaAccess().getArrayBaseOffset(elementKind);
            int log2ElementSize = CodeUtil.log2((int)tool.getMetaAccess().getArrayIndexScale(elementKind));
            OptionValues localOptions = graph.getOptions();
            SnippetTemplate.SnippetInfo snippet = GraalOptions.GeneratePIC.getValue(localOptions).booleanValue() ? (elementType.isPrimitive() ? this.allocatePrimitiveArrayPIC : this.allocateArrayPIC) : this.allocateArray;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("hub", hub);
            ValueNode length = newArrayNode.length();
            args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs(length));
            assert (arrayType.prototypeMarkWord() == Templates.lookupArrayClass(tool, JavaKind.Object).prototypeMarkWord()) : "all array types are assumed to have the same prototypeMarkWord";
            args.add("prototypeMarkWord", arrayType.prototypeMarkWord());
            args.addConst("headerSize", headerSize);
            args.addConst("log2ElementSize", log2ElementSize);
            args.addConst("fillContents", newArrayNode.fillContents());
            args.addConst("emitMemoryBarrier", newArrayNode.emitMemoryBarrier());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.addConst("maybeUnroll", length.isConstant());
            args.addConst("typeContext", HotspotSnippetsOptions.ProfileAllocations.getValue(localOptions) != false ? arrayType.toJavaName(false) : "");
            args.addConst("supportsBulkZeroing", tool.getLowerer().supportsBulkZeroing());
            args.addConst("counters", this.counters);
            SnippetTemplate template = this.template(newArrayNode, args);
            graph.getDebug().log("Lowering allocateArray in %s: node=%s, template=%s, arguments=%s", graph, (Object)newArrayNode, (Object)template, (Object)args);
            template.instantiate(this.providers.getMetaAccess(), newArrayNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(DynamicNewInstanceNode newInstanceNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.allocateInstanceDynamic, newInstanceNode.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", newInstanceNode.getInstanceType());
            ValueNode classClass = newInstanceNode.getClassClass();
            assert (classClass != null);
            args.add("classClass", classClass);
            args.addConst("fillContents", newInstanceNode.fillContents());
            args.addConst("emitMemoryBarrier", newInstanceNode.emitMemoryBarrier());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.addConst("counters", this.counters);
            SnippetTemplate template = this.template(newInstanceNode, args);
            template.instantiate(this.providers.getMetaAccess(), newInstanceNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(DynamicNewArrayNode newArrayNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            StructuredGraph graph = newArrayNode.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.allocateArrayDynamic, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("elementType", newArrayNode.getElementType());
            ValueNode voidClass = newArrayNode.getVoidClass();
            assert (voidClass != null);
            args.add("voidClass", voidClass);
            ValueNode length = newArrayNode.length();
            args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs(length));
            args.addConst("fillContents", newArrayNode.fillContents());
            args.addConst("emitMemoryBarrier", newArrayNode.emitMemoryBarrier());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.addConst("knownElementKind", newArrayNode.getKnownElementKind() == null ? JavaKind.Illegal : newArrayNode.getKnownElementKind());
            if (newArrayNode.getKnownElementKind() != null) {
                args.addConst("knownLayoutHelper", Templates.lookupArrayClass(tool, newArrayNode.getKnownElementKind()).layoutHelper());
            } else {
                args.addConst("knownLayoutHelper", 0);
            }
            args.addConst("supportsBulkZeroing", tool.getLowerer().supportsBulkZeroing());
            args.add("prototypeMarkWord", Templates.lookupArrayClass(tool, JavaKind.Object).prototypeMarkWord());
            args.addConst("counters", this.counters);
            SnippetTemplate template = this.template(newArrayNode, args);
            template.instantiate(this.providers.getMetaAccess(), newArrayNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        private static HotSpotResolvedObjectType lookupArrayClass(LoweringTool tool, JavaKind kind) {
            return (HotSpotResolvedObjectType)tool.getMetaAccess().lookupJavaType(kind == JavaKind.Object ? Object.class : kind.toJavaClass()).getArrayClass();
        }

        public void lower(NewMultiArrayNode newmultiarrayNode, LoweringTool tool) {
            StructuredGraph graph = newmultiarrayNode.graph();
            OptionValues localOptions = graph.getOptions();
            int rank = newmultiarrayNode.dimensionCount();
            ValueNode[] dims = new ValueNode[rank];
            for (int i = 0; i < newmultiarrayNode.dimensionCount(); ++i) {
                dims[i] = newmultiarrayNode.dimension(i);
            }
            HotSpotResolvedObjectType type = (HotSpotResolvedObjectType)newmultiarrayNode.type();
            ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), type.klass(), this.providers.getMetaAccess(), graph);
            SnippetTemplate.SnippetInfo snippet = GraalOptions.GeneratePIC.getValue(localOptions) != false ? this.newmultiarrayPIC : this.newmultiarray;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("hub", hub);
            args.addConst("rank", rank);
            args.addVarargs("dimensions", Integer.TYPE, StampFactory.forKind(JavaKind.Int), dims);
            this.template(newmultiarrayNode, args).instantiate(this.providers.getMetaAccess(), newmultiarrayNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        private static long instanceSize(HotSpotResolvedObjectType type) {
            long size = type.instanceSize();
            assert (size >= 0L);
            return size;
        }

        public void lower(VerifyHeapNode verifyHeapNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            if (this.config.cAssertions) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.verifyHeap, verifyHeapNode.graph().getGuardsStage(), tool.getLoweringStage());
                args.addConst("threadRegister", registers.getThreadRegister());
                SnippetTemplate template = this.template(verifyHeapNode, args);
                template.instantiate(this.providers.getMetaAccess(), verifyHeapNode, SnippetTemplate.DEFAULT_REPLACER, args);
            } else {
                GraphUtil.removeFixedWithUnusedInputs(verifyHeapNode);
            }
        }

        public void lower(KlassBeingInitializedCheckNode verifyHeapNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.threadBeingInitializedCheck, verifyHeapNode.graph().getGuardsStage(), tool.getLoweringStage());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.add("klass", verifyHeapNode.getKlass());
            SnippetTemplate template = this.template(verifyHeapNode, args);
            template.instantiate(this.providers.getMetaAccess(), verifyHeapNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    static class Counters {
        final SnippetCounter instanceSeqInit;
        final SnippetCounter instanceLoopInit;
        final SnippetCounter instanceBulkInit;
        final SnippetCounter arrayLoopInit;
        final SnippetCounter stub;

        Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group newInstance = factory.createSnippetCounterGroup("NewInstance");
            SnippetCounter.Group newArray = factory.createSnippetCounterGroup("NewArray");
            this.instanceSeqInit = new SnippetCounter(newInstance, "tlabSeqInit", "TLAB alloc with unrolled zeroing");
            this.instanceLoopInit = new SnippetCounter(newInstance, "tlabLoopInit", "TLAB alloc with zeroing in a loop");
            this.instanceBulkInit = new SnippetCounter(newArray, "tlabBulkInit", "TLAB alloc with bulk zeroing");
            this.arrayLoopInit = new SnippetCounter(newArray, "tlabLoopInit", "TLAB alloc with zeroing in a loop");
            this.stub = new SnippetCounter(newInstance, "stub", "alloc and zeroing via stub");
        }
    }

    static enum ProfileContext {
        AllocatingMethod,
        InstanceOrArray,
        AllocatedType,
        AllocatedTypesInMethod,
        Total;

    }
}

