/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.GraalHotSpotVMConfigNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import org.graalvm.compiler.nodes.gc.SerialWriteBarrier;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.gc.SerialWriteBarrierSnippets;
import org.graalvm.compiler.replacements.gc.WriteBarrierSnippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.WordFactory;

public class HotSpotSerialWriteBarrierSnippets
extends SerialWriteBarrierSnippets {
    private final GraalHotSpotVMConfig config;

    public HotSpotSerialWriteBarrierSnippets(GraalHotSpotVMConfig config) {
        this.config = config;
    }

    @Override
    public Word cardTableAddress() {
        return (Word)WordFactory.unsigned((long)GraalHotSpotVMConfigNode.cardTableAddress());
    }

    @Override
    public int cardTableShift() {
        return HotSpotReplacementsUtil.cardTableShift(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    public boolean verifyBarrier() {
        return ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED || this.config.verifyBeforeGC || this.config.verifyAfterGC;
    }

    @Override
    protected byte dirtyCardValue() {
        return this.config.dirtyCardValue;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo serialImpreciseWriteBarrier;
        private final SnippetTemplate.SnippetInfo serialPreciseWriteBarrier;
        private final SnippetTemplate.SnippetInfo serialArrayRangeWriteBarrier;
        private final SerialWriteBarrierSnippets.SerialWriteBarrierLowerer lowerer;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, HotSpotProviders providers, TargetDescription target, GraalHotSpotVMConfig config) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
            this.lowerer = new SerialWriteBarrierSnippets.SerialWriteBarrierLowerer(factory);
            HotSpotSerialWriteBarrierSnippets receiver = new HotSpotSerialWriteBarrierSnippets(config);
            this.serialImpreciseWriteBarrier = this.snippet(SerialWriteBarrierSnippets.class, "serialImpreciseWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION);
            this.serialPreciseWriteBarrier = this.snippet(SerialWriteBarrierSnippets.class, "serialPreciseWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION);
            this.serialArrayRangeWriteBarrier = this.snippet(SerialWriteBarrierSnippets.class, "serialArrayRangeWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION);
        }

        public void lower(SerialWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower(this, this.serialPreciseWriteBarrier, this.serialImpreciseWriteBarrier, barrier, tool);
        }

        public void lower(SerialArrayRangeWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower(this, this.serialArrayRangeWriteBarrier, barrier, tool);
        }
    }
}

